'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Copyright (c) 2007 iReasoning, Inc.  All rights reserved                    '
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' Retrieve the disk utilization of C: drive for a single processor machine.
'Usage:     cscript //Nologo disk.vbs computerName userName password driveName
'Example:   cscript //Nologo disk.vbs server test testpass c:
'or (if no auth required):        cscript //Nologo  disk.vbs computerName 
On Error Resume Next 
Function HandleError
    If Err.Number <> vbEmpty Then
        Wscript.Echo "Error number " & Err.Number & ". Description: " & err.Description
        Wscript.Quit(Err.Number)
    End If
End Function

Set objSWbemLocator = CreateObject("WbemScripting.SWbemLocator")
strDomain = "DOMAIN" 
strDrive = ""
Select Case WScript.Arguments.Count
  Case 2
    strComputer = Wscript.Arguments(0)
    Set objSWbemServices = objSWbemLocator.ConnectServer(strComputer,  "root\cimv2")
    strDrive = Wscript.Arguments(1)
    call HandleError
    
  Case 4
    strComputer = Wscript.Arguments(0)
    strUser = Wscript.Arguments(1)
    strPassword = Wscript.Arguments(2)
    strDrive = Wscript.Arguments(3)
    Set objSWbemServices = objSWbemLocator.ConnectServer(strComputer, _
        "root\cimv2", _
         strUser, _
         strPassword, _
         "MS_409", _
         "ntlmdomain:" + strDomain)
    call HandleError
  Case 5
    strComputer = Wscript.Arguments(0)
    strUser = Wscript.Arguments(1)
    strPassword = Wscript.Arguments(2)
    pDomain = Wscript.Arguments(3)
    strDrive = Wscript.Arguments(4)
    Set objSWbemServices = objSWbemLocator.ConnectServer(strComputer, _
        "root\cimv2", _
         strUser, _
         strPassword, _
         "MS_409", _
         "ntlmdomain:" + pDomain)
    call HandleError

  Case Else
	WScript.Echo "Error: Wrong number of arguments"
    WScript.Quit(1)

End Select

 
'If you want to monitor D: drive, just need to change the "C:" to "D:" in the following line
Set colSwbemObjectSet = objSWbemServices.ExecQuery("Select * From Win32_LogicalDisk Where DeviceID = '" & strDrive & "'")
call HandleError
SetLocale("en-us")    
For Each objProcess in colSWbemObjectSet
    Wscript.Echo  FormatNumber((objProcess.Size - objProcess.FreeSpace) * 100.0 / objProcess.Size, 3)
Next
call HandleError

