#!/bin/bash
if [[ $UID != 0 ]]; then
    echo "Must run as root"
    exit
fi
SELINUXSTATUS=$(getenforce)
if [ $SELINUXSTATUS == "Enforcing" ]; then
   echo "SELINUX must be in a non-enforcing mode in order to run SysUpTime as service.
   echo "You can edit /etc/selinux/config and set"
   echo "SELINUX to permissive or disabled."
   echo "Then restart linux."
   exit
fi

DIRNAME=`dirname $0`
input="$DIRNAME/../server/default/database/bin/start.sh"
output="$DIRNAME/$RANDOM.sh"
lname=`logname`
while IFS= read -r line
do
    if [[ $line == *"pg_ctl"* ]] && [[ $line  != *"sudo "* ]] ; then
        echo "sudo -u $lname $line" >> $output
    else
        echo $line >> $output
    fi
done < "$input"
chmod +x $output
cp -f $output $input
rm -f $output
$DIRNAME/sysuptime install
