/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfRow;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable {
    private ArrayList rowsList = new ArrayList();
    private RtfWriter writer = null;
    private Table origTable = null;

    public RtfTable(RtfWriter rtfWriter) {
        this.writer = rtfWriter;
    }

    public boolean importTable(Table table, int n) {
        this.origTable = table;
        Iterator iterator = table.iterator();
        Row row = null;
        int n2 = (int)table.widthPercentage();
        int n3 = (int)((double)table.cellpadding() * 20.0);
        int n4 = (int)((double)table.cellspacing() * 20.0);
        float[] fArray = table.getProportionalWidths();
        int n5 = table.border();
        Color color = table.borderColor();
        float f = table.borderWidth();
        int n6 = 0;
        while (n6 < table.size()) {
            RtfRow rtfRow = new RtfRow(this.writer, this);
            rtfRow.pregenerateRows(table.columns());
            this.rowsList.add(rtfRow);
            ++n6;
        }
        int n7 = 0;
        while (iterator.hasNext()) {
            row = (Row)iterator.next();
            row.setHorizontalAlignment(table.alignment());
            RtfRow rtfRow = (RtfRow)this.rowsList.get(n7);
            rtfRow.importRow(row, fArray, n2, n, n3, n4, n5, color, f, n7);
            ++n7;
        }
        return true;
    }

    public boolean writeTable(ByteArrayOutputStream byteArrayOutputStream) throws DocumentException, IOException {
        int n = this.rowsList.size();
        int n2 = 0;
        while (n2 < n) {
            RtfRow rtfRow = (RtfRow)this.rowsList.get(n2);
            rtfRow.writeRow(byteArrayOutputStream, n2, this.origTable);
            byteArrayOutputStream.write(10);
            ++n2;
        }
        if (!this.writer.writingHeaderFooter()) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraphDefaults);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraph);
        }
        return true;
    }

    public void setMerge(int n, int n2, int n3, RtfCell rtfCell) {
        RtfRow rtfRow = (RtfRow)this.rowsList.get(n2);
        rtfRow.setMerge(n, n3, rtfCell);
    }

    protected Table getOriginalTable() {
        return this.origTable;
    }
}

