/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BidiLine;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfLine;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ColumnText {
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    protected int runDirection = 0;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected int alignment = 0;
    protected ArrayList leftWall;
    protected ArrayList rightWall;
    protected BidiLine bidiLine = new BidiLine();
    protected float yLine;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte canvas;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float rectangularWidth = -1.0f;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private int linesWritten;
    private int arabicOptions = 0;
    protected float descender;

    public ColumnText(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
    }

    public static ColumnText duplicate(ColumnText columnText) {
        ColumnText columnText2 = new ColumnText(null);
        columnText2.setSimpleVars(columnText);
        columnText2.bidiLine = new BidiLine(columnText.bidiLine);
        return columnText2;
    }

    public ColumnText setACopy(ColumnText columnText) {
        this.setSimpleVars(columnText);
        this.bidiLine = new BidiLine(columnText.bidiLine);
        return this;
    }

    protected void setSimpleVars(ColumnText columnText) {
        this.maxY = columnText.maxY;
        this.minY = columnText.minY;
        this.alignment = columnText.alignment;
        this.leftWall = null;
        if (columnText.leftWall != null) {
            this.leftWall = new ArrayList(columnText.leftWall);
        }
        this.rightWall = null;
        if (columnText.rightWall != null) {
            this.rightWall = new ArrayList(columnText.rightWall);
        }
        this.yLine = columnText.yLine;
        this.currentLeading = columnText.currentLeading;
        this.fixedLeading = columnText.fixedLeading;
        this.multipliedLeading = columnText.multipliedLeading;
        this.canvas = columnText.canvas;
        this.lineStatus = columnText.lineStatus;
        this.indent = columnText.indent;
        this.followingIndent = columnText.followingIndent;
        this.rightIndent = columnText.rightIndent;
        this.extraParagraphSpace = columnText.extraParagraphSpace;
        this.rectangularWidth = columnText.rectangularWidth;
        this.spaceCharRatio = columnText.spaceCharRatio;
        this.lastWasNewline = columnText.lastWasNewline;
        this.linesWritten = columnText.linesWritten;
        this.arabicOptions = columnText.arabicOptions;
        this.descender = columnText.descender;
    }

    public void addText(Phrase phrase) {
        Iterator iterator = ((AbstractList)phrase.getChunks()).iterator();
        while (iterator.hasNext()) {
            this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
        }
    }

    public void addText(Chunk chunk) {
        this.bidiLine.addChunk(new PdfChunk(chunk, null));
    }

    protected ArrayList convertColumn(float[] fArray) {
        if (fArray.length < 4) {
            throw new RuntimeException("No valid column line found.");
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n = 0;
        while (n < fArray.length - 2) {
            float f = fArray[n];
            float f2 = fArray[n + 1];
            float f3 = fArray[n + 2];
            float f4 = fArray[n + 3];
            if (f2 != f4) {
                float f5 = (f - f3) / (f2 - f4);
                float f6 = f - f5 * f2;
                float[] fArray2 = new float[]{Math.min(f2, f4), Math.max(f2, f4), f5, f6};
                arrayList.add(fArray2);
                this.maxY = Math.max(this.maxY, fArray2[1]);
                this.minY = Math.min(this.minY, fArray2[0]);
            }
            n += 2;
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("No valid column line found.");
        }
        return arrayList;
    }

    protected float findLimitsPoint(ArrayList arrayList) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        int n = 0;
        while (n < arrayList.size()) {
            float[] fArray = (float[])arrayList.get(n);
            if (!(this.yLine < fArray[0]) && !(this.yLine > fArray[1])) {
                return fArray[2] * this.yLine + fArray[3];
            }
            ++n;
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float f = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float f2 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{f, f2};
    }

    protected float[] findLimitsTwoLines() {
        float[] fArray;
        float[] fArray2;
        boolean bl = false;
        while (true) {
            if (bl && this.currentLeading == 0.0f) {
                return null;
            }
            bl = true;
            fArray2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            fArray = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(fArray2[0] >= fArray[1]) && !(fArray[0] >= fArray2[1])) break;
        }
        return new float[]{fArray2[0], fArray2[1], fArray[0], fArray[1]};
    }

    public void setColumns(float[] fArray, float[] fArray2) {
        this.rightWall = this.convertColumn(fArray2);
        this.leftWall = this.convertColumn(fArray);
        this.rectangularWidth = -1.0f;
    }

    public void setSimpleColumn(Phrase phrase, float f, float f2, float f3, float f4, float f5, int n) {
        this.addText(phrase);
        this.setSimpleColumn(f, f2, f3, f4, f5, n);
    }

    public void setSimpleColumn(float f, float f2, float f3, float f4, float f5, int n) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        fArray[0] = Math.min(f, f3);
        fArray[1] = Math.max(f2, f4);
        fArray[2] = fArray[0];
        fArray[3] = Math.min(f2, f4);
        fArray2[0] = Math.max(f, f3);
        fArray2[1] = fArray[1];
        fArray2[2] = fArray2[0];
        fArray2[3] = fArray[3];
        this.setColumns(fArray, fArray2);
        this.setLeading(f5);
        this.alignment = n;
        this.yLine = fArray[1];
        this.rectangularWidth = Math.abs(f - f3);
    }

    public void setLeading(float f) {
        this.fixedLeading = f;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float f, float f2) {
        this.fixedLeading = f;
        this.multipliedLeading = f2;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float f) {
        this.yLine = f;
    }

    public float getYLine() {
        return this.yLine;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float f) {
        this.indent = f;
        this.lastWasNewline = true;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float f) {
        this.followingIndent = f;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float f) {
        this.rightIndent = f;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean bl) throws DocumentException {
        int n;
        PdfContentByte pdfContentByte;
        boolean bl2;
        block25: {
            this.descender = 0.0f;
            this.linesWritten = 0;
            bl2 = false;
            float f = this.spaceCharRatio;
            Object[] objectArray = new Object[2];
            PdfFont pdfFont = null;
            Float f2 = new Float(0.0f);
            objectArray[1] = f2;
            PdfDocument pdfDocument = null;
            PdfContentByte pdfContentByte2 = null;
            pdfContentByte = null;
            int n2 = 1;
            if (this.runDirection != 0) {
                n2 = this.runDirection;
            }
            if (this.canvas != null) {
                pdfContentByte2 = this.canvas;
                pdfDocument = this.canvas.getPdfDocument();
                pdfContentByte = this.canvas.getDuplicate();
            } else if (!bl) {
                throw new NullPointerException("ColumnText.go with simulate==false and text==null.");
            }
            if (!bl) {
                if (f == 0.0f) {
                    f = pdfContentByte.getPdfWriter().getSpaceCharRatio();
                } else if (f < 0.001f) {
                    f = 0.001f;
                }
            }
            float f3 = 0.0f;
            n = 0;
            if (this.rectangularWidth > 0.0f) {
                while (true) {
                    float f4 = f3 = this.lastWasNewline ? this.indent : this.followingIndent;
                    if (this.rectangularWidth <= f3 + this.rightIndent) {
                        n = 2;
                        if (this.bidiLine.isEmpty()) {
                            n |= 1;
                        }
                        break block25;
                    }
                    if (this.bidiLine.isEmpty()) {
                        n = 1;
                        break block25;
                    }
                    float f5 = this.yLine;
                    PdfLine pdfLine = this.bidiLine.processLine(this.rectangularWidth - f3 - this.rightIndent, this.alignment, n2, this.arabicOptions);
                    if (pdfLine == null) {
                        n = 1;
                        break block25;
                    }
                    float f6 = pdfLine.getMaxSizeSimple();
                    this.currentLeading = this.fixedLeading + f6 * this.multipliedLeading;
                    float[] fArray = this.findLimitsTwoLines();
                    if (fArray == null) {
                        n = 2;
                        this.yLine = f5;
                        this.bidiLine.restore();
                        break block25;
                    }
                    float f7 = Math.max(fArray[0], fArray[2]);
                    if (!bl && !bl2) {
                        pdfContentByte.beginText();
                        bl2 = true;
                    }
                    if (!bl) {
                        objectArray[0] = pdfFont;
                        pdfContentByte.setTextMatrix(f7 + (pdfLine.isRTL() ? this.rightIndent : f3) + pdfLine.indentLeft(), this.yLine);
                        pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f);
                        pdfFont = (PdfFont)objectArray[0];
                    }
                    this.lastWasNewline = pdfLine.isNewlineSplit();
                    this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                    ++this.linesWritten;
                    this.descender = pdfLine.getDescender();
                }
            }
            this.currentLeading = this.fixedLeading;
            while (true) {
                PdfLine pdfLine;
                f3 = this.lastWasNewline ? this.indent : this.followingIndent;
                float f8 = this.yLine;
                float[] fArray = this.findLimitsTwoLines();
                if (fArray == null) {
                    n = 2;
                    if (this.bidiLine.isEmpty()) {
                        n |= 1;
                    }
                    this.yLine = f8;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    n = 1;
                    this.yLine = f8;
                    break;
                }
                float f9 = Math.max(fArray[0], fArray[2]);
                float f10 = Math.min(fArray[1], fArray[3]);
                if (f10 - f9 <= f3 + this.rightIndent) continue;
                if (!bl && !bl2) {
                    pdfContentByte.beginText();
                    bl2 = true;
                }
                if ((pdfLine = this.bidiLine.processLine(f10 - f9 - f3 - this.rightIndent, this.alignment, n2, this.arabicOptions)) == null) {
                    n = 1;
                    this.yLine = f8;
                    break;
                }
                if (!bl) {
                    objectArray[0] = pdfFont;
                    pdfContentByte.setTextMatrix(f9 + (pdfLine.isRTL() ? this.rightIndent : f3) + pdfLine.indentLeft(), this.yLine);
                    pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f);
                    pdfFont = (PdfFont)objectArray[0];
                }
                this.lastWasNewline = pdfLine.isNewlineSplit();
                this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                ++this.linesWritten;
                this.descender = pdfLine.getDescender();
            }
        }
        if (bl2) {
            pdfContentByte.endText();
            this.canvas.add(pdfContentByte);
        }
        return n;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f) {
        this.extraParagraphSpace = f;
    }

    public void clearChunks() {
        this.bidiLine.clearChunks();
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f) {
        this.spaceCharRatio = f;
    }

    public void setRunDirection(int n) {
        if (n < 0 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int n) {
        this.arabicOptions = n;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int n, int n2) {
        ColumnText columnText = new ColumnText(null);
        columnText.addText(phrase);
        PdfLine pdfLine = columnText.bidiLine.processLine(20000.0f, 0, n, n2);
        if (pdfLine == null) {
            return 0.0f;
        }
        return 20000.0f - pdfLine.widthLeft();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n, Phrase phrase, float f, float f2, float f3, int n2, int n3) {
        if (n != 0 && n != 1 && n != 2) {
            n = 0;
        }
        pdfContentByte.saveState();
        if (f3 == 0.0f) {
            pdfContentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
        } else {
            double d = (double)f3 * Math.PI / 180.0;
            float f4 = (float)Math.cos(d);
            float f5 = (float)Math.sin(d);
            pdfContentByte.concatCTM(f4, f5, -f5, f4, f, f2);
        }
        ColumnText columnText = new ColumnText(pdfContentByte);
        if (n == 0) {
            columnText.setSimpleColumn(phrase, 0.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n);
        } else if (n == 2) {
            columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 0.0f, 2.0f, 2.0f, n);
        } else {
            columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n);
        }
        if (n2 == 3) {
            if (n == 0) {
                n = 2;
            } else if (n == 2) {
                n = 0;
            }
        }
        columnText.setAlignment(n);
        columnText.setArabicOptions(n3);
        columnText.setRunDirection(n2);
        try {
            columnText.go();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        pdfContentByte.restoreState();
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n, Phrase phrase, float f, float f2, float f3) {
        ColumnText.showTextAligned(pdfContentByte, n, phrase, f, f2, f3, 1, 0);
    }
}

