/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.Image;

public class BarcodePostnet
extends Barcode {
    static byte[][] BARS = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            int n3 = string.charAt(n2) - 48;
            n += n3;
            --n2;
        }
        string = string + (char)((10 - n % 10) % 10 + 48);
        byte[] byArray = new byte[string.length() * 5 + 2];
        byArray[0] = 1;
        byArray[byArray.length - 1] = 1;
        int n4 = 0;
        while (n4 < string.length()) {
            int n5 = string.charAt(n4) - 48;
            System.arraycopy(BARS[n5], 0, byArray, n4 * 5 + 1, 5);
            ++n4;
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        float f = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(f, this.barHeight);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        float f = 0.0f;
        int n = 0;
        while (n < byArray.length) {
            pdfContentByte.rectangle(f, 0.0f, this.x - this.inkSpreading, byArray[n] == by ? this.barHeight : this.size);
            f += this.n;
            ++n;
        }
        pdfContentByte.fill();
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        throw new UnsupportedOperationException("Not supported with postnet.");
    }
}

