/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

final class StateTab {
    StateTab() {
    }

    JComponent build() {
        FormLayout layout = new FormLayout("right:max(50dlu;pref), 4dlu, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setOpaque(false);
        builder.append("Standard:", (Component)this.buildButtonRow(true, true));
        builder.append("No Content:", (Component)this.buildButtonRow(true, false));
        builder.append("No Border:", (Component)this.buildButtonRow(false, true));
        builder.append("Radio Button:", (Component)this.buildRadioButtonRow());
        builder.append("Check Box:", (Component)this.buildCheckBoxRow());
        builder.append("Combo Box:", (Component)this.buildComboBoxRow());
        builder.append("Text Field:", (Component)this.buildTextRow(JTextField.class, false));
        builder.append("Formatted Field:", (Component)this.buildTextRow(JFormattedTextField.class, false));
        builder.append("Text Area:", (Component)this.buildTextRow(JTextArea.class, true));
        builder.append("Editor Pane:", (Component)this.buildTextRow(JEditorPane.class, true));
        builder.append("Password:", (Component)this.buildTextRow(JPasswordField.class, false));
        builder.append("Spinner:", (Component)this.buildSpinnerRow());
        return builder.getPanel();
    }

    private JComponent buildButtonRow(boolean borderPainted, boolean contentAreaFilled) {
        JButton button = new JButton("Standard");
        button.setDefaultCapable(true);
        return this.buildButtonRow(new AbstractButton[]{button, new JToggleButton("Selected"), new JButton("Disabled"), new JToggleButton("Selected")}, borderPainted, contentAreaFilled);
    }

    private JComponent buildCheckBoxRow() {
        return this.buildButtonRow(new AbstractButton[]{new JCheckBox("Deselected"), new JCheckBox("Selected"), new JCheckBox("Disabled"), new JCheckBox("Selected")}, false, false);
    }

    private JComponent buildRadioButtonRow() {
        return this.buildButtonRow(new AbstractButton[]{new JRadioButton("Deselected"), new JRadioButton("Selected"), new JRadioButton("Disabled"), new JRadioButton("Selected")}, false, false);
    }

    private JComponent buildButtonRow(AbstractButton[] buttons, boolean borderPainted, boolean contentAreaFilled) {
        buttons[1].setSelected(true);
        buttons[2].setEnabled(false);
        buttons[3].setEnabled(false);
        buttons[3].setSelected(true);
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setBorderPainted(borderPainted);
            buttons[i].setContentAreaFilled(contentAreaFilled);
        }
        return this.buildGrid(buttons[0], buttons[1], buttons[2], buttons[3], FormFactory.BUTTON_COLSPEC);
    }

    private JComponent buildTextRow(Class textComponentClass, boolean wrap) {
        JTextComponent[] components = new JTextComponent[4];
        for (int i = 0; i < 4; ++i) {
            try {
                components[i] = (JTextComponent)textComponentClass.newInstance();
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        components[0].setText("Editable");
        components[1].setText("Uneditable");
        components[1].setEditable(false);
        components[2].setText("Disabled");
        components[2].setEnabled(false);
        components[3].setText("Uneditable");
        components[3].setEditable(false);
        components[3].setEnabled(false);
        return wrap ? this.buildGrid(this.wrapWithScrollPane(components[0]), this.wrapWithScrollPane(components[1]), this.wrapWithScrollPane(components[2]), this.wrapWithScrollPane(components[3])) : this.buildGrid(components[0], components[1], components[2], components[3]);
    }

    private Component wrapWithScrollPane(Component c) {
        return new JScrollPane(c, 21, 31);
    }

    private JComponent buildComboBoxRow() {
        return this.buildGrid(this.createComboBox("Editable", true, true), this.createComboBox("Uneditable", true, false), this.createComboBox("Disabled", false, true), this.createComboBox("Uneditable", false, false));
    }

    private JComboBox createComboBox(String text, boolean enabled, boolean editable) {
        JComboBox<String> box = new JComboBox<String>(new String[]{text, "Two", "Three", "Four", "A Quite Long Label"});
        box.setEnabled(enabled);
        box.setEditable(editable);
        box.putClientProperty("ComboBox.popupPrototypeDisplayValue", "A Quite Long Label");
        return box;
    }

    private JComponent buildSpinnerRow() {
        return this.buildGrid(this.createSpinner(true, true), this.createSpinner(true, false), this.createSpinner(false, true), this.createSpinner(false, false));
    }

    private JComponent createSpinner(boolean enabled, boolean editable) {
        JSpinner spinner = new JSpinner();
        spinner.setValue(new Integer(123));
        spinner.setEnabled(enabled);
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)editor).getTextField().setEditable(editable);
        }
        return spinner;
    }

    private JComponent buildGrid(Component c1, Component c2, Component c3, Component c4) {
        return this.buildGrid(c1, c2, c3, c4, new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.dluX((int)20), 1.0));
    }

    private JComponent buildGrid(Component c1, Component c2, Component c3, Component c4, ColumnSpec colSpec) {
        FormLayout layout = new FormLayout("", "pref");
        for (int i = 0; i < 4; ++i) {
            layout.appendColumn(colSpec);
            layout.appendColumn(FormFactory.RELATED_GAP_COLSPEC);
        }
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        builder.add(c1, cc.xy(1, 1));
        builder.add(c2, cc.xy(3, 1));
        builder.add(c3, cc.xy(5, 1));
        builder.add(c4, cc.xy(7, 1));
        return builder.getPanel();
    }
}

