/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.util;

import java.security.MessageDigest;
import java.util.Random;

public final class RadiusUtils {
    public static byte[] encodePapPassword(MessageDigest md5, byte[] userPass, byte[] requestAuthenticator, String sharedSecret) {
        int i;
        byte[] userPassBytes = null;
        if (userPass.length > 128) {
            userPassBytes = new byte[128];
            System.arraycopy(userPass, 0, userPassBytes, 0, 128);
        } else {
            userPassBytes = userPass;
        }
        byte[] encryptedPass = null;
        encryptedPass = userPassBytes.length < 128 ? (userPassBytes.length % 16 == 0 ? new byte[userPassBytes.length] : new byte[userPassBytes.length / 16 * 16 + 16]) : new byte[128];
        System.arraycopy(userPassBytes, 0, encryptedPass, 0, userPassBytes.length);
        for (int i2 = userPassBytes.length; i2 < encryptedPass.length; ++i2) {
            encryptedPass[i2] = 0;
        }
        md5.reset();
        md5.update(sharedSecret.getBytes());
        md5.update(requestAuthenticator);
        byte[] bn = md5.digest();
        for (i = 0; i < 16; ++i) {
            encryptedPass[i] = (byte)(bn[i] ^ encryptedPass[i]);
        }
        if (encryptedPass.length > 16) {
            for (i = 16; i < encryptedPass.length; i += 16) {
                md5.reset();
                md5.update(sharedSecret.getBytes());
                md5.update(encryptedPass, i - 16, 16);
                bn = md5.digest();
                for (int j = 0; j < 16; ++j) {
                    encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
                }
            }
        }
        return encryptedPass;
    }

    public static byte[] makeRFC2865RequestAuthenticator(MessageDigest md5, String sharedSecret) {
        byte[] requestAuthenticator = new byte[16];
        Random r = new Random();
        for (int i = 0; i < 16; ++i) {
            requestAuthenticator[i] = (byte)r.nextInt();
        }
        md5.reset();
        md5.update(sharedSecret.getBytes());
        md5.update(requestAuthenticator);
        return md5.digest();
    }

    public static byte[] makeRFC2865ResponseAuthenticator(MessageDigest md5, String sharedSecret, byte code, byte identifier, short length, byte[] requestAuthenticator, byte[] responseAttributeBytes) {
        md5.reset();
        md5.update(code);
        md5.update(identifier);
        md5.update((byte)(length >> 8));
        md5.update((byte)(length & 0xFF));
        md5.update(requestAuthenticator, 0, requestAuthenticator.length);
        md5.update(responseAttributeBytes, 0, responseAttributeBytes.length);
        md5.update(sharedSecret.getBytes());
        return md5.digest();
    }

    public static byte[] makeRFC2866RequestAuthenticator(MessageDigest md5, String sharedSecret, byte code, byte identifier, int length, byte[] requestAttributes) {
        byte[] requestAuthenticator = new byte[16];
        for (int i = 0; i < 16; ++i) {
            requestAuthenticator[i] = 0;
        }
        md5.reset();
        md5.update(code);
        md5.update(identifier);
        md5.update((byte)(length >> 8));
        md5.update((byte)(length & 0xFF));
        md5.update(requestAuthenticator, 0, requestAuthenticator.length);
        md5.update(requestAttributes, 0, requestAttributes.length);
        md5.update(sharedSecret.getBytes());
        return md5.digest();
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }
}

