/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.standard;

import java.util.LinkedList;
import net.sf.jradius.exception.StandardViolatedException;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.standard.RadiusStandard;

public class WISPrStandard
extends RadiusStandard {
    static final int[] requiredAccessRequest = new int[]{1, 2, 4, 6, 8, 24, 30, 32, 44, 61};
    static final int[] requiredAccessAccept = new int[]{18, 24, 25, 27, 28, 44, 85};
    static final int[] requiredAccounting = new int[]{1, 4, 8, 25, 30, 32, 40, 41, 42, 43, 44, 46, 47, 48, 61};

    public String getName() {
        return "WISPr";
    }

    public void checkPacket(RadiusPacket p, int[] ignore) throws StandardViolatedException {
        LinkedList missing = new LinkedList();
        switch (p.getCode()) {
            case 1: {
                WISPrStandard.checkMissing(p, missing, requiredAccessRequest, ignore);
                break;
            }
            case 2: {
                WISPrStandard.checkMissing(p, missing, requiredAccessAccept, ignore);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                WISPrStandard.checkMissing(p, missing, requiredAccounting, ignore);
            }
        }
        if (!missing.isEmpty()) {
            throw new StandardViolatedException(this.getClass(), missing);
        }
    }
}

