/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.session;

import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.AccessRequest;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.value.AttributeValue;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.SessionKeyProvider;

public class RadiusSessionKeyProvider
implements SessionKeyProvider {
    public Object getSessionKey(JRadiusRequest request) throws RadiusException {
        Object key = this.getAppSessionKey(request);
        if (key != null) {
            return key;
        }
        return this.getRequestSessionKey(request);
    }

    public Object getRequestSessionKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        if (req == null) {
            return null;
        }
        if (req instanceof AccessRequest) {
            return this.getAccessRequestKey(request);
        }
        if (req instanceof AccountingRequest) {
            int type = request.getType();
            int status = ((AccountingRequest)req).getAccountingStatusType();
            Object key = this.getClassKey(request);
            if (key == null) {
                key = this.getAccountingRequestKey(request);
            }
            if (type == 3 && status == 1) {
                return new Object[]{this.getAccessRequestKey(request), key};
            }
            return key;
        }
        return null;
    }

    public Object getAccessRequestKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        StringBuffer sb = new StringBuffer((String)request.getSender());
        sb.append(":").append(this.getKeyFromAttributeType(req, 4, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 32, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 1, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 31, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 30, false));
        return sb.toString();
    }

    public Object getClassKey(JRadiusRequest request) throws RadiusException {
        String sClass;
        RadiusPacket req = request.getRequestPacket();
        byte[] bClass = (byte[])req.getAttributeValue(25);
        if (bClass != null && (sClass = new String(bClass)).startsWith("JRADIUS-CLASS:")) {
            RadiusLog.debug("Using " + sClass);
            return sClass.substring("JRADIUS-CLASS:".length());
        }
        return null;
    }

    public Object getAccountingRequestKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        StringBuffer sb = new StringBuffer((String)request.getSender());
        sb.append(":").append(this.getKeyFromAttributeType(req, 4, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 44, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 32, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 1, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 31, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 30, false));
        return sb.toString();
    }

    protected Object getAppSessionKey(JRadiusRequest request) throws RadiusException {
        AttributeList ci = request.getConfigItems();
        RadiusAttribute a = ci.get(1259012098);
        if (a != null) {
            return a.getValue().getValueObject();
        }
        return null;
    }

    public Object getTunneledRequestKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        StringBuffer sb = new StringBuffer((String)request.getSender());
        sb.append(":").append(this.getKeyFromAttributeType(req, 32, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 4, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 44, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 31, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 30, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 6, false));
        return sb.toString();
    }

    protected String getKeyFromAttributeType(RadiusPacket req, int type, boolean required) throws RadiusException {
        RadiusAttribute a = req.findAttribute(type);
        if (a == null) {
            if (required) {
                a = AttributeFactory.newAttribute(type, null);
                throw new RadiusException("Missing required attribute: " + a.getAttributeName());
            }
            return null;
        }
        AttributeValue v = a.getValue();
        return v.toString();
    }
}

