/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.session;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.log.RadiusLogEntry;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.server.JRadiusEvent;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.session.JRadiusSessionManager;

public class RadiusSession
implements JRadiusSession,
Serializable {
    public static final long serialVersionUID = 0L;
    private int sessionState = 0;
    private String sessionKey;
    private String jRadiusKey;
    private boolean newSession = true;
    private long timeStamp;
    private String username;
    private String realm;
    private String password;
    private String sessionId;
    private String proxyToRealm;
    private String connectInfo;
    private String callingStationId;
    private String calledStationId;
    private String nasIdentifier;
    private String nasIPAddress;
    private String clientIPAddress;
    private String framedIPAddress;
    private byte[] radiusClass;
    private Integer idleTimeout;
    private Integer sessionTimeout;
    private Integer interimInterval;
    private Integer serviceType;
    private Integer sessionTime;
    private Integer packetsIn;
    private Integer packetsOut;
    private Integer octetsIn;
    private Integer octetsOut;
    private Integer gigaWordsIn;
    private Integer gigaWordsOut;
    private Integer terminateCause;
    private Date startTime;
    private Date lastInterimTime;
    private Date stopTime;
    private String serviceName;
    private String serviceClass;
    private String locationID;
    private String locationType;
    private String locationName;
    private String locationCity;
    private String locationStateProvince;
    private String locationCountryCode;
    private String paymentType;
    private JRadiusRequest lastRadiusRequest;
    private LinkedHashMap logEntryMap = new LinkedHashMap();

    public RadiusSession() {
    }

    public RadiusSession(String session) {
        this();
        this.setSessionKey(session);
        RadiusLog.debug("Creating new session: " + session);
    }

    public RadiusLogEntry getLogEntry(JRadiusEvent event, String key) {
        RadiusLogEntry entry = (RadiusLogEntry)this.logEntryMap.get(key);
        if (entry == null) {
            RadiusLog.debug("Creating new Session/LogEntry: " + this.getSessionKey() + "/" + key);
            entry = JRadiusSessionManager.getManager().newLogEntry(event, this, key);
            this.logEntryMap.put(key, entry);
        }
        RadiusLog.debug("Retreived Session/LogEntry: " + this.getSessionKey() + "/" + key);
        return entry;
    }

    public RadiusLogEntry getLogEntry(JRadiusRequest request) throws RadiusException {
        AttributeList ci = request.getConfigItems();
        RadiusAttribute a = ci.get(1259012097);
        String key = a != null ? (String)a.getValue().getValueObject() : Integer.toString((char)request.getRequestPacket().getIdentifier());
        RadiusLogEntry entry = this.getLogEntry(request, key);
        entry.setCode(new Integer(request.getReturnValue()));
        return entry;
    }

    public void addLogMessage(JRadiusRequest request, String message) throws RadiusException {
        this.getLogEntry(request).addMessage(message);
    }

    public void commitLogEntries(int result) {
        Iterator i = this.logEntryMap.values().iterator();
        while (i.hasNext()) {
            RadiusLogEntry entry = (RadiusLogEntry)i.next();
            if (!entry.isFinished() || entry.isCommitted()) continue;
            entry.setCode(new Integer(result));
            this.commitLogEntry(entry, result);
            entry.setCommitted(true);
        }
    }

    public void commitLogEntry(RadiusLogEntry entry, int result) {
        String mesg = entry.toString();
        if (mesg != null) {
            RadiusLog.info(mesg);
        }
    }

    public void onAuthorization(JRadiusRequest request, boolean success) throws RadiusException {
        RadiusLog.debug("Authorization: " + (Object)((Object)request) + " was" + (success ? "" : " NOT") + " sucessful");
        this.setSessionState(0);
    }

    public void onAuthentication(JRadiusRequest request, boolean success) throws RadiusException {
        RadiusLog.debug("Authentication: " + (Object)((Object)request) + " was" + (success ? "" : " NOT") + " sucessful");
        if (success) {
            RadiusPacket rep = request.getReplyPacket();
            this.setSessionState(1);
            this.setIdleTimeout((Integer)rep.getAttributeValue(28));
            this.setSessionTimeout((Integer)rep.getAttributeValue(27));
            this.setInterimInterval((Integer)rep.getAttributeValue(85));
        } else {
            this.setSessionState(2);
        }
    }

    public void initSession(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        Integer zero = new Integer(0);
        this.setSessionTime(zero);
        this.setPacketsIn(zero);
        this.setPacketsOut(zero);
        this.setOctetsIn(zero);
        this.setOctetsOut(zero);
        this.setGigaWordsIn(zero);
        this.setGigaWordsOut(zero);
        this.setServiceType((Integer)req.getAttributeValue(6));
        this.setConnectInfo((String)req.getAttributeValue(77));
        this.setCallingStationId((String)req.getAttributeValue(31));
        this.setCalledStationId((String)req.getAttributeValue(30));
        this.setSessionId((String)req.getAttributeValue(44));
        this.setNasIdentifier((String)req.getAttributeValue(32));
        InetAddress inet = (InetAddress)req.getAttributeValue(4);
        if (inet != null) {
            this.setNasIPAddress(inet.getHostAddress());
        }
        if ((inet = (InetAddress)req.getAttributeValue(8)) != null) {
            this.setFramedIPAddress(inet.getHostAddress());
        }
        if (this.getNasIdentifier() == null) {
            this.setNasIdentifier(this.getNasIPAddress());
        }
    }

    public void updateSession(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        Integer i = (Integer)req.getAttributeValue(46);
        if (i != null) {
            this.setSessionTime(i);
        }
        if ((i = (Integer)req.getAttributeValue(47)) != null) {
            this.setPacketsIn(i);
        }
        if ((i = (Integer)req.getAttributeValue(48)) != null) {
            this.setPacketsOut(i);
        }
        if ((i = (Integer)req.getAttributeValue(42)) != null) {
            this.setOctetsIn(i);
        }
        if ((i = (Integer)req.getAttributeValue(43)) != null) {
            this.setOctetsOut(i);
        }
        if ((i = (Integer)req.getAttributeValue(52)) != null) {
            this.setGigaWordsIn(i);
        }
        if ((i = (Integer)req.getAttributeValue(53)) != null) {
            this.setGigaWordsOut(i);
        }
        if ((i = (Integer)req.getAttributeValue(49)) != null) {
            this.setTerminateCause(i);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Integer getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Integer getInterimInterval() {
        return this.interimInterval;
    }

    public void setInterimInterval(Integer interimInterval) {
        this.interimInterval = interimInterval;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Integer getSessionTime() {
        return this.sessionTime;
    }

    public void setSessionTime(Integer sessionTime) {
        this.sessionTime = sessionTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getLastInterimTime() {
        return this.lastInterimTime;
    }

    public void setLastInterimTime(Date lastInterimTime) {
        this.lastInterimTime = lastInterimTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    public Integer getGigaWordsIn() {
        return this.gigaWordsIn;
    }

    public void setGigaWordsIn(Integer gigaWordsIn) {
        this.gigaWordsIn = gigaWordsIn;
    }

    public Integer getGigaWordsOut() {
        return this.gigaWordsOut;
    }

    public void setGigaWordsOut(Integer gigaWordsOut) {
        this.gigaWordsOut = gigaWordsOut;
    }

    public Integer getOctetsIn() {
        return this.octetsIn;
    }

    public void setOctetsIn(Integer octetsIn) {
        this.octetsIn = octetsIn;
    }

    public Integer getOctetsOut() {
        return this.octetsOut;
    }

    public void setOctetsOut(Integer octetsOut) {
        this.octetsOut = octetsOut;
    }

    public Long getTotalOctetsIn() {
        if (this.octetsIn == null) {
            return null;
        }
        long l = this.octetsIn.longValue();
        if (this.gigaWordsIn != null) {
            l |= this.gigaWordsIn.longValue() << 32;
        }
        return new Long(l);
    }

    public Long getTotalOctetsOut() {
        if (this.octetsOut == null) {
            return null;
        }
        long l = this.octetsOut.longValue();
        if (this.gigaWordsOut != null) {
            l |= this.gigaWordsOut.longValue() << 32;
        }
        return new Long(l);
    }

    public Integer getPacketsIn() {
        return this.packetsIn;
    }

    public void setPacketsIn(Integer packetsIn) {
        this.packetsIn = packetsIn;
    }

    public Integer getPacketsOut() {
        return this.packetsOut;
    }

    public void setPacketsOut(Integer packetsOut) {
        this.packetsOut = packetsOut;
    }

    public Integer getTerminateCause() {
        return this.terminateCause;
    }

    public void setTerminateCause(Integer terminateCause) {
        this.terminateCause = terminateCause;
    }

    public byte[] getRadiusClass() {
        return this.radiusClass;
    }

    public void setRadiusClass(byte[] radiusClass) {
        this.radiusClass = radiusClass;
    }

    public int getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(int sessionState) {
        this.sessionState = sessionState;
    }

    public String getLocationCity() {
        return this.locationCity;
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = locationCity;
    }

    public String getLocationCountryCode() {
        return this.locationCountryCode;
    }

    public void setLocationCountryCode(String locationCountryCode) {
        this.locationCountryCode = locationCountryCode;
    }

    public String getLocationID() {
        return this.locationID;
    }

    public void setLocationID(String locationID) {
        this.locationID = locationID;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLocationStateProvince() {
        return this.locationStateProvince;
    }

    public void setLocationStateProvince(String locationStateProvince) {
        this.locationStateProvince = locationStateProvince;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getProxyToRealm() {
        return this.proxyToRealm;
    }

    public void setProxyToRealm(String proxyToRealm) {
        this.proxyToRealm = proxyToRealm;
    }

    public String getCalledStationId() {
        return this.calledStationId;
    }

    public void setCalledStationId(String calledStation) {
        this.calledStationId = calledStation;
    }

    public String getCallingStationId() {
        return this.callingStationId;
    }

    public void setCallingStationId(String callingStation) {
        this.callingStationId = callingStation;
    }

    public String getConnectInfo() {
        return this.connectInfo;
    }

    public void setConnectInfo(String connectInfo) {
        this.connectInfo = connectInfo;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public String getFramedIPAddress() {
        return this.framedIPAddress;
    }

    public void setFramedIPAddress(String framedIPAddress) {
        this.framedIPAddress = framedIPAddress;
    }

    public void setClientIPAddress(String clientIP) {
        this.clientIPAddress = clientIP;
    }

    public String getNasIdentifier() {
        return this.nasIdentifier;
    }

    public void setNasIdentifier(String nasID) {
        this.nasIdentifier = nasID;
    }

    public String getNasIPAddress() {
        return this.nasIPAddress;
    }

    public void setNasIPAddress(String nasIP) {
        this.nasIPAddress = nasIP;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public void setNewSession(boolean newSession) {
        this.newSession = newSession;
    }

    public String getJRadiusKey() {
        return this.jRadiusKey;
    }

    public void setJRadiusKey(String jRadiusKey) {
        this.jRadiusKey = jRadiusKey;
    }

    public JRadiusRequest getLastRadiusRequest() {
        return this.lastRadiusRequest;
    }

    public void setLastRadiusRequest(JRadiusRequest lastRadiusRequest) {
        this.lastRadiusRequest = lastRadiusRequest;
    }

    public void lock() {
    }

    public void unlock() {
    }

    public String toString() {
        return this.getSessionKey();
    }
}

