/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jradius.handler.EventHandler;
import net.sf.jradius.handler.chain.JRCommand;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.server.config.Configuration;
import net.sf.jradius.server.config.ConfigurationItem;
import net.sf.jradius.server.config.HandlerConfigurationItem;
import net.sf.jradius.server.config.PacketHandlerConfigurationItem;
import net.sf.jradius.server.config.XMLConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class ListenerConfigurationItem
extends ConfigurationItem {
    public static String XML_LIST_KEY = "listeners";
    public static String XML_KEY = "listener";
    private Collection requestHandlers;
    private Collection eventHandlers;
    private String processorClassName;
    private int numberOfThreads;
    private static final String PROC_CLASS_KEY = "processor-class";
    private static final String PROC_THREADS_KEY = "processor-threads";
    static /* synthetic */ Class class$net$sf$jradius$handler$PacketHandlerChain;
    static /* synthetic */ Class class$net$sf$jradius$handler$EventHandlerChain;

    public ListenerConfigurationItem(HierarchicalConfiguration.Node node, XMLConfiguration config) {
        super(node, config);
        Class<?> clazz;
        JRCommand command;
        HandlerConfigurationItem preCfg;
        HandlerConfigurationItem cfg;
        this.processorClassName = config.getConfigString(PROC_CLASS_KEY);
        this.numberOfThreads = config.getConfigInt(PROC_THREADS_KEY, 1);
        HierarchicalConfiguration.Node lnode = node;
        HierarchicalConfiguration.Node lroot = config.getRoot();
        List children = lnode.getChildren("packet-handler");
        Iterator l = children.iterator();
        while (l.hasNext()) {
            node = (HierarchicalConfiguration.Node)l.next();
            config.setRoot(node);
            cfg = new PacketHandlerConfigurationItem(node, config);
            preCfg = null;
            command = Configuration.packetHandlerForName(cfg.getHandlerName());
            if (command == null) {
                if (cfg.getCatalogName() != null) {
                    cfg.setName(cfg.getCatalogName());
                    cfg.setClassName((class$net$sf$jradius$handler$PacketHandlerChain == null ? ListenerConfigurationItem.class$("net.sf.jradius.handler.PacketHandlerChain") : class$net$sf$jradius$handler$PacketHandlerChain).getName());
                } else {
                    preCfg = Configuration.packetHandlerConfigurationForName(cfg.getHandlerName());
                    if (preCfg != null) {
                        cfg.setName(preCfg.getName());
                        cfg.setHandlerName(preCfg.getHandlerName());
                        cfg.setClassName(preCfg.getClassName());
                        cfg.getSenders().addAll(preCfg.getSenders());
                        cfg.getHandleTypes().addAll(preCfg.getHandleTypes());
                        cfg.getProperties().putAll(preCfg.getProperties());
                    }
                }
                try {
                    clazz = Class.forName(cfg.getClassName());
                    command = (EventHandler)clazz.newInstance();
                }
                catch (Exception e) {
                    RadiusLog.error(e.getMessage());
                    continue;
                }
            }
            if (preCfg != null) {
                command.setConfig(preCfg);
            }
            command.setConfig(cfg);
            if (this.requestHandlers == null) {
                this.requestHandlers = new LinkedList();
            }
            this.requestHandlers.add(command);
        }
        config.setRoot(lroot);
        children = lnode.getChildren("event-handler");
        l = children.iterator();
        while (l.hasNext()) {
            node = (HierarchicalConfiguration.Node)l.next();
            config.setRoot(node);
            cfg = new HandlerConfigurationItem(node, config);
            preCfg = null;
            command = Configuration.eventHandlerForName(cfg.getHandlerName());
            if (command == null) {
                if (cfg.getCatalogName() != null) {
                    cfg.setName(cfg.getCatalogName());
                    cfg.setClassName((class$net$sf$jradius$handler$EventHandlerChain == null ? ListenerConfigurationItem.class$("net.sf.jradius.handler.EventHandlerChain") : class$net$sf$jradius$handler$EventHandlerChain).getName());
                } else {
                    preCfg = Configuration.eventHandlerConfigurationForName(cfg.getHandlerName());
                    if (preCfg != null) {
                        cfg.setName(preCfg.getName());
                        cfg.setHandlerName(preCfg.getHandlerName());
                        cfg.setClassName(preCfg.getClassName());
                        cfg.getSenders().addAll(preCfg.getSenders());
                        cfg.getHandleTypes().addAll(preCfg.getHandleTypes());
                        cfg.getProperties().putAll(preCfg.getProperties());
                    }
                }
                try {
                    clazz = Class.forName(cfg.getClassName());
                    command = (EventHandler)clazz.newInstance();
                }
                catch (Exception e) {
                    RadiusLog.error(e.getMessage());
                    continue;
                }
            }
            if (preCfg != null) {
                command.setConfig(preCfg);
            }
            command.setConfig(cfg);
            if (this.eventHandlers == null) {
                this.eventHandlers = new LinkedList();
            }
            this.eventHandlers.add(command);
        }
    }

    public Collection getRequestHandlers() {
        return this.requestHandlers;
    }

    public Collection getEventHandlers() {
        return this.eventHandlers;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public String getProcessorClassName() {
        return this.processorClassName;
    }

    public String xmlKey() {
        return XML_KEY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

