/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server;

import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.server.EventDispatcher;
import net.sf.jradius.server.JRadiusThread;
import net.sf.jradius.server.ObjectQueue;

public abstract class Processor
extends JRadiusThread {
    private ObjectQueue queue;
    private EventDispatcher eventDispatcher;
    private Collection requestHandlers;

    public void setRequestQueue(ObjectQueue q) {
        this.queue = q;
    }

    public ObjectQueue getRequestQueue() {
        return this.queue;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void setRequestHandlers(Collection handlers) {
        this.requestHandlers = handlers;
    }

    public Collection getRequestHandlers() {
        return this.requestHandlers;
    }

    protected abstract void processSocket(Socket var1) throws IOException, RadiusException;

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.yield();
                    this.process();
                }
            }
            catch (Throwable e) {
                System.err.println(this.getName() + ": process() method threw an exception: " + e);
                RadiusLog.error(e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void process() throws InterruptedException, IOException, RadiusException {
        Object queueElement = this.getRequestQueue().dequeue();
        if (!(queueElement instanceof Socket)) {
            throw new IllegalArgumentException("Expected Socket but found " + queueElement.getClass().getName());
        }
        this.processSocket((Socket)queueElement);
    }
}

