/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.server;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.handler.chain.JRCommand;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.server.JRadiusEvent;
import net.sf.jradius.server.JRadiusThread;
import net.sf.jradius.server.ObjectQueue;
import net.sf.jradius.server.event.ServerEvent;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.session.JRadiusSessionManager;
import org.apache.commons.chain.Context;

public class EventDispatcher
extends JRadiusThread {
    private ObjectQueue eventQueue = new ObjectQueue();
    private Collection eventHandlers = new LinkedList();

    public void post(JRadiusEvent event) {
        this.eventQueue.enqueue((Object)event);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.yield();
                    this.dispatchEvent();
                }
            }
            catch (Throwable e) {
                RadiusLog.error(e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void dispatchEvent() throws InterruptedException {
        JRadiusEvent event = (JRadiusEvent)((Object)this.eventQueue.dequeue());
        if (event != null) {
            JRadiusSessionManager sessionManager = JRadiusSessionManager.getManager();
            JRadiusSession session = null;
            if (event instanceof ServerEvent) {
                try {
                    session = sessionManager.getSession(((ServerEvent)event).getSessionKey());
                }
                catch (RadiusException e) {
                    session = null;
                }
                session = ((ServerEvent)event).getRequest().getSession();
            }
            Iterator i = this.eventHandlers.iterator();
            while (i.hasNext()) {
                JRCommand command = (JRCommand)i.next();
                try {
                    if (!command.doesHandle(event) || !command.execute((Context)event)) continue;
                    break;
                }
                catch (Throwable e) {
                    RadiusLog.error("Event handler " + command.getName() + " threw an exception:" + e);
                    e.printStackTrace();
                }
            }
            if (session != null) {
                sessionManager.putSession(session);
            }
        }
    }

    public Collection getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(Collection eventHandlers) {
        this.eventHandlers = eventHandlers;
    }
}

