/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet.attribute.value;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public class IntegerValue
extends AttributeValue {
    protected Integer integerValue;

    public IntegerValue() {
    }

    public IntegerValue(Integer i) {
        this.integerValue = i;
    }

    public IntegerValue(int i) {
        this.integerValue = new Integer(i);
    }

    public int getLength() {
        return 4;
    }

    public void getBytes(DataOutputStream out) throws IOException {
        if (this.integerValue != null) {
            out.writeInt(this.integerValue);
        }
    }

    public void setValue(byte[] b) {
        if (b == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream input = new DataInputStream(bais);
        try {
            this.integerValue = new Integer(input.readInt());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setValue(String v) {
        this.integerValue = Integer.valueOf(v);
    }

    public Integer getValue() {
        return this.integerValue;
    }

    public String toString() {
        if (this.integerValue != null) {
            return this.integerValue.toString();
        }
        return "[Bad Integer Value]";
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<int>");
        if (this.integerValue != null) {
            sb.append(this.integerValue);
        }
        sb.append("</int>");
        return sb.toString();
    }

    public Object getValueObject() {
        return this.integerValue;
    }

    public void setValueObject(Object o) {
        this.integerValue = (Integer)o;
    }
}

