/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet.attribute.value;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public class IPAddrValue
extends AttributeValue {
    protected InetAddress inetAddressValue;

    public IPAddrValue() {
    }

    public IPAddrValue(InetAddress i) {
        this.inetAddressValue = i;
    }

    public IPAddrValue(String s) {
        this.setValue(s);
    }

    public IPAddrValue(byte[] bytes) {
        this.setValue(bytes);
    }

    public void setValue(String s) {
        try {
            this.inetAddressValue = InetAddress.getByName(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLength() {
        return this.inetAddressValue == null ? 0 : 4;
    }

    public void getBytes(DataOutputStream out) throws IOException {
        if (this.inetAddressValue != null) {
            out.write(this.inetAddressValue.getAddress());
        }
    }

    public void setValue(byte[] b) {
        if (b == null) {
            return;
        }
        try {
            this.inetAddressValue = InetAddress.getByAddress(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        if (this.inetAddressValue != null) {
            return this.inetAddressValue.getHostAddress();
        }
        return "[Bad IP Address Value]";
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ip>");
        if (this.inetAddressValue != null) {
            sb.append(this.inetAddressValue.getHostAddress());
        }
        sb.append("</ip>");
        return sb.toString();
    }

    public Object getValueObject() {
        return this.inetAddressValue;
    }

    public void setValueObject(Object o) {
        this.inetAddressValue = (InetAddress)o;
    }
}

