/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet.attribute.value;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public class DateValue
extends AttributeValue {
    private Date dateValue;

    public DateValue() {
    }

    public DateValue(Date d) {
        this.dateValue = d;
    }

    public int getLength() {
        return 4;
    }

    public void getBytes(DataOutputStream out) throws IOException {
        if (this.dateValue != null) {
            out.writeInt((int)(this.dateValue.getTime() / 1000L));
        }
    }

    public void setValue(byte[] b) {
        if (b == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream input = new DataInputStream(bais);
        try {
            int t = input.readInt();
            this.dateValue = new Date((long)t * 1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setValue(String v) {
    }

    public String toString() {
        if (this.dateValue != null) {
            return this.dateValue.toString();
        }
        return "[Bad Date Value]";
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<time>");
        if (this.dateValue != null) {
            sb.append(this.dateValue.getTime());
        }
        sb.append("</time>");
        return sb.toString();
    }

    public Object getValueObject() {
        return this.dateValue;
    }

    public void setValueObject(Object o) {
        this.dateValue = (Date)o;
    }
}

