/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet.attribute;

import java.io.Serializable;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public abstract class RadiusAttribute
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected int attributeType = 0;
    protected int attributeOp = 10;
    protected AttributeValue attributeValue = null;
    protected String attributeName = "Unknown Attribute";

    public int getType() {
        return this.attributeType;
    }

    public int getFormattedType() {
        return this.attributeType;
    }

    public AttributeValue getValue() {
        return this.attributeValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getAttributeOp() {
        return this.attributeOp;
    }

    public void setAttributeOp(int attributeOp) {
        this.attributeOp = attributeOp;
    }

    public void setAttributeOp(String attributeOp) {
        this.attributeOp = Operator.operatorFromString(attributeOp);
    }

    public void setValue(byte[] b) {
        this.attributeValue.setValue(b);
    }

    public void setValue(String value) {
        this.attributeValue.setValue(value);
    }

    public String toString() {
        return this.attributeName + " " + Operator.operatorToString(this.attributeOp) + " " + this.attributeValue.toString();
    }

    public static final class Operator {
        public static final int ADD = 8;
        public static final int SUB = 9;
        public static final int SET = 10;
        public static final int EQ = 11;
        public static final int NE = 12;
        public static final int GE = 13;
        public static final int GT = 14;
        public static final int LE = 15;
        public static final int LT = 16;
        public static final int REG_EQ = 17;
        public static final int REG_NE = 18;
        public static final int CMP_TRUE = 19;
        public static final int CMP_FALSE = 20;
        public static final int CMP_EQ = 21;

        public static String operatorToString(int op) {
            switch (op) {
                case 8: {
                    return "+=";
                }
                case 9: {
                    return "-=";
                }
                case 10: {
                    return ":=";
                }
                case 11: {
                    return "=";
                }
                case 12: {
                    return "!=";
                }
                case 13: {
                    return ">=";
                }
                case 14: {
                    return ">";
                }
                case 15: {
                    return "<=";
                }
                case 16: {
                    return "<";
                }
                case 17: {
                    return "=~";
                }
                case 18: {
                    return "!~";
                }
                case 19: {
                    return "=*";
                }
                case 20: {
                    return "!*";
                }
                case 21: {
                    return "==";
                }
            }
            return "=";
        }

        public static int operatorFromString(String op) {
            if (op == null) {
                return 0;
            }
            if (op.equals("+=")) {
                return 8;
            }
            if (op.equals("-=")) {
                return 9;
            }
            if (op.equals(":=")) {
                return 10;
            }
            if (op.equals("=")) {
                return 11;
            }
            if (op.equals("!=")) {
                return 12;
            }
            if (op.equals(">=")) {
                return 13;
            }
            if (op.equals(">")) {
                return 14;
            }
            if (op.equals("<=")) {
                return 15;
            }
            if (op.equals("<")) {
                return 16;
            }
            if (op.equals("=~")) {
                return 17;
            }
            if (op.equals("!~")) {
                return 18;
            }
            if (op.equals("=*")) {
                return 19;
            }
            if (op.equals("!*")) {
                return 20;
            }
            if (op.equals("==")) {
                return 21;
            }
            return 0;
        }
    }
}

