/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet;

import java.io.Serializable;
import net.sf.jradius.exception.UnknownAttributeException;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public abstract class RadiusPacket
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int MIN_PACKET_LENGTH = 20;
    public static final int MAX_PACKET_LENGTH = 4096;
    public static final short RADIUS_HEADER_LENGTH = 20;
    private static Object nextPacketIdLock = new Object();
    private static byte nextPacketId = 1;
    protected byte code;
    protected byte identifier = 0;
    protected byte[] authenticator;
    protected final AttributeList attributes = new AttributeList();

    public RadiusPacket() {
    }

    public RadiusPacket(AttributeList list) {
        this.attributes.add(list);
    }

    public void setCode(int code) {
        this.code = (byte)code;
    }

    public byte getCode() {
        return this.code;
    }

    public void addAttribute(RadiusAttribute attribute) {
        if (null != attribute) {
            this.attributes.add(attribute, false);
        }
    }

    public void overwriteAttribute(RadiusAttribute attribute) {
        if (null != attribute) {
            this.attributes.add(attribute, true);
        }
    }

    public void addAttributes(AttributeList list) {
        this.attributes.add(list);
    }

    public void removeAttribute(RadiusAttribute attribute) {
        this.attributes.remove(attribute);
    }

    public void removeAttribute(int attributeType) {
        this.attributes.remove(attributeType);
    }

    public byte getIdentifier() {
        if (this.identifier == 0) {
            this.identifier = RadiusPacket.getNewPacketId();
        }
        return this.identifier;
    }

    public void setIdentifier(byte i) {
        this.identifier = i;
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public byte[] createAuthenticator(byte[] attributes) {
        if (attributes == null) {
            // empty if block
        }
        return new byte[16];
    }

    public void setAuthenticator(byte[] authenticator) {
        this.authenticator = authenticator;
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public byte[] getAuthenticator(byte[] attributes) {
        if (this.authenticator == null) {
            this.authenticator = this.createAuthenticator(attributes);
        }
        return this.authenticator;
    }

    public RadiusAttribute findAttribute(int type) {
        return this.attributes.get(type);
    }

    public Object[] findAttributes(int type) {
        return this.attributes.getArray(type);
    }

    public RadiusAttribute findAttribute(String aName) throws UnknownAttributeException {
        return this.attributes.get(aName);
    }

    public Object getAttributeValue(int type) {
        AttributeValue value;
        RadiusAttribute attribute = this.findAttribute(type);
        if (attribute != null && (value = attribute.getValue()) != null) {
            return value.getValueObject();
        }
        return null;
    }

    public Object getAttributeValue(String aName) throws UnknownAttributeException {
        AttributeValue value;
        RadiusAttribute attribute = this.findAttribute(aName);
        if (attribute != null && (value = attribute.getValue()) != null) {
            return value.getValueObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte getNewPacketId() {
        Object object = nextPacketIdLock;
        synchronized (object) {
            byte by = nextPacketId;
            nextPacketId = (byte)(by + 1);
            return by;
        }
    }

    public String toString(boolean allAttributes) {
        StringBuffer sb = new StringBuffer();
        sb.append("Class: ").append(this.getClass().toString()).append("\n");
        sb.append("Attributes:\n");
        sb.append(this.attributes.toString(allAttributes));
        return sb.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

