/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.VSAttribute;
import net.sf.jradius.packet.attribute.value.AttributeValue;

public class RadiusFormat {
    private static final int HEADER_LENGTH = 2;
    public static final int VSA_HEADER_LENGTH = 8;
    private static final RadiusFormat staticFormat = new RadiusFormat();

    public static RadiusFormat getInstance() {
        return staticFormat;
    }

    public static void setAttributeBytes(RadiusPacket packet, byte[] bAttributes) {
        if (bAttributes.length > 0) {
            staticFormat.unpackAttributes(packet.getAttributes(), bAttributes, bAttributes.length);
        }
    }

    public byte[] packPacket(RadiusPacket packet) {
        ByteArrayOutputStream pbOut = new ByteArrayOutputStream();
        DataOutputStream pOut = new DataOutputStream(pbOut);
        byte[] attributeBytes = this.packAttributeList(packet.getAttributes());
        try {
            this.packHeader(pOut, packet, attributeBytes);
            pOut.write(attributeBytes);
            pOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pbOut.toByteArray();
    }

    public byte[] packAttributeList(AttributeList attrs) {
        ByteArrayOutputStream abOut = new ByteArrayOutputStream();
        DataOutputStream aOut = new DataOutputStream(abOut);
        Iterator attributeList = attrs.getMap().values().iterator();
        while (attributeList.hasNext()) {
            Object o = attributeList.next();
            Object[] ol = o instanceof LinkedList ? ((LinkedList)o).toArray() : new Object[]{o};
            for (int i = 0; i < ol.length; ++i) {
                RadiusAttribute attr = (RadiusAttribute)ol[i];
                try {
                    this.packAttribute(aOut, attr);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            aOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return abOut.toByteArray();
    }

    public void packAttribute(DataOutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        this.packHeader(out, a);
        attributeValue.getBytes(out);
    }

    public void packHeader(DataOutputStream pOut, RadiusPacket p, byte[] attributeBytes) throws IOException {
        short length = (short)(attributeBytes.length + 20);
        pOut.writeByte(p.getCode());
        pOut.writeByte(p.getIdentifier());
        pOut.writeShort(length);
        pOut.write(p.getAuthenticator(attributeBytes));
    }

    public void packHeader(DataOutputStream out, RadiusAttribute a) throws IOException {
        if (a instanceof VSAttribute) {
            this.packHeader(out, (VSAttribute)a);
            return;
        }
        AttributeValue attributeValue = a.getValue();
        out.writeByte(a.getType());
        out.writeByte(attributeValue.getLength() + 2);
    }

    public void packHeader(DataOutputStream out, VSAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        out.writeByte(a.getType());
        out.writeByte(attributeValue.getLength() + 8);
        out.writeInt(a.getVendorId());
        out.writeByte(a.getVsaAttributeType());
        out.writeByte(attributeValue.getLength() + 2);
    }

    public void unpackAttributes(AttributeList attrs, byte[] bytes, int bLength) {
        DataInputStream attributeInput = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            AttributeParseContext ctx;
            for (int left = 0; left < bLength; left += ctx.attributeLength) {
                ctx = new AttributeParseContext();
                left += this.unpackAttributeHeader(attributeInput, ctx);
                RadiusAttribute attribute = null;
                ctx.attributeValue = new byte[ctx.attributeLength - ctx.headerLength];
                attributeInput.read(ctx.attributeValue, 0, ctx.attributeLength - ctx.headerLength);
                attribute = AttributeFactory.newAttribute(ctx.vendorNumber, ctx.attributeType, ctx.attributeValue, ctx.attributeOp);
                if (attribute == null) {
                    RadiusLog.warn("Unknown attribute with type = " + ctx.attributeType);
                } else {
                    attrs.add(attribute, false);
                }
                if (ctx.padding <= 0) continue;
                left += ctx.padding;
                while (ctx.padding-- > 0) {
                    attributeInput.readByte();
                }
            }
            attributeInput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected int unpackAttributeHeader(DataInputStream in, AttributeParseContext ctx) throws IOException {
        ctx.attributeType = in.readByte() & 0xFF;
        ctx.attributeLength = in.readByte() & 0xFF;
        ctx.headerLength = 2;
        return 0;
    }

    protected class AttributeParseContext {
        public int attributeType = 0;
        public int attributeLength = 0;
        public int attributeOp = 11;
        public byte[] attributeValue = null;
        public int headerLength = 0;
        public int vendorNumber = -1;
        public int padding = 0;

        protected AttributeParseContext() {
        }
    }
}

