/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.util.LinkedHashMap;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.freeradius.FreeRadiusFormat;
import net.sf.jradius.packet.RadiusFormat;
import net.sf.jradius.packet.RadiusPacket;

public class PacketFactory {
    private static LinkedHashMap codeMap = new LinkedHashMap();
    static /* synthetic */ Class class$net$sf$jradius$packet$AccessRequest;
    static /* synthetic */ Class class$net$sf$jradius$packet$AccessAccept;
    static /* synthetic */ Class class$net$sf$jradius$packet$AccessReject;
    static /* synthetic */ Class class$net$sf$jradius$packet$AccountingRequest;
    static /* synthetic */ Class class$net$sf$jradius$packet$AccountingResponse;
    static /* synthetic */ Class class$net$sf$jradius$packet$AccessChallenge;
    static /* synthetic */ Class class$net$sf$jradius$packet$NullPacket;

    public static RadiusPacket parse(DatagramPacket dp) throws RadiusException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dp.getData());
        DataInputStream input = new DataInputStream(bais);
        RadiusPacket rp = null;
        try {
            int returnCode = -1;
            byte bCode = input.readByte();
            returnCode = bCode & 0xFF;
            Class c = (Class)codeMap.get(new Integer(returnCode));
            if (c == null) {
                throw new RadiusException("bad radius code");
            }
            byte bIdentifier = input.readByte();
            short length = (short)(input.readShort() & 0xFFFF);
            byte[] bAuthenticator = new byte[16];
            input.readFully(bAuthenticator);
            byte[] bAttributes = new byte[length - 20];
            input.readFully(bAttributes);
            try {
                rp = (RadiusPacket)c.newInstance();
                rp.setCode(bCode);
                rp.setIdentifier(bIdentifier);
                rp.setAuthenticator(bAuthenticator);
                RadiusFormat.setAttributeBytes(rp, bAttributes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rp;
    }

    private static RadiusPacket parsePacket(DataInputStream input) throws RadiusException, IOException {
        RadiusPacket rp = null;
        byte bCode = input.readByte();
        byte bIdentifier = input.readByte();
        int code = bCode & 0xFF;
        Class c = code == 0 ? (class$net$sf$jradius$packet$NullPacket == null ? (class$net$sf$jradius$packet$NullPacket = PacketFactory.class$("net.sf.jradius.packet.NullPacket")) : class$net$sf$jradius$packet$NullPacket) : (Class)codeMap.get(new Integer(code));
        if (c == null) {
            throw new RadiusException("bad radius packet type: " + code);
        }
        int length = input.readInt();
        byte[] bAttributes = new byte[length];
        input.readFully(bAttributes);
        try {
            rp = (RadiusPacket)c.newInstance();
            rp.setCode(bCode);
            rp.setIdentifier(bIdentifier);
            FreeRadiusFormat.setAttributeBytes(rp, bAttributes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rp;
    }

    public static RadiusPacket[] parse(DataInputStream input, int packetCount) throws RadiusException {
        RadiusPacket[] rp = new RadiusPacket[packetCount];
        try {
            for (int i = 0; i < packetCount; ++i) {
                rp[i] = PacketFactory.parsePacket(input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        codeMap.put(new Integer(1), class$net$sf$jradius$packet$AccessRequest == null ? (class$net$sf$jradius$packet$AccessRequest = PacketFactory.class$("net.sf.jradius.packet.AccessRequest")) : class$net$sf$jradius$packet$AccessRequest);
        codeMap.put(new Integer(2), class$net$sf$jradius$packet$AccessAccept == null ? (class$net$sf$jradius$packet$AccessAccept = PacketFactory.class$("net.sf.jradius.packet.AccessAccept")) : class$net$sf$jradius$packet$AccessAccept);
        codeMap.put(new Integer(3), class$net$sf$jradius$packet$AccessReject == null ? (class$net$sf$jradius$packet$AccessReject = PacketFactory.class$("net.sf.jradius.packet.AccessReject")) : class$net$sf$jradius$packet$AccessReject);
        codeMap.put(new Integer(4), class$net$sf$jradius$packet$AccountingRequest == null ? (class$net$sf$jradius$packet$AccountingRequest = PacketFactory.class$("net.sf.jradius.packet.AccountingRequest")) : class$net$sf$jradius$packet$AccountingRequest);
        codeMap.put(new Integer(5), class$net$sf$jradius$packet$AccountingResponse == null ? (class$net$sf$jradius$packet$AccountingResponse = PacketFactory.class$("net.sf.jradius.packet.AccountingResponse")) : class$net$sf$jradius$packet$AccountingResponse);
        codeMap.put(new Integer(11), class$net$sf$jradius$packet$AccessChallenge == null ? (class$net$sf$jradius$packet$AccessChallenge = PacketFactory.class$("net.sf.jradius.packet.AccessChallenge")) : class$net$sf$jradius$packet$AccessChallenge);
    }
}

