/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.packet;

import net.sf.jradius.client.RadiusClient;
import net.sf.jradius.packet.RadiusRequest;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.value.NamedValue;
import net.sf.jradius.util.RadiusUtils;

public class AccountingRequest
extends RadiusRequest {
    public static final byte CODE = 4;
    private static final long serialVersionUID = 4L;
    public static final int ACCT_STATUS_START = 1;
    public static final int ACCT_STATUS_STOP = 2;
    public static final int ACCT_STATUS_INTERIM = 3;

    public AccountingRequest() {
        this.code = (byte)4;
    }

    public AccountingRequest(RadiusClient client) {
        super(client);
        this.code = (byte)4;
    }

    public AccountingRequest(AttributeList attributes) {
        super(attributes);
        this.code = (byte)4;
    }

    public AccountingRequest(RadiusClient client, AttributeList attributes) {
        super(client, attributes);
        this.code = (byte)4;
    }

    public int getAccountingStatusType() {
        Integer i = (Integer)this.getAttributeValue(40);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public void setAccountingStatusType(int type) {
        RadiusAttribute a = AttributeFactory.newAttribute(40, null);
        NamedValue s = (NamedValue)a.getValue();
        s.setValue(new Integer(type));
        this.overwriteAttribute(a);
    }

    public byte[] createAuthenticator(byte[] attributes) {
        if (this.client != null) {
            this.authenticator = RadiusUtils.makeRFC2866RequestAuthenticator(this.client.getMD(), this.client.getSharedSecret(), this.code, this.getIdentifier(), attributes.length + 20, attributes);
            return this.authenticator;
        }
        return new byte[16];
    }
}

