/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler.tlstunnel;

import net.sf.jradius.dictionary.Attr_EAPType;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.handler.RadiusSessionHandler;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.value.NamedValue;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.session.JRadiusSessionManager;
import net.sf.jradius.session.RadiusSessionKeyProvider;

public class AuthorizeHandler
extends RadiusSessionHandler {
    private String anonUserName;

    public boolean handle(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        AttributeList ci = request.getConfigItems();
        String username = (String)req.getAttributeValue(1);
        if (this.anonUserName != null) {
            NamedValue eapv;
            JRadiusSession session = request.getSession();
            Attr_EAPType eap = (Attr_EAPType)req.findAttribute(1018);
            if (eap != null && ("Identity".equals((eapv = (NamedValue)eap.getValue()).getValueString()) || "EAP-TTLS".equals(eapv.getValueString()) || "PEAP".equals(eapv.getValueString())) && this.anonUserName.equals(username)) {
                RadiusSessionKeyProvider skp = (RadiusSessionKeyProvider)JRadiusSessionManager.getManager().getSessionKeyProvider(request.getSender());
                session.getLogEntry(request).setType("tls-tunnel");
                ci.remove(1048);
                tlsTunnels.put(skp.getTunneledRequestKey(request), session.getSessionKey());
                RadiusLog.info("Early EAP-TTLS Termination: username = " + username + ", session = " + session.getSessionKey());
                request.setReturnValue(8);
                return true;
            }
        }
        return false;
    }

    public String getAnonUserName() {
        return this.anonUserName;
    }

    public void setAnonUserName(String anonUserName) {
        this.anonUserName = anonUserName;
    }
}

