/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler.event;

import net.sf.jradius.handler.EventHandlerBase;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.log.RadiusLogEntry;
import net.sf.jradius.server.JRadiusEvent;
import net.sf.jradius.server.event.SessionExpiredEvent;
import net.sf.jradius.session.JRadiusSession;

public class SessionExpiredHandler
extends EventHandlerBase {
    public boolean handle(JRadiusEvent evt) throws Exception {
        if (evt instanceof SessionExpiredEvent) {
            SessionExpiredEvent event = (SessionExpiredEvent)evt;
            JRadiusSession session = event.getSession();
            if (session == null) {
                return true;
            }
            RadiusLog.debug("Processing Session Expired Event for Session: " + session.getSessionKey());
            switch (session.getSessionState()) {
                case -1: {
                    this.onRadiusError(event);
                    break;
                }
                case 0: {
                    this.onAuthPending(event);
                    break;
                }
                case 3: {
                    this.onAcctStarted(event);
                    break;
                }
                case 4: {
                    this.onAcctStopped(event);
                    break;
                }
                case 2: {
                    this.onAuthRejected(event);
                    break;
                }
                case 1: {
                    int iServiceType;
                    Integer serviceType = session.getServiceType();
                    if (serviceType != null && ((iServiceType = serviceType.intValue()) == 6 || iServiceType == 8)) break;
                    this.onAuthAccepted(event);
                }
            }
            return true;
        }
        return false;
    }

    public void onRadiusError(SessionExpiredEvent event) {
        JRadiusSession session = event.getSession();
        String error = "Session Expired in Error State";
        RadiusLog.error(session.getSessionKey() + ": " + error);
        RadiusLogEntry logEntry = session.getLogEntry(null, "0");
        logEntry.setType("error");
        logEntry.addMessage(error);
        session.commitLogEntries(1);
    }

    public void onAuthPending(SessionExpiredEvent event) {
        RadiusLog.problem(null, event.getSession(), null, "Expired in Auth-Pending state (no response from service provider)");
    }

    public void onAuthAccepted(SessionExpiredEvent event) {
        JRadiusSession session = event.getSession();
        String error = "Session Expired in Auth-Accepted state, Accounting never started";
        RadiusLog.warn(session.getSessionKey() + ": " + error);
        RadiusLogEntry logEntry = session.getLogEntry(null, "0");
        logEntry.setType("error");
        logEntry.addMessage(error);
        session.commitLogEntries(1);
    }

    public void onAuthRejected(SessionExpiredEvent event) {
        RadiusLog.debug("Rejected Session Expired: " + (Object)((Object)event));
    }

    public void onAcctStarted(SessionExpiredEvent event) {
        JRadiusSession session = event.getSession();
        String error = "Session Expired in Accounting-Started state, Accounting never stopped";
        RadiusLog.warn(session.getSessionKey() + ": " + error);
        RadiusLogEntry logEntry = session.getLogEntry(null, "0");
        logEntry.setType("error");
        logEntry.addMessage(error);
    }

    public void onAcctStopped(SessionExpiredEvent event) {
        RadiusLog.debug("Completed Session Expired: " + (Object)((Object)event));
    }
}

