/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.exception.RadiusSecurityException;
import net.sf.jradius.handler.PacketHandlerBase;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.session.JRadiusSession;

public abstract class RadiusSessionHandler
extends PacketHandlerBase {
    public static final String ClassPrefix = "JRADIUS-CLASS:";
    protected static final Map tlsTunnels = Collections.synchronizedMap(new LinkedHashMap());

    protected boolean noSessionFound(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        RadiusLog.error("No session found for packet:\n" + req.toString());
        return true;
    }

    protected JRadiusSession buildSession(JRadiusRequest request) throws RadiusException {
        return null;
    }

    protected void ensureSessionState(JRadiusRequest request, JRadiusSession session, int state) throws RadiusException {
        if (session.getSessionState() != state) {
            request.getConfigItems().remove(1048);
            throw new RadiusSecurityException("Received unexpected accounting for session: " + session.getSessionKey() + " (" + session.getSessionState() + " != " + state + ")");
        }
    }
}

