/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.handler;

import net.sf.jradius.handler.EventHandlerBase;
import net.sf.jradius.handler.chain.JRCommand;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.server.JRadiusEvent;
import net.sf.jradius.server.config.ConfigurationItem;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Context;

public class EventHandlerChain
extends EventHandlerBase {
    protected Catalog catalog;
    private String onTrue;
    private String onFalse;

    public void setConfig(ConfigurationItem cfg) {
        super.setConfig(cfg);
        String catalogName = cfg.getName();
        CatalogFactory factory = CatalogFactory.getInstance();
        this.catalog = factory.getCatalog(catalogName);
        if (this.catalog == null) {
            RadiusLog.error("Unknown catalog named: " + catalogName);
        }
    }

    public boolean handle(JRadiusEvent event) throws Exception {
        return this.execute(event.getTypeString(), event);
    }

    protected boolean execute(String commandName, JRadiusEvent event) throws Exception {
        if (this.catalog == null) {
            return true;
        }
        JRCommand command = (JRCommand)this.catalog.getCommand(commandName);
        return this.execute(command, event);
    }

    protected boolean execute(JRCommand command, JRadiusEvent event) throws Exception {
        if (command == null) {
            return false;
        }
        boolean result = command.execute((Context)event);
        String onTrue = this.getOnTrue();
        String onFalse = this.getOnTrue();
        if (result) {
            if (onTrue != null) {
                return this.execute(onTrue, event);
            }
        } else if (onFalse != null) {
            return this.execute(onFalse, event);
        }
        return result;
    }

    public void setOnFalse(String onFalse) {
        this.onFalse = onFalse;
    }

    public void setOnTrue(String onTrue) {
        this.onTrue = onTrue;
    }

    public String getOnFalse() {
        return this.onFalse;
    }

    public String getOnTrue() {
        return this.onTrue;
    }
}

