/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.freeradius;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class RadiusDictionary {
    private static final String ppkg = "net.sf.jradius.packet.attribute";
    private final String bpkg;
    private final String sdir;
    private final String ddir;
    private static String fileHeader = "// DO NOT EDIT THIS FILE DIRECTLY! - AUTOMATICALLY GENERATED\n// Generated by: " + (class$net$sf$jradius$freeradius$RadiusDictionary == null ? (class$net$sf$jradius$freeradius$RadiusDictionary = RadiusDictionary.class$("net.sf.jradius.freeradius.RadiusDictionary")) : class$net$sf$jradius$freeradius$RadiusDictionary).toString() + "\n" + "// Generated on: " + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(Calendar.getInstance().getTime()) + "\n";
    private LinkedHashMap attrMap = new LinkedHashMap();
    private LinkedHashMap vendorMap = new LinkedHashMap();
    private LinkedList seenNames = new LinkedList();
    private String cVendor = null;
    static /* synthetic */ Class class$net$sf$jradius$freeradius$RadiusDictionary;

    public RadiusDictionary(Reader in, String pkgName, String dictDir, String srcDir) throws IOException {
        this.bpkg = pkgName;
        this.ddir = dictDir;
        this.sdir = srcDir;
        this.readFile(new BufferedReader(in));
    }

    public RadiusDictionary(String fileName, String pkgName, String dictDir, String srcDir) throws IOException {
        this(new FileReader(dictDir + "/" + fileName), pkgName, dictDir, srcDir);
    }

    public void readFile(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            String p;
            String attrName;
            String[] parts;
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.startsWith("$INCLUDE")) {
                parts = line.split("[\t ]+");
                String file = parts[1];
                System.err.println("Including file: " + file);
                this.readFile(new BufferedReader(new FileReader(this.ddir + "/" + file)));
                continue;
            }
            if (line.startsWith("BEGIN-VENDOR")) {
                parts = line.split("[\t ]+");
                this.cVendor = parts[1];
                continue;
            }
            if (line.startsWith("END-VENDOR")) {
                this.cVendor = null;
                continue;
            }
            if (line.startsWith("ATTRIBUTE")) {
                parts = line.split("[\t ]+");
                attrName = null;
                String attrNum = null;
                String attrType = null;
                String attrExtra = null;
                String attrVendor = null;
                VendorDesc vdesc = null;
                for (int i = 1; i < parts.length; ++i) {
                    String p2 = parts[i].trim();
                    if (p2.length() == 0) continue;
                    if (attrName == null) {
                        attrName = p2;
                        continue;
                    }
                    if (attrNum == null) {
                        attrNum = p2;
                        continue;
                    }
                    if (attrType == null) {
                        attrType = p2;
                        continue;
                    }
                    vdesc = (VendorDesc)this.vendorMap.get(p2);
                    if (vdesc != null) {
                        attrVendor = p2;
                        continue;
                    }
                    attrExtra = p2;
                }
                if (attrName == null || attrNum == null || attrType == null || this.seenNames.contains(attrName.toLowerCase())) continue;
                LinkedHashMap map = this.attrMap;
                if (attrVendor == null && this.cVendor != null) {
                    attrVendor = this.cVendor;
                    vdesc = (VendorDesc)this.vendorMap.get(this.cVendor);
                }
                if (vdesc != null) {
                    map = vdesc.attrMap;
                }
                map.put(attrName, new AttrDesc(attrName, attrNum, attrType, attrExtra, attrVendor));
                System.err.println(line);
                this.seenNames.add(attrName.toLowerCase());
                continue;
            }
            if (line.startsWith("VALUE")) {
                AttrDesc desc;
                parts = line.split("[\t ]+");
                attrName = null;
                String attrValue = null;
                String attrNum = null;
                for (int i = 1; i < parts.length; ++i) {
                    p = parts[i].trim();
                    if (p.length() == 0) continue;
                    if (attrName == null) {
                        attrName = p;
                        continue;
                    }
                    if (attrValue == null) {
                        attrValue = p;
                        continue;
                    }
                    if (attrNum != null) continue;
                    attrNum = p;
                }
                if (attrName == null || attrNum == null || attrValue == null || (desc = (AttrDesc)this.attrMap.get(attrName)) == null) continue;
                if (desc.values == null) {
                    desc.values = new LinkedHashMap();
                }
                if (desc.values.get(attrNum) == null) {
                    desc.values.put(attrNum, new AttrValueDesc(attrValue, attrNum));
                }
                System.err.println(line);
                continue;
            }
            if (!line.startsWith("VENDOR")) continue;
            parts = line.split("[\t ]+");
            String vendorName = null;
            String vendorNum = null;
            String vendorPkg = null;
            for (int i = 1; i < parts.length; ++i) {
                p = parts[i].trim();
                if (p.length() == 0) continue;
                if (vendorName == null) {
                    vendorName = p;
                    continue;
                }
                if (vendorNum != null) continue;
                vendorNum = p;
            }
            if (vendorName == null || vendorNum == null) continue;
            String vendor = "vsa_" + vendorName.toLowerCase().replaceAll("-", ".");
            vendorPkg = this.bpkg + "." + vendor;
            this.vendorMap.put(vendorName, new VendorDesc(vendorName, vendorNum, vendorPkg));
            System.err.println(line);
        }
    }

    public void writeAttrMap(Map map, String pkg, String vName, String cName, boolean withVendors) {
        VendorDesc vdesc;
        Iterator iter2;
        String dir = this.sdir + "/" + pkg.replaceAll("\\.", "/");
        Iterator iter = map.values().iterator();
        String dictFile = dir + "/" + cName + ".java";
        PrintWriter dict = null;
        StringBuffer loadAttributes = new StringBuffer();
        StringBuffer loadAttributesNames = new StringBuffer();
        new File(dir).mkdirs();
        try {
            dict = new PrintWriter(new FileWriter(dictFile));
            dict.println(fileHeader);
            dict.println("package " + pkg + ";");
            dict.println("");
            dict.println("import java.util.Map;");
            dict.println("");
            if (withVendors) {
                dict.println("import net.sf.jradius.packet.attribute.AttributeDictionary;");
            } else {
                dict.println("import net.sf.jradius.packet.attribute.VSADictionary;");
            }
            dict.println("");
            dict.println("/**");
            dict.println(" * Dictionary for package " + pkg);
            dict.println(" * @author " + (class$net$sf$jradius$freeradius$RadiusDictionary == null ? (class$net$sf$jradius$freeradius$RadiusDictionary = RadiusDictionary.class$("net.sf.jradius.freeradius.RadiusDictionary")) : class$net$sf$jradius$freeradius$RadiusDictionary).toString());
            dict.println(" */");
            dict.print("public class " + cName);
            if (withVendors) {
                dict.print(" implements AttributeDictionary");
            } else {
                dict.print(" implements VSADictionary");
            }
            dict.println("\n{");
            if (withVendors) {
                dict.println("    public void loadVendorCodes(Map map)");
                dict.println("    {");
                iter2 = this.vendorMap.values().iterator();
                while (iter2.hasNext()) {
                    vdesc = (VendorDesc)iter2.next();
                    dict.println("        map.put(new Integer(" + vdesc.num + "), " + vdesc.pkg + ".VSADictionaryImpl.class);");
                }
                dict.println("    }");
                dict.println("");
            } else {
                dict.println("    public String getVendorName() { return \"" + vName + "\"; }\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        loadAttributes.append("    public void loadAttributes(Map map)\n");
        loadAttributes.append("    {\n");
        loadAttributesNames.append("    public void loadAttributesNames(Map map)\n");
        loadAttributesNames.append("    {\n");
        while (iter.hasNext()) {
            AttrDesc desc = (AttrDesc)iter.next();
            StringBuffer fileSB = new StringBuffer(dir);
            String interfaceName = "";
            String pkgPath = pkg;
            if (withVendors && desc.vendor != null) {
                String vendor = "vsa_" + desc.vendor.toLowerCase().replaceAll("-", ".");
                fileSB.append("/").append(vendor.replaceAll("\\.", "/"));
                pkgPath = pkgPath + "." + vendor;
            }
            String className = "Attr_" + desc.name.replaceAll("-", "");
            String parentName = "RadiusAttribute";
            if (!withVendors) {
                parentName = "VSAttribute";
            }
            String valueClass = "OctetsValue";
            String finalValue = "byte[] ";
            String valueArgs = "";
            String extraImport = null;
            String extraUtils = null;
            new File(fileSB.toString()).mkdirs();
            fileSB.append("/").append(className).append(".java");
            String file = fileSB.toString();
            if (desc.type.startsWith("string")) {
                valueClass = desc.extra != null && "encrypt=1".equals(desc.extra) ? "EncryptedStringValue" : "StringValue";
                finalValue = "String";
            }
            if (desc.type.startsWith("integer")) {
                valueClass = "IntegerValue";
                finalValue = "Integer";
            }
            if (desc.type.startsWith("date")) {
                valueClass = "DateValue";
                finalValue = "Date";
                extraUtils = "import java.util.Date;\n";
            }
            if (desc.type.startsWith("ipaddr")) {
                valueClass = "IPAddrValue";
                finalValue = "InetAddress";
                extraUtils = "import java.net.InetAddress;\n";
            }
            if (desc.type.startsWith("ipv6addr")) {
                valueClass = "IPv6AddrValue";
                finalValue = "InetAddress";
                extraUtils = "import java.net.InetAddress;\n";
            }
            if (desc.values != null) {
                valueClass = "NamedValue";
                valueArgs = "valueMap";
                finalValue = "Integer";
            }
            if (withVendors && desc.vendor != null) {
                extraImport = valueClass;
                valueArgs = "new " + valueClass + "(" + valueArgs + ")";
                valueClass = "VSAValue";
            }
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(file));
                writer.println(fileHeader);
                writer.println("package " + pkgPath + ";");
                writer.println("");
                if (desc.values != null) {
                    writer.println("import java.util.LinkedHashMap;");
                    writer.println("import java.util.Map;");
                    writer.println("");
                }
                if (extraUtils != null) {
                    writer.println(extraUtils);
                    writer.println("");
                }
                writer.println("import net.sf.jradius.packet.attribute." + parentName + ";");
                writer.println("import net.sf.jradius.packet.attribute.value." + valueClass + ";");
                if (extraImport != null) {
                    writer.println("import net.sf.jradius.packet.attribute.value." + extraImport + ";");
                }
                writer.println("");
                writer.println("/**");
                writer.println(" * Attribute Name: " + desc.name + "<br>");
                if (withVendors) {
                    writer.print(" * Attribute Type: " + desc.num);
                    if (Integer.parseInt(desc.num) > 255) {
                        writer.print(" (FreeRADIUS Internal Attribute)<br>");
                    }
                    writer.println("<br>");
                } else {
                    writer.println(" * Attribute Type: 26<br>");
                    writer.println(" * Vendor Id: " + ((VendorDesc)this.vendorMap.get((Object)desc.vendor)).num + "<br>");
                    writer.println(" * VSA Type: " + desc.num + "<br>");
                }
                writer.println(" * Value Type: " + valueClass + "<br>");
                if (desc.values != null) {
                    writer.println(" * Possible Values: <br>");
                    writer.println(" * <ul>");
                    Iterator iter22 = desc.values.values().iterator();
                    while (iter22.hasNext()) {
                        AttrValueDesc vdesc2 = (AttrValueDesc)iter22.next();
                        writer.println(" * <li> " + vdesc2.name + " (" + vdesc2.num + ")");
                    }
                    writer.println(" * </ul>");
                }
                writer.println(" *");
                writer.println(" * @author " + (class$net$sf$jradius$freeradius$RadiusDictionary == null ? RadiusDictionary.class$("net.sf.jradius.freeradius.RadiusDictionary") : class$net$sf$jradius$freeradius$RadiusDictionary).toString());
                writer.println(" */");
                writer.println("public class " + className + " extends " + parentName + interfaceName);
                writer.println("{");
                writer.println("    public static final String NAME = \"" + desc.name + "\";");
                String attributeType = desc.num;
                if (withVendors) {
                    writer.println("    public static final int TYPE = " + desc.num + ";");
                } else {
                    attributeType = "26";
                    writer.println("    public static final int VENDOR_ID = " + ((VendorDesc)this.vendorMap.get((Object)desc.vendor)).num + ";");
                    writer.println("    public static final int VSA_TYPE = " + desc.num + ";");
                    writer.println("    public static final int TYPE = ((VENDOR_ID & 0xFFFF) << 16) | VSA_TYPE;");
                }
                writer.println("");
                writer.println("    public static final long serialVersionUID = TYPE;");
                writer.println("");
                if (desc.values != null) {
                    AttrValueDesc vdesc3;
                    Iterator iter23 = desc.values.values().iterator();
                    while (iter23.hasNext()) {
                        vdesc3 = (AttrValueDesc)iter23.next();
                        writer.println("    public static final String " + this.clean(vdesc3.name) + " = \"" + vdesc3.name + "\";");
                    }
                    writer.println("");
                    writer.println("    private static final LinkedHashMap valueMap = new LinkedHashMap();");
                    writer.println("");
                    writer.println("    static");
                    writer.println("    {");
                    iter23 = desc.values.values().iterator();
                    while (iter23.hasNext()) {
                        vdesc3 = (AttrValueDesc)iter23.next();
                        writer.println("        valueMap.put(new Integer(" + vdesc3.num + "), " + this.clean(vdesc3.name) + ");");
                        writer.println("        valueMap.put(" + this.clean(vdesc3.name) + ", new Integer(" + vdesc3.num + "));");
                    }
                    writer.println("    }");
                    writer.println("");
                }
                writer.println("    public void setup()");
                writer.println("    {");
                writer.println("        attributeName = NAME;");
                writer.println("        attributeType = " + attributeType + ";");
                if (!withVendors) {
                    writer.println("        vendorId = VENDOR_ID;");
                    writer.println("        vsaAttributeType = VSA_TYPE;");
                }
                writer.println("    }");
                writer.println("");
                writer.println("    public " + className + "()");
                writer.println("    {");
                writer.println("        setup();");
                writer.println("        attributeValue = new " + valueClass + "(" + valueArgs + ");");
                writer.println("    }");
                writer.println("");
                writer.println("    public " + className + "(" + valueClass + " v)");
                writer.println("    {");
                writer.println("        setup();");
                writer.println("        attributeValue = v;");
                writer.println("    }");
                if (finalValue != null) {
                    writer.println("");
                    writer.println("    public " + className + "(" + finalValue + " v)");
                    writer.println("    {");
                    writer.println("        setup();");
                    if (desc.values == null) {
                        writer.println("        attributeValue = new " + valueClass + "(v);");
                    } else {
                        writer.println("        attributeValue = new " + valueClass + "(valueMap, v);");
                    }
                    writer.println("    }");
                    writer.println("");
                    writer.println("    public " + className + "(" + finalValue + " v, int op)");
                    writer.println("    {");
                    writer.println("        this(v);");
                    writer.println("        attributeOp = op;");
                    writer.println("    }");
                }
                if (desc.values != null) {
                    writer.println("");
                    writer.println("    public " + className + "(String s)");
                    writer.println("    {");
                    writer.println("        setup();");
                    writer.println("        attributeValue = new NamedValue(valueMap, s);");
                    writer.println("    }");
                    writer.println("");
                    writer.println("    public " + className + "(String s, int op)");
                    writer.println("    {");
                    writer.println("        this(s);");
                    writer.println("        attributeOp = op;");
                    writer.println("    }");
                    writer.println("");
                    writer.println("    public static Map getValueMap()");
                    writer.println("    {");
                    writer.println("        return valueMap;");
                    writer.println("    }");
                }
                writer.println("}");
                writer.close();
                if (!withVendors || desc.vendor == null) {
                    loadAttributes.append("        map.put(new Integer(" + desc.num + "), " + className + ".class);\n");
                    loadAttributesNames.append("        map.put(\"" + desc.name + "\", " + className + ".class);\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.err.println(desc.name);
        }
        loadAttributes.append("    }\n");
        loadAttributesNames.append("    }\n");
        dict.println(loadAttributes.toString());
        dict.print(loadAttributesNames.toString());
        try {
            dict.println("}");
            dict.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (withVendors) {
            iter2 = this.vendorMap.values().iterator();
            while (iter2.hasNext()) {
                vdesc = (VendorDesc)iter2.next();
                this.writeAttrMap(vdesc.attrMap, vdesc.pkg, vdesc.name, "VSADictionaryImpl", false);
            }
        }
    }

    public void writeJavaClasses() {
        this.writeAttrMap(this.attrMap, this.bpkg, null, "AttributeDictionaryImpl", true);
    }

    private String clean(String s) {
        s = s.replaceAll("[^a-zA-Z0-9]", "");
        return s;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Requires 3 arguments: [package-name] [dictionary-dir] [java-src-dir]");
            System.err.println("\tpackage-name:    Name of the Java package to be built (e.g. com.pp.jradius.dictionary)");
            System.err.println("\tdictionary-dir:  Directory where the FreeRADIUS 'dictionary' file is");
            System.err.println("\tjava-src--dir:   Directory where to write Java classes");
            return;
        }
        String file = "dictionary";
        String pkg = args[0];
        String dDir = args[1];
        String jDir = args[2];
        try {
            RadiusDictionary d = new RadiusDictionary(file, pkg, dDir, jDir);
            d.writeJavaClasses();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class VendorDesc {
        public String name;
        public String num;
        public String pkg;
        public LinkedHashMap attrMap = new LinkedHashMap();

        public VendorDesc(String n, String m, String p) {
            this.name = n;
            this.num = m;
            this.pkg = p;
        }
    }

    class AttrValueDesc {
        public String name;
        public String num;

        public AttrValueDesc(String n, String m) {
            this.name = n;
            this.num = m;
        }
    }

    class AttrDesc {
        public String name;
        public String num;
        public String type;
        public String extra;
        public String vendor;
        public LinkedHashMap values = null;

        public AttrDesc(String n, String m, String t, String e, String v) {
            this.name = n;
            this.num = m;
            this.type = t;
            this.extra = e;
            this.vendor = v;
        }
    }
}

