/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.exception;

import java.util.Iterator;
import java.util.List;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.RadiusAttribute;

public class StandardViolatedException
extends RadiusException {
    private final Class standardClass;
    private final List missingAttributes;

    public StandardViolatedException(Class standardClass, List missing) {
        super("Standards Violation: " + standardClass.getName());
        this.standardClass = standardClass;
        this.missingAttributes = missing;
    }

    public String listAttributes() {
        return this.listAttributes(", ");
    }

    public String listAttributes(String sep) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.missingAttributes.iterator();
        while (i.hasNext()) {
            Integer type = (Integer)i.next();
            RadiusAttribute a = AttributeFactory.newAttribute(type, null);
            if (a == null) continue;
            sb.append(sep).append(a.getAttributeName());
        }
        return sb.substring(sep.length());
    }

    public Class getStandardClass() {
        return this.standardClass;
    }

    public List getMissingAttributes() {
        return this.missingAttributes;
    }
}

