/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jradius.dictionary.Attr_UserPassword;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.handler.PacketHandlerBase;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.AccessAccept;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.server.JRadiusRequest;
import net.sf.jradius.server.config.ConfigurationItem;
import net.sf.jradius.server.config.XMLConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class LocalUsersHandler
extends PacketHandlerBase {
    private final LinkedHashMap users = new LinkedHashMap();

    public void setConfig(ConfigurationItem cfg) {
        super.setConfig(cfg);
        HierarchicalConfiguration.Node root = cfg.getRoot();
        XMLConfiguration xmlCfg = cfg.getXMLConfig();
        List usersList = root.getChildren("users");
        Iterator l = usersList.iterator();
        while (l.hasNext()) {
            HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)l.next();
            List children = node.getChildren("user");
            Iterator i = children.iterator();
            while (i.hasNext()) {
                node = (HierarchicalConfiguration.Node)i.next();
                root = xmlCfg.getRoot();
                xmlCfg.setRoot(node);
                LocalUser user = new LocalUser();
                user.username = xmlCfg.getString("[@username]");
                user.realm = xmlCfg.getString("[@realm]");
                user.password = xmlCfg.getString("[@password]");
                Object v = node.getValue();
                if (v != null) {
                    user.attributes = v.toString();
                }
                RadiusLog.debug("        -> Configured local user: " + user.getUserName());
                this.users.put(user.getUserName(), user);
                xmlCfg.setRoot(root);
            }
        }
    }

    public boolean handle(JRadiusRequest jRequest) {
        try {
            int type = jRequest.getType();
            AttributeList ci = jRequest.getConfigItems();
            RadiusPacket req = jRequest.getRequestPacket();
            RadiusPacket rep = jRequest.getReplyPacket();
            String username = (String)req.getAttributeValue(1);
            LocalUser u = (LocalUser)this.users.get(username);
            if (u == null) {
                RadiusLog.info("Ignoring unknown username: " + username);
                return false;
            }
            switch (type) {
                case 2: {
                    Attr_UserPassword a = new Attr_UserPassword(u.password);
                    a.setAttributeOp(21);
                    ci.add((RadiusAttribute)a);
                    break;
                }
                case 8: {
                    if (rep instanceof AccessAccept) {
                        rep.addAttributes(u.getAttributeList());
                        RadiusLog.info("Authentication successful for username: " + username);
                        break;
                    }
                    RadiusLog.info("Authentication failed for username: " + username);
                }
            }
        }
        catch (RadiusException e) {
            e.printStackTrace();
        }
        jRequest.setReturnValue(8);
        return false;
    }

    private class LocalUser {
        public String username;
        public String realm;
        public String password;
        public String attributes;
        public AttributeList attrList;

        private LocalUser() {
        }

        public String getUserName() {
            if (this.realm != null) {
                return this.username + "@" + this.realm;
            }
            return this.username;
        }

        public AttributeList getAttributeList() {
            if (this.attrList == null && this.attributes != null) {
                BufferedReader in = new BufferedReader(new StringReader(this.attributes));
                this.attrList = new AttributeList();
                block4: while (true) {
                    try {
                        String line;
                        while ((line = in.readLine()) != null) {
                            String[] parts;
                            if ((line = line.trim()).equals("") || (parts = line.split("[^a-zA-Z-]", 2)).length != 2) continue;
                            String attribute = parts[0];
                            line = parts[1].trim();
                            if ((parts = line.split("[^\\+=:-]", 2)).length != 2) continue;
                            String op = parts[0];
                            String value = parts[1];
                            try {
                                RadiusAttribute attr = AttributeFactory.newAttribute(attribute, value, op);
                                if (attr == null) continue block4;
                                this.attrList.add(attr, false);
                                continue block4;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
            return this.attrList;
        }
    }
}

