/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class LogConsole
extends JComponent
implements AdjustmentListener {
    private static final long serialVersionUID = 0L;
    public static final String CATEGORY_DEFAULT = "sent";
    public static final String CATEGORY_PACKETS_SENT = "sent";
    public static final String CATEGORY_PACKETS_RECV = "recv";
    public static final String CATEGORY_ERROR = "err";
    private static final PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
    private static final PrintStream err = new PrintStream(new FileOutputStream(FileDescriptor.err));
    private JTextPane console = new JTextPane();
    private JScrollPane container = new JScrollPane(this.console);
    private String TSPattern = null;
    private SimpleDateFormat sdf = null;
    private Color clrSent = Color.BLUE;
    private Color clrRecv = Color.MAGENTA;
    private Color clrError = Color.RED;
    private String defaultText = null;
    private boolean autoScroll = true;

    public LogConsole() {
        this("");
    }

    public LogConsole(String defaultText) {
        this.defaultText = defaultText;
        this.setLayout(new BorderLayout());
        this.add((Component)this.container, "Center");
        this.console.setEditable(false);
        this.console.getCaret().setBlinkRate(0);
        this.container.setHorizontalScrollBarPolicy(31);
        this.container.setVerticalScrollBarPolicy(22);
        this.container.getVerticalScrollBar().addAdjustmentListener(this);
    }

    public Document getDocument() {
        return this.console.getDocument();
    }

    public String getText() {
        return this.console.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String category, String s) {
        Document doc;
        SimpleAttributeSet sas = new SimpleAttributeSet();
        if (s == null) {
            return;
        }
        if (s.trim().length() == 0) {
            return;
        }
        Document document = doc = this.getDocument();
        synchronized (document) {
            StyleConstants.setFontFamily(sas, this.getFont().getFamily());
            StyleConstants.setFontSize(sas, this.getFont().getSize());
            StyleConstants.setBold(sas, this.getFont().isBold());
            StyleConstants.setItalic(sas, this.getFont().isItalic());
            StyleConstants.setBackground(sas, this.getBackground());
            if (this.TSPattern != null && this.sdf != null && !s.equalsIgnoreCase(this.defaultText)) {
                String ts = this.sdf.format(new Date());
                StyleConstants.setForeground(sas, this.getForeground());
                ts = ts.concat(" ");
                try {
                    doc.insertString(doc.getLength(), ts, sas);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ("sent".equalsIgnoreCase(category)) {
                StyleConstants.setForeground(sas, this.clrSent == null ? this.getForeground() : this.clrSent);
            } else if (CATEGORY_PACKETS_RECV.equalsIgnoreCase(category)) {
                StyleConstants.setForeground(sas, this.clrRecv == null ? this.getForeground() : this.clrRecv);
            } else if (CATEGORY_ERROR.equalsIgnoreCase(category)) {
                StyleConstants.setForeground(sas, this.clrError == null ? this.getForeground() : this.clrError);
            }
            try {
                doc.insertString(doc.getLength(), s, sas);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.autoScroll) {
            try {
                int length = doc.getLength();
                this.console.setCaretPosition(length);
                this.scrollRectToVisible(this.console.modelToView(length - 1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JScrollBar vs = this.container.getVerticalScrollBar();
            vs.setValue(vs.getMaximum());
        }
        this.console.invalidate();
        this.repaint();
    }

    public void append(String s) {
        this.append("sent", s);
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
            if (text.trim().length() == 0) {
                this.append(this.defaultText == null ? "" : this.defaultText);
            } else {
                this.append(text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OutputStream createFilteredStream(String category) {
        return new ConsoleOutputStream(this, category);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.autoScroll = !e.getValueIsAdjusting();
    }

    private static class Appender
    implements Runnable {
        LogConsole textView = null;
        String category = null;
        String line = null;

        public Appender(LogConsole console, String category, String line) {
            this.textView = console;
            this.category = category;
            this.line = line;
        }

        public void run() {
            try {
                this.textView.append(this.category, this.line);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ConsoleOutputStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private String category = null;
        private LogConsole reference;

        public ConsoleOutputStream(LogConsole owner, String category) {
            this.reference = owner;
            this.category = category != null ? category : "sent";
        }

        public synchronized void write(int b) {
            this.buf.append(Character.toString((char)b));
        }

        public synchronized void write(byte[] b, int offset, int length) {
            this.buf.append(new String(b, offset, length));
        }

        public synchronized void write(byte[] b) {
            this.buf.append(new String(b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                char last;
                if (this.buf.length() > 0 && ((last = this.buf.charAt(this.buf.length() - 1)) == '\n' || last == '\r')) {
                    String text = this.buf.toString();
                    SwingUtilities.invokeLater(new Appender(this.reference, this.category, text));
                    this.buf.setLength(0);
                }
            }
        }
    }
}

