/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sf.jradius.client.RadiusClient;
import net.sf.jradius.client.auth.RadiusAuthenticator;
import net.sf.jradius.client.auth.TunnelAuthenticator;
import net.sf.jradius.client.gui.AttributesTableEntry;
import net.sf.jradius.client.gui.AttributesTableModel;
import net.sf.jradius.client.gui.LogConsole;
import net.sf.jradius.dictionary.Attr_AcctSessionId;
import net.sf.jradius.dictionary.Attr_AcctStatusType;
import net.sf.jradius.dictionary.Attr_Class;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.exception.StandardViolatedException;
import net.sf.jradius.packet.AccessReject;
import net.sf.jradius.packet.AccessRequest;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.RadiusRequest;
import net.sf.jradius.packet.RadiusResponse;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.packet.attribute.VSADictionary;
import net.sf.jradius.packet.attribute.value.NamedValue;
import net.sf.jradius.standard.IRAPStandard;
import net.sf.jradius.standard.RadiusStandard;
import net.sf.jradius.standard.WISPrStandard;
import net.sf.jradius.util.Base64;
import net.sf.jradius.util.RadiusRandom;

public class JRadiusSimulator
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 0L;
    public static final String logSepLine = "----------------------------------------------------------";
    private static String configFileUrl = "file://" + System.getProperty("user.home") + "/.jRadiusSimulator";
    private String[] authTypeNames = new String[]{"PAP", "CHAP", "MSCHAPv1", "MSCHAPv2", "EAP-MD5", "EAP-MSCHAPv2", "EAP-TLS", "EAP-TTLS/PAP"};
    private String[] keystoreTypes = new String[]{"PKCS12", "JKS"};
    private Properties properties;
    private Thread simulationThread = null;
    boolean interactiveSession = false;
    private final HashMap namedValueComponentCache = new HashMap();
    private NumberFormatter numberFormatter;
    private PrintStream logSent;
    private PrintStream logRecv;
    private PrintStream logErr;
    private AttributesTableModel attributesTableModel = new AttributesTableModel();
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem saveMenuItem = null;
    private JMenuItem saveAsMenuItem = null;
    private JMenuItem openMenuItem = null;
    private JMenuItem openUrlMenuItem = null;
    private JTabbedPane mainTabPane = null;
    private JPanel runPanel = null;
    private JPanel logPanel = null;
    private JPanel runStatusPanel = null;
    private LogConsole logConsole = null;
    private JPanel logButtonPanel = null;
    private JPanel mainContentPane = null;
    private JButton clearLogButton = null;
    private JButton saveLogButton = null;
    private JToggleButton runButton = null;
    private JScrollPane attributesTableScrollPane = null;
    private JTable attributesTable = null;
    private JPanel sendOptionsPanel = null;
    private JButton addAttributeButton = null;
    private JDialog addAttributeDialog = null;
    private JPanel addAttributeContentPane = null;
    private JTree attributeTree = null;
    private JPanel addAttributePanel = null;
    private JComboBox authTypeComboBox = null;
    private JComboBox checkStandardComboBox = null;
    private JLabel statusLabel = null;
    private JPanel attributesPanel = null;
    private JPanel tlsPanel = null;
    private JPanel tlsOptionsPanel = null;
    private JTextField radiusServerTextField = null;
    private JTextField tlsKeyFileTextField = null;
    private JTextField tlsKeyPasswordTextField = null;
    private JTextField tlsCAFileTextField = null;
    private JTextField tlsCAPasswordTextField = null;
    private JComboBox tlsKeyFileTypeComboBox = null;
    private JComboBox tlsCAFileTypeComboBox = null;
    private JCheckBox tlsTrustAll = null;
    private JCheckBox tlsUseJavaRootCA = null;
    private JLabel radiusServerLabel = null;
    private JLabel simulationTypeLabel = null;
    private JLabel checkStandardLabel = null;
    private JLabel sharedSecretLabel = null;
    private JTextField sharedSecretTextField = null;
    private JLabel authenticationProtocolLabel = null;
    private JButton doneButton = null;
    private JScrollPane attributeTreeScrollPane = null;
    private JPanel attributeTreeScrollPanel = null;
    private JButton addButton = null;
    private JComboBox simulationTypeComboBox = null;
    private JPanel attributesButtonPanel = null;
    private JButton removeAttributeButton = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JFormattedTextField radiusAuthPortTextField = null;
    private JLabel radiusAuthPortLabel = null;
    private JFormattedTextField radiusAcctPortTextField = null;
    private JLabel radiusAcctPortLabel = null;
    private JFormattedTextField radiusRetriesTextField = null;
    private JLabel radiusRetriesLabel = null;
    private JFormattedTextField radiusTimeoutTextField = null;
    private JLabel radiusTimeoutLabel = null;
    private JFormattedTextField radiusInterimIntervalTextField = null;
    private JLabel radiusInterimIntervalLabel = null;
    private JFormattedTextField sessionTimeTextField = null;
    private JLabel sessionTimeLabel = null;
    private JLabel optionsLabel = null;
    private JCheckBox generateAcctSessionIdCheckBox = null;
    private JCheckBox notStopOnRejectCheckBox = null;
    private JCheckBox notSendClassAttribute = null;
    private JDialog openUrlDialog = null;
    private JPanel openUrlContentPane = null;
    private JLabel openUrlLabel = null;
    private JTextField openUrlTextField = null;
    private JButton openUrlButton = null;
    private JLabel openUrlStatusLabel = null;
    private JButton cancelUrlButton = null;
    private boolean isJava15 = false;
    static /* synthetic */ Class class$net$sf$jradius$packet$attribute$value$NamedValue;
    static /* synthetic */ Class class$net$sf$jradius$packet$attribute$value$IntegerValue;
    static /* synthetic */ Class class$java$lang$Integer;

    public JRadiusSimulator() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.5")) {
            this.isJava15 = true;
        } else {
            for (int i = 0; i < this.authTypeNames.length; ++i) {
                if (!this.authTypeNames[i].startsWith("EAP-T")) continue;
                int n = i;
                this.authTypeNames[n] = this.authTypeNames[n] + " (requires Java 1.5)";
            }
        }
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(650, 500);
        this.setContentPane(this.getMainContentPane());
        this.setTitle("JRadiusSimulator");
        this.setVisible(true);
        this.logSent = new PrintStream(this.logConsole.createFilteredStream("sent"));
        this.logRecv = new PrintStream(this.logConsole.createFilteredStream("recv"));
        this.logErr = new PrintStream(this.logConsole.createFilteredStream("err"));
        AttributeFactory.loadAttributeDictionary("net.sf.jradius.dictionary.AttributeDictionaryImpl");
        try {
            this.loadConfigFile(configFileUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.statusLabel.setText("Ready");
        this.fileMenu.setEnabled(true);
        this.mainTabPane.setEnabled(true);
        this.runButton.setEnabled(true);
    }

    private void loadConfigFile(String url) throws IOException {
        this.properties = new Properties();
        this.loadConfigFile(new URL(url).openStream());
    }

    private void loadConfigFile(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        String s = this.properties.getProperty("AttributesTableEntries");
        if (s != null) {
            this.attributesTableModel.setEntries((ArrayList)Base64.decodeToObject(s));
            this.attributesTableModel.fireTableDataChanged();
        }
        if ((s = this.properties.getProperty("RadiusServer")) != null) {
            this.radiusServerTextField.setText(s);
        }
        if ((s = this.properties.getProperty("SharedSecret")) != null) {
            this.sharedSecretTextField.setText(s);
        }
        if ((s = this.properties.getProperty("AuthPort")) != null) {
            this.radiusAuthPortTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("AcctPort")) != null) {
            this.radiusAcctPortTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("Retries")) != null) {
            this.radiusRetriesTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("Timeout")) != null) {
            this.radiusTimeoutTextField.setValue(new Integer(s));
        }
        if ((s = this.properties.getProperty("SimulationType")) != null) {
            try {
                this.simulationTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("AuthType")) != null) {
            try {
                this.authTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("CheckStandard")) != null) {
            try {
                this.checkStandardComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("GenerateAcctSessionId")) != null) {
            try {
                this.generateAcctSessionIdCheckBox.setSelected(new Boolean(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("StopOnReject")) != null) {
            try {
                this.notStopOnRejectCheckBox.setSelected(new Boolean(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("SendClassAttr")) != null) {
            try {
                this.notSendClassAttribute.setSelected(new Boolean(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("TLSKeyFile")) != null) {
            this.tlsKeyFileTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSKeyPassword")) != null) {
            this.tlsKeyPasswordTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSCAFile")) != null) {
            this.tlsCAFileTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSCAPassword")) != null) {
            this.tlsCAPasswordTextField.setText(s);
        }
        if ((s = this.properties.getProperty("TLSKeyFileType")) != null) {
            try {
                this.tlsKeyFileTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("TLSCAFileType")) != null) {
            try {
                this.tlsCAFileTypeComboBox.setSelectedIndex(Integer.parseInt(s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((s = this.properties.getProperty("TLSTrustAll")) != null) {
            try {
                this.tlsTrustAll.setSelected(new Boolean(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveConfigFile(String fileName) {
        try {
            String encodedAttributes = Base64.encodeObject(this.attributesTableModel.getEntries(), 10);
            this.properties.setProperty("AttributesTableEntries", encodedAttributes);
            this.properties.setProperty("RadiusServer", this.radiusServerTextField.getText());
            this.properties.setProperty("SharedSecret", this.sharedSecretTextField.getText());
            this.properties.setProperty("SimulationType", "" + this.simulationTypeComboBox.getSelectedIndex());
            this.properties.setProperty("AuthType", "" + this.authTypeComboBox.getSelectedIndex());
            this.properties.setProperty("CheckStandard", "" + this.checkStandardComboBox.getSelectedIndex());
            this.properties.setProperty("AuthPort", ((Integer)this.radiusAuthPortTextField.getValue()).toString());
            this.properties.setProperty("AcctPort", ((Integer)this.radiusAcctPortTextField.getValue()).toString());
            this.properties.setProperty("Retries", ((Integer)this.radiusRetriesTextField.getValue()).toString());
            this.properties.setProperty("Timeout", ((Integer)this.radiusTimeoutTextField.getValue()).toString());
            this.properties.setProperty("GenerateAcctSessionId", Boolean.toString(this.generateAcctSessionIdCheckBox.isSelected()));
            this.properties.setProperty("StopOnReject", Boolean.toString(this.notStopOnRejectCheckBox.isSelected()));
            this.properties.setProperty("SendClassAttr", Boolean.toString(this.notSendClassAttribute.isSelected()));
            this.properties.setProperty("TLSKeyFile", this.tlsKeyFileTextField.getText());
            this.properties.setProperty("TLSKeyPassword", this.tlsKeyPasswordTextField.getText());
            this.properties.setProperty("TLSCAFile", this.tlsCAFileTextField.getText());
            this.properties.setProperty("TLSCAPassword", this.tlsCAPasswordTextField.getText());
            this.properties.setProperty("TLSKeyFileType", "" + this.tlsKeyFileTypeComboBox.getSelectedIndex());
            this.properties.setProperty("TLSCAFileType", "" + this.tlsCAFileTypeComboBox.getSelectedIndex());
            this.properties.setProperty("TLSTrustAll", Boolean.toString(this.tlsTrustAll.isSelected()));
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            this.properties.store(fileOutputStream, "JRadiusSimulator");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setConfigFileUrl(String fileName) {
        configFileUrl = fileName;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.add(this.getSaveAsMenuItem());
            this.fileMenu.add(this.getOpenMenuItem());
            this.fileMenu.add(this.getOpenUrlMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
            this.fileMenu.setEnabled(false);
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(JRadiusSimulator.this, "Version 1.0.1\n\nFor help, go to http://jradius.sf.net/simulator.html\nJRadiusSimulator uses JRadius - http://jradius.sf.net\n\nLicensed under the GNU Public License (GPL).\nSee http://jradius.sf.net/license.html for details.\n\nCopyright (c) 2005 PicoPoint Technologies, The Netherlands\n", "About JRadiusSimulator", 1, null);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText("Save");
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
            this.saveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (configFileUrl.startsWith("file://")) {
                        JRadiusSimulator.this.saveConfigFile(configFileUrl.substring(7));
                    } else {
                        JRadiusSimulator.this.doSaveAs();
                    }
                }
            });
        }
        return this.saveMenuItem;
    }

    private JMenuItem getSaveAsMenuItem() {
        if (this.saveAsMenuItem == null) {
            this.saveAsMenuItem = new JMenuItem();
            this.saveAsMenuItem.setText("Save As");
            this.saveAsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.doSaveAs();
                }
            });
        }
        return this.saveAsMenuItem;
    }

    private void doSaveAs() {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            this.saveConfigFile(file.getAbsolutePath());
        }
    }

    private JMenuItem getOpenMenuItem() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem();
            this.openMenuItem.setText("Open");
            this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, true));
            this.openMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showOpenDialog(JRadiusSimulator.this);
                    if (returnVal == 0) {
                        File file = chooser.getSelectedFile();
                        try {
                            JRadiusSimulator.this.loadConfigFile("file://" + file.getAbsolutePath());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.openMenuItem;
    }

    private JMenuItem getOpenUrlMenuItem() {
        if (this.openUrlMenuItem == null) {
            this.openUrlMenuItem = new JMenuItem();
            this.openUrlMenuItem.setText("Open Url");
            this.openUrlMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.getOpenUrlDialog().setVisible(true);
                }
            });
        }
        return this.openUrlMenuItem;
    }

    private JTabbedPane getMainTabPane() {
        if (this.mainTabPane == null) {
            this.mainTabPane = new JTabbedPane();
            this.mainTabPane.addTab("Run", null, this.getRunPanel(), null);
            this.mainTabPane.addTab("Attributes", null, this.getAttributesPanel(), null);
            this.mainTabPane.addTab("TLS", null, this.getTLSPanel(), null);
            this.mainTabPane.addTab("Log", null, this.getLogPanel(), null);
            this.mainTabPane.setEnabled(false);
        }
        return this.mainTabPane;
    }

    private JPanel getRunPanel() {
        if (this.runPanel == null) {
            this.runPanel = new JPanel();
            this.runPanel.setLayout(new BorderLayout());
            this.runPanel.add((Component)this.getRunStatusPanel(), "South");
            this.runPanel.add((Component)this.getSendOptionsPanel(), "North");
        }
        return this.runPanel;
    }

    private JPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new JPanel();
            this.logPanel.setLayout(new BorderLayout());
            this.logPanel.add((Component)this.getLogConsole(), "Center");
            this.logPanel.add((Component)this.getLogButtonPanel(), "South");
        }
        return this.logPanel;
    }

    private JPanel getRunStatusPanel() {
        if (this.runStatusPanel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText("Initializing...");
            this.runStatusPanel = new JPanel();
            this.runStatusPanel.setLayout(new BorderLayout());
            this.runStatusPanel.add((Component)this.getRunButton(), "East");
            this.runStatusPanel.add((Component)this.statusLabel, "Center");
        }
        return this.runStatusPanel;
    }

    private LogConsole getLogConsole() {
        if (this.logConsole == null) {
            this.logConsole = new LogConsole();
        }
        return this.logConsole;
    }

    private JPanel getLogButtonPanel() {
        if (this.logButtonPanel == null) {
            this.logButtonPanel = new JPanel();
            this.logButtonPanel.add((Component)this.getClearLogButton(), null);
            this.logButtonPanel.add((Component)this.getSaveLogButton(), null);
        }
        return this.logButtonPanel;
    }

    private JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setLayout(new BorderLayout());
            this.mainContentPane.add((Component)this.getMainTabPane(), "Center");
        }
        return this.mainContentPane;
    }

    private JButton getClearLogButton() {
        if (this.clearLogButton == null) {
            this.clearLogButton = new JButton();
            this.clearLogButton.setText("Clear");
            this.clearLogButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.logConsole.setText("");
                }
            });
        }
        return this.clearLogButton;
    }

    private JButton getSaveLogButton() {
        if (this.saveLogButton == null) {
            this.saveLogButton = new JButton();
            this.saveLogButton.setText("Save");
            this.saveLogButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showSaveDialog(JRadiusSimulator.this);
                    if (returnVal == 0) {
                        File file = chooser.getSelectedFile();
                        try {
                            FileOutputStream out = new FileOutputStream(file);
                            out.write(JRadiusSimulator.this.logConsole.getText().getBytes());
                            out.close();
                        }
                        catch (Exception ex) {
                            System.err.println(ex.getMessage());
                        }
                    }
                }
            });
        }
        return this.saveLogButton;
    }

    private JToggleButton getRunButton() {
        if (this.runButton == null) {
            this.runButton = new JToggleButton();
            this.runButton.setText("Start");
            this.runButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractButton ab = (AbstractButton)e.getSource();
                    if (ab.isSelected()) {
                        JRadiusSimulator.this.simulationThread = new Thread(JRadiusSimulator.this);
                        JRadiusSimulator.this.simulationThread.start();
                        JRadiusSimulator.this.runButton.setText("Stop");
                    } else {
                        if (JRadiusSimulator.this.simulationThread != null) {
                            JRadiusSimulator.this.simulationThread.interrupt();
                        }
                        JRadiusSimulator.this.simulationThread = null;
                        JRadiusSimulator.this.statusLabel.setText("Ready");
                        JRadiusSimulator.this.runButton.setText("Start");
                    }
                }
            });
            this.runButton.setEnabled(false);
        }
        return this.runButton;
    }

    private JScrollPane getAttributesTableScrollPane() {
        if (this.attributesTableScrollPane == null) {
            this.attributesTableScrollPane = new JScrollPane();
            this.attributesTableScrollPane.setViewportView(this.getAttributesTable());
        }
        return this.attributesTableScrollPane;
    }

    private JTable getAttributesTable() {
        if (this.attributesTable == null) {
            this.attributesTable = new JTable(this.attributesTableModel);
            TableColumn col = this.attributesTable.getColumnModel().getColumn(6);
            col.setCellEditor(new ValueTableCellEditor());
            for (int i = 0; i < this.attributesTableModel.getColumnCount(); ++i) {
                col = this.attributesTable.getColumnModel().getColumn(i);
                if (i == 0 || i == 6) {
                    col.setPreferredWidth(120);
                    continue;
                }
                col.setPreferredWidth(40);
            }
        }
        return this.attributesTable;
    }

    private JComboBox createNamedValueCellEditor(String attributeName) {
        JComboBox comboBox = (JComboBox)this.namedValueComponentCache.get(attributeName);
        if (comboBox != null) {
            return comboBox;
        }
        try {
            RadiusAttribute attribute = AttributeFactory.newAttribute(attributeName);
            NamedValue namedValue = (NamedValue)attribute.getValue();
            Map map = namedValue.getValueMap();
            comboBox = new JComboBox();
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof String)) continue;
                comboBox.addItem(obj);
            }
            this.namedValueComponentCache.put(attributeName, comboBox);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return comboBox;
    }

    private JPanel getSendOptionsPanel() {
        if (this.sendOptionsPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints3.weightx = 1.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridwidth = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridwidth = 0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints7.weightx = 1.0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridwidth = 0;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints9.weightx = 1.0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridwidth = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints11.weightx = 1.0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridwidth = 0;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints13.weightx = 1.0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridwidth = 0;
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints15.weightx = 1.0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridwidth = 0;
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.gridx = 1;
            this.authenticationProtocolLabel = new JLabel();
            this.authenticationProtocolLabel.setText("Authentication Protocol:");
            this.sharedSecretLabel = new JLabel();
            this.sharedSecretLabel.setText("Shared Secret:");
            this.radiusServerLabel = new JLabel();
            this.radiusServerLabel.setText("RADIUS Server:");
            this.simulationTypeLabel = new JLabel();
            this.simulationTypeLabel.setText("Simulation Type:");
            this.checkStandardLabel = new JLabel();
            this.checkStandardLabel.setText("Verify Standard:");
            this.radiusAuthPortLabel = new JLabel();
            this.radiusAuthPortLabel.setText("Auth Port:");
            this.radiusAcctPortLabel = new JLabel();
            this.radiusAcctPortLabel.setText("Acct Port:");
            this.radiusRetriesLabel = new JLabel();
            this.radiusRetriesLabel.setText("Send Retries:");
            this.radiusTimeoutLabel = new JLabel();
            this.radiusTimeoutLabel.setText("Send Timeout (sec):");
            this.radiusInterimIntervalLabel = new JLabel();
            this.radiusInterimIntervalLabel.setText("Interim Interval (sec):");
            this.sessionTimeLabel = new JLabel();
            this.sessionTimeLabel.setText("Session Duration (sec):");
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.sendOptionsPanel = new JPanel();
            this.sendOptionsPanel.setLayout(gridBagLayout);
            this.sendOptionsPanel.add((Component)this.radiusServerLabel, gridBagConstraints);
            this.sendOptionsPanel.add((Component)this.getRadiusServerTextField(), gridBagConstraints1);
            this.sendOptionsPanel.add((Component)this.sharedSecretLabel, gridBagConstraints2);
            this.sendOptionsPanel.add((Component)this.getSharedSecretTextField(), gridBagConstraints3);
            this.sendOptionsPanel.add((Component)this.radiusAuthPortLabel, gridBagConstraints8);
            this.sendOptionsPanel.add((Component)this.getRadiusAuthPortTextField(), gridBagConstraints9);
            this.sendOptionsPanel.add((Component)this.radiusAcctPortLabel, gridBagConstraints10);
            this.sendOptionsPanel.add((Component)this.getRadiusAcctPortTextField(), gridBagConstraints11);
            this.sendOptionsPanel.add((Component)this.radiusTimeoutLabel, gridBagConstraints12);
            this.sendOptionsPanel.add((Component)this.getRadiusTimeoutTextField(), gridBagConstraints13);
            this.sendOptionsPanel.add((Component)this.radiusRetriesLabel, gridBagConstraints12);
            this.sendOptionsPanel.add((Component)this.getRadiusRetriesTextField(), gridBagConstraints13);
            this.sendOptionsPanel.add((Component)this.simulationTypeLabel, gridBagConstraints4);
            this.sendOptionsPanel.add((Component)this.getSimulationTypeComboBox(), gridBagConstraints5);
            this.sendOptionsPanel.add((Component)this.authenticationProtocolLabel, gridBagConstraints6);
            this.sendOptionsPanel.add((Component)this.getAuthTypeComboBox(), gridBagConstraints7);
            this.sendOptionsPanel.add((Component)this.checkStandardLabel, gridBagConstraints6);
            this.sendOptionsPanel.add((Component)this.getCheckStandardComboBox(), gridBagConstraints7);
            this.sendOptionsPanel.add((Component)this.getOptionsLabel(), gridBagConstraints14);
            this.sendOptionsPanel.add((Component)this.getGenerateAcctSessionIdCheckBox(), gridBagConstraints15);
            this.sendOptionsPanel.add((Component)this.getNotStopOnRejectCheckBox(), gridBagConstraints16);
            this.sendOptionsPanel.add((Component)this.getSendClassAttributeCheckBox(), gridBagConstraints16);
        }
        return this.sendOptionsPanel;
    }

    private JLabel getOptionsLabel() {
        this.optionsLabel = new JLabel();
        this.optionsLabel.setText("Options:");
        return this.optionsLabel;
    }

    private JButton getAddAttributeButton() {
        if (this.addAttributeButton == null) {
            this.addAttributeButton = new JButton();
            this.addAttributeButton.setText("Add Attribute");
            this.addAttributeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialog dialog = JRadiusSimulator.this.getAddAttributeDialog();
                    dialog.setModal(true);
                    dialog.setVisible(true);
                }
            });
        }
        return this.addAttributeButton;
    }

    private JDialog getAddAttributeDialog() {
        if (this.addAttributeDialog == null) {
            this.addAttributeDialog = new JDialog();
            this.addAttributeDialog.setSize(350, 300);
            this.addAttributeDialog.setTitle("Add Attributes");
            this.addAttributeDialog.setContentPane(this.getAddAttributeContentPane());
        }
        return this.addAttributeDialog;
    }

    private JPanel getAddAttributeContentPane() {
        if (this.addAttributeContentPane == null) {
            this.addAttributeContentPane = new JPanel();
            this.addAttributeContentPane.setLayout(new BorderLayout());
            this.addAttributeContentPane.add((Component)this.getAddAttributePanel(), "South");
            this.addAttributeContentPane.add((Component)this.getAttributeTreeScrollPane(), "Center");
        }
        return this.addAttributeContentPane;
    }

    private JTree getAttributeTree() {
        if (this.attributeTree == null) {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode("Attribute Dictionary");
            this.createAttributeTreeNodes(top);
            this.attributeTree = new JTree(top);
        }
        return this.attributeTree;
    }

    private void createAttributeTreeNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode standardTree = new DefaultMutableTreeNode("Standard Attributes");
        DefaultMutableTreeNode vsaTree = new DefaultMutableTreeNode("Vendor Specific Attributes");
        this.addAttributesToTable(standardTree, AttributeFactory.getAttributeMap());
        top.add(standardTree);
        LinkedHashMap vendors = AttributeFactory.getVendorMap();
        LinkedHashMap<String, Map> dictList = new LinkedHashMap<String, Map>();
        Iterator i = vendors.values().iterator();
        while (i.hasNext()) {
            AttributeFactory.VendorValue vendor = (AttributeFactory.VendorValue)i.next();
            try {
                VSADictionary dict = (VSADictionary)vendor.getDictClass().newInstance();
                String vendorName = dict.getVendorName();
                dictList.put(vendorName, vendor.getAttributeMap());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedList list = new LinkedList(dictList.keySet());
        Collections.sort(list);
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            String vendorName = (String)i2.next();
            DefaultMutableTreeNode vsaNode = new DefaultMutableTreeNode(vendorName);
            this.addAttributesToTable(vsaNode, (Map)dictList.get(vendorName));
            vsaTree.add(vsaNode);
        }
        top.add(vsaTree);
    }

    private void addAttributesToTable(DefaultMutableTreeNode node, Map attributes) {
        LinkedHashMap<Integer, String> attributeList = new LinkedHashMap<Integer, String>();
        Iterator i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Integer type = (Integer)entry.getKey();
            Class clazz = (Class)entry.getValue();
            if (type > 255) continue;
            try {
                RadiusAttribute attribute = (RadiusAttribute)clazz.newInstance();
                String attributeName = attribute.getAttributeName();
                if (attributeName.equals("Vendor-Specific") || attributeName.startsWith("X-Ascend-")) continue;
                attributeList.put(type, attributeName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedList list = new LinkedList(attributeList.keySet());
        Collections.sort(list);
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            node.add(new DefaultMutableTreeNode(attributeList.get(i2.next())));
        }
    }

    private JPanel getAddAttributePanel() {
        if (this.addAttributePanel == null) {
            this.addAttributePanel = new JPanel();
            this.addAttributePanel.add((Component)this.getAddButton(), null);
            this.addAttributePanel.add((Component)this.getDoneButton(), null);
        }
        return this.addAttributePanel;
    }

    private JComboBox getAuthTypeComboBox() {
        if (this.authTypeComboBox == null) {
            this.authTypeComboBox = new JComboBox<String>(this.authTypeNames);
        }
        return this.authTypeComboBox;
    }

    private RadiusAuthenticator getAuthenticator() throws Exception {
        String authName = this.authTypeNames[this.authTypeComboBox.getSelectedIndex()];
        if (authName.startsWith("EAP-T")) {
            if (!this.isJava15) {
                throw new Exception(authName + " not available with this Java version");
            }
            String[] s = authName.split("/");
            StringBuffer sb = new StringBuffer(s[0]);
            String v = this.tlsKeyFileTextField.getText();
            if (v != null && !"".equals(v)) {
                sb.append(":keyFile=").append(v);
            }
            if ((v = (String)this.tlsKeyFileTypeComboBox.getSelectedItem()) != null && !"".equals(v)) {
                sb.append(":keyFileType=").append(v);
            }
            if ((v = this.tlsKeyPasswordTextField.getText()) != null && !"".equals(v)) {
                sb.append(":keyPassword=").append(v);
            }
            if ((v = this.tlsCAFileTextField.getText()) != null && !"".equals(v)) {
                sb.append(":caFile=").append(v);
            }
            if ((v = (String)this.tlsCAFileTypeComboBox.getSelectedItem()) != null && !"".equals(v)) {
                sb.append(":caFileType=").append(v);
            }
            if ((v = this.tlsCAPasswordTextField.getText()) != null && !"".equals(v)) {
                sb.append(":caPassword=").append(v);
            }
            if (this.tlsTrustAll.isSelected()) {
                sb.append(":trustAll=true");
            }
            if (s.length == 2) {
                sb.append(":innerProtocol=").append(s[1]);
            }
            authName = sb.toString();
            System.out.println("Using Authenticator String: " + authName);
        }
        return RadiusClient.getAuthProtocol(authName);
    }

    private JComboBox getCheckStandardComboBox() {
        if (this.checkStandardComboBox == null) {
            this.checkStandardComboBox = new JComboBox<String>(new String[]{"None", "IRAP", "WISPr"});
        }
        return this.checkStandardComboBox;
    }

    private JComboBox getTLSCAFileTypeComboBox() {
        if (this.tlsCAFileTypeComboBox == null) {
            this.tlsCAFileTypeComboBox = new JComboBox<String>(this.keystoreTypes);
        }
        return this.tlsCAFileTypeComboBox;
    }

    private JComboBox getTLSKeyFileTypeComboBox() {
        if (this.tlsKeyFileTypeComboBox == null) {
            this.tlsKeyFileTypeComboBox = new JComboBox<String>(this.keystoreTypes);
        }
        return this.tlsKeyFileTypeComboBox;
    }

    private JPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new JPanel();
            this.attributesPanel.setLayout(new BorderLayout());
            this.attributesPanel.add((Component)this.getAttributesTableScrollPane(), "Center");
            this.attributesPanel.add((Component)this.getAttributesButtonPanel(), "South");
        }
        return this.attributesPanel;
    }

    private JPanel getTLSPanel() {
        if (this.tlsPanel == null) {
            this.tlsPanel = new JPanel();
            this.tlsPanel.setLayout(new BorderLayout());
            this.tlsPanel.add((Component)this.getTLSOptionsPanel(), "North");
        }
        return this.tlsPanel;
    }

    private JPanel getTLSOptionsPanel() {
        if (this.tlsOptionsPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 5);
            GridBagConstraints gridBagConstraintsH = new GridBagConstraints();
            gridBagConstraintsH.insets = new Insets(10, 10, 5, 10);
            gridBagConstraintsH.gridwidth = 0;
            GridBagConstraints gridBagConstraints0 = new GridBagConstraints();
            gridBagConstraints0.fill = 2;
            gridBagConstraints0.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints0.gridwidth = 0;
            gridBagConstraints0.weightx = 1.0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.tlsOptionsPanel = new JPanel();
            this.tlsOptionsPanel.setLayout(gridBagLayout);
            this.tlsOptionsPanel.add((Component)new JLabel("Client Certificate Java Keystore"), gridBagConstraintsH);
            this.tlsOptionsPanel.add((Component)new JLabel("File:"), gridBagConstraints);
            this.tlsOptionsPanel.add((Component)this.getTLSKeyFileTextField(), gridBagConstraints0);
            this.tlsOptionsPanel.add((Component)new JLabel("Password:"), gridBagConstraints);
            this.tlsOptionsPanel.add((Component)this.getTLSKeyPasswordTextField(), gridBagConstraints1);
            this.tlsOptionsPanel.add((Component)new JLabel("Type:"), gridBagConstraints4);
            this.tlsOptionsPanel.add((Component)this.getTLSKeyFileTypeComboBox(), gridBagConstraints2);
            this.tlsOptionsPanel.add((Component)new JLabel("Root CA Chain Java Keystore"), gridBagConstraintsH);
            this.tlsOptionsPanel.add((Component)new JLabel("File:"), gridBagConstraints);
            this.tlsOptionsPanel.add((Component)this.getTLSCAFileTextField(), gridBagConstraints0);
            this.tlsOptionsPanel.add((Component)new JLabel("Password:"), gridBagConstraints);
            this.tlsOptionsPanel.add((Component)this.getTLSCAPasswordTextField(), gridBagConstraints1);
            this.tlsOptionsPanel.add((Component)new JLabel("Type:"), gridBagConstraints4);
            this.tlsOptionsPanel.add((Component)this.getTLSCAFileTypeComboBox(), gridBagConstraints2);
            this.tlsOptionsPanel.add((Component)this.getOptionsLabel(), gridBagConstraints);
            this.tlsOptionsPanel.add((Component)this.getTLSTrustAllCheckBox(), gridBagConstraints2);
        }
        return this.tlsOptionsPanel;
    }

    private JTextField getTLSKeyFileTextField() {
        if (this.tlsKeyFileTextField == null) {
            this.tlsKeyFileTextField = new JTextField(100);
        }
        return this.tlsKeyFileTextField;
    }

    private JTextField getTLSKeyPasswordTextField() {
        if (this.tlsKeyPasswordTextField == null) {
            this.tlsKeyPasswordTextField = new JTextField(100);
        }
        return this.tlsKeyPasswordTextField;
    }

    private JTextField getTLSCAFileTextField() {
        if (this.tlsCAFileTextField == null) {
            this.tlsCAFileTextField = new JTextField(100);
        }
        return this.tlsCAFileTextField;
    }

    private JTextField getTLSCAPasswordTextField() {
        if (this.tlsCAPasswordTextField == null) {
            this.tlsCAPasswordTextField = new JTextField(100);
        }
        return this.tlsCAPasswordTextField;
    }

    private JTextField getRadiusServerTextField() {
        if (this.radiusServerTextField == null) {
            this.radiusServerTextField = new JTextField(100);
        }
        return this.radiusServerTextField;
    }

    private JTextField getSharedSecretTextField() {
        if (this.sharedSecretTextField == null) {
            this.sharedSecretTextField = new JTextField(40);
        }
        return this.sharedSecretTextField;
    }

    private JButton getDoneButton() {
        if (this.doneButton == null) {
            this.doneButton = new JButton();
            this.doneButton.setText("Done");
            this.doneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.addAttributeDialog.dispose();
                }
            });
        }
        return this.doneButton;
    }

    private JScrollPane getAttributeTreeScrollPane() {
        if (this.attributeTreeScrollPane == null) {
            this.attributeTreeScrollPane = new JScrollPane();
            this.attributeTreeScrollPane.setViewportView(this.getAttributeTreeScrollPanel());
        }
        return this.attributeTreeScrollPane;
    }

    private JPanel getAttributeTreeScrollPanel() {
        if (this.attributeTreeScrollPanel == null) {
            this.attributeTreeScrollPanel = new JPanel();
            this.attributeTreeScrollPanel.add((Component)this.getAttributeTree(), null);
        }
        return this.attributeTreeScrollPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] rows = JRadiusSimulator.this.attributeTree.getSelectionRows();
                    if (rows != null) {
                        for (int i = 0; i < rows.length; ++i) {
                            TreePath path = JRadiusSimulator.this.attributeTree.getPathForRow(rows[i]);
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                            String attr = (String)node.getUserObject();
                            try {
                                JRadiusSimulator.this.attributesTableModel.addAttribute(AttributeFactory.newAttribute(attr));
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                    }
                }
            });
        }
        return this.addButton;
    }

    private JComboBox getSimulationTypeComboBox() {
        if (this.simulationTypeComboBox == null) {
            this.simulationTypeComboBox = new JComboBox<String>(new String[]{"Auth Only", "Auth & Acct (Start, Interim, Stop)", "Auth & Acct (Start, Stop)"});
        }
        return this.simulationTypeComboBox;
    }

    private JPanel getAttributesButtonPanel() {
        if (this.attributesButtonPanel == null) {
            this.attributesButtonPanel = new JPanel();
            this.attributesButtonPanel.add((Component)this.getAddAttributeButton(), null);
            this.attributesButtonPanel.add((Component)this.getMoveUpButton(), null);
            this.attributesButtonPanel.add((Component)this.getMoveDownButton(), null);
            this.attributesButtonPanel.add((Component)this.getRemoveAttributeButton(), null);
        }
        return this.attributesButtonPanel;
    }

    private JButton getRemoveAttributeButton() {
        if (this.removeAttributeButton == null) {
            this.removeAttributeButton = new JButton();
            this.removeAttributeButton.setText("Remove Attribute");
            this.removeAttributeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedIndex = JRadiusSimulator.this.attributesTable.getSelectedRows();
                    if (selectedIndex == null) {
                        return;
                    }
                    for (int i = 0; i < selectedIndex.length; ++i) {
                        JRadiusSimulator.this.attributesTableModel.getEntries().remove(selectedIndex[i]);
                    }
                    JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                }
            });
        }
        return this.removeAttributeButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton();
            this.moveUpButton.setText("Move Up");
            this.moveUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = JRadiusSimulator.this.attributesTable.getSelectedRow();
                    if (selectedIndex <= 0) {
                        return;
                    }
                    ArrayList list = JRadiusSimulator.this.attributesTableModel.getEntries();
                    ArrayList<Object> newList = new ArrayList<Object>();
                    Object[] oList = list.toArray();
                    Object selectedObject = null;
                    for (int i = 0; i < oList.length; ++i) {
                        if (i == selectedIndex) {
                            newList.add(oList[i]);
                            newList.add(selectedObject);
                            continue;
                        }
                        if (i == selectedIndex - 1) {
                            selectedObject = oList[i];
                            continue;
                        }
                        newList.add(oList[i]);
                    }
                    JRadiusSimulator.this.attributesTableModel.setEntries(newList);
                    JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                    JRadiusSimulator.this.attributesTable.setRowSelectionInterval(--selectedIndex, selectedIndex);
                }
            });
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton();
            this.moveDownButton.setText("Move Down");
            this.moveDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = JRadiusSimulator.this.attributesTable.getSelectedRow();
                    if (selectedIndex == -1) {
                        return;
                    }
                    ArrayList list = JRadiusSimulator.this.attributesTableModel.getEntries();
                    if (selectedIndex >= list.size() - 1) {
                        return;
                    }
                    ArrayList<Object> newList = new ArrayList<Object>();
                    Object[] oList = list.toArray();
                    Object selectedObject = null;
                    for (int i = 0; i < oList.length; ++i) {
                        if (i == selectedIndex) {
                            selectedObject = oList[i];
                            continue;
                        }
                        if (i == selectedIndex + 1) {
                            newList.add(oList[i]);
                            newList.add(selectedObject);
                            continue;
                        }
                        newList.add(oList[i]);
                    }
                    JRadiusSimulator.this.attributesTableModel.setEntries(newList);
                    JRadiusSimulator.this.attributesTableModel.fireTableDataChanged();
                    JRadiusSimulator.this.attributesTable.setRowSelectionInterval(++selectedIndex, selectedIndex);
                }
            });
        }
        return this.moveDownButton;
    }

    private JCheckBox getGenerateAcctSessionIdCheckBox() {
        if (this.generateAcctSessionIdCheckBox == null) {
            this.generateAcctSessionIdCheckBox = new JCheckBox();
            this.generateAcctSessionIdCheckBox.setText("Generate Unique Acct-Session-Id");
        }
        return this.generateAcctSessionIdCheckBox;
    }

    private JCheckBox getUseJavaRootCAChainCheckBox() {
        if (this.tlsUseJavaRootCA == null) {
            this.tlsUseJavaRootCA = new JCheckBox();
            this.tlsUseJavaRootCA.setText("Use Java's Root CA Chain");
        }
        return this.tlsUseJavaRootCA;
    }

    private JCheckBox getTLSTrustAllCheckBox() {
        if (this.tlsTrustAll == null) {
            this.tlsTrustAll = new JCheckBox();
            this.tlsTrustAll.setText("Trust All Server Certificates");
        }
        return this.tlsTrustAll;
    }

    private JCheckBox getNotStopOnRejectCheckBox() {
        if (this.notStopOnRejectCheckBox == null) {
            this.notStopOnRejectCheckBox = new JCheckBox();
            this.notStopOnRejectCheckBox.setText("Don't Stop Simulation On AccessReject");
        }
        return this.notStopOnRejectCheckBox;
    }

    private JCheckBox getSendClassAttributeCheckBox() {
        if (this.notSendClassAttribute == null) {
            this.notSendClassAttribute = new JCheckBox();
            this.notSendClassAttribute.setText("Don't Send The Received Class Attribute");
        }
        return this.notSendClassAttribute;
    }

    public NumberFormatter getNumberFormatter() {
        if (this.numberFormatter == null) {
            this.numberFormatter = new NumberFormatter(NumberFormat.getIntegerInstance());
            this.numberFormatter.setValueClass(class$java$lang$Integer == null ? (class$java$lang$Integer = JRadiusSimulator.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        return this.numberFormatter;
    }

    private JFormattedTextField getRadiusAuthPortTextField() {
        if (this.radiusAuthPortTextField == null) {
            this.radiusAuthPortTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusAuthPortTextField.setValue(new Integer(1812));
        }
        return this.radiusAuthPortTextField;
    }

    private JFormattedTextField getRadiusAcctPortTextField() {
        if (this.radiusAcctPortTextField == null) {
            this.radiusAcctPortTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusAcctPortTextField.setValue(new Integer(1813));
        }
        return this.radiusAcctPortTextField;
    }

    private JFormattedTextField getRadiusRetriesTextField() {
        if (this.radiusRetriesTextField == null) {
            this.radiusRetriesTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusRetriesTextField.setValue(new Integer(0));
        }
        return this.radiusRetriesTextField;
    }

    private JFormattedTextField getRadiusTimeoutTextField() {
        if (this.radiusTimeoutTextField == null) {
            this.radiusTimeoutTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusTimeoutTextField.setValue(new Integer(10));
        }
        return this.radiusTimeoutTextField;
    }

    private JFormattedTextField getRadiusInterimIntervalTextField() {
        if (this.radiusInterimIntervalTextField == null) {
            this.radiusInterimIntervalTextField = new JFormattedTextField(this.getNumberFormatter());
            this.radiusInterimIntervalTextField.setValue(new Integer(60));
        }
        return this.radiusInterimIntervalTextField;
    }

    private JFormattedTextField getSessionTimeTextField() {
        if (this.sessionTimeTextField == null) {
            this.sessionTimeTextField = new JFormattedTextField(this.getNumberFormatter());
            this.sessionTimeTextField.setValue(new Integer(60));
        }
        return this.sessionTimeTextField;
    }

    private void checkStandard(RadiusStandard radiusStandard, RadiusPacket p) {
        if (radiusStandard != null) {
            try {
                radiusStandard.checkPacket(p);
            }
            catch (StandardViolatedException e) {
                this.statusLabel.setText(radiusStandard.getName() + " standard violated");
                this.logErr.println(radiusStandard.getName() + " Standard Violated: " + p.getClass().getName());
                this.logErr.println(logSepLine);
                this.logErr.println("Missing attributes:");
                this.logErr.println(e.listAttributes("\n") + "\n");
                this.logErr.flush();
            }
        }
    }

    private RadiusStandard getRadiusStandard() {
        switch (this.checkStandardComboBox.getSelectedIndex()) {
            case 1: {
                return new IRAPStandard();
            }
            case 2: {
                return new WISPrStandard();
            }
        }
        return null;
    }

    public void run() {
        String radiusServer = this.radiusServerTextField.getText();
        String sharedSecret = this.sharedSecretTextField.getText();
        Integer authPort = (Integer)this.radiusAuthPortTextField.getValue();
        Integer acctPort = (Integer)this.radiusAcctPortTextField.getValue();
        Integer timeout = (Integer)this.radiusTimeoutTextField.getValue();
        Integer retries = (Integer)this.radiusRetriesTextField.getValue();
        byte[] bClass = null;
        if (radiusServer == null || sharedSecret == null || "".equals(radiusServer) || "".equals(sharedSecret)) {
            this.statusLabel.setText("The RADIUS Server and Shared Secret are required");
            return;
        }
        if (authPort == null || acctPort == null) {
            this.statusLabel.setText("The Auth Port and Acct Port must be set");
            return;
        }
        boolean[] sendPackets = new boolean[]{true, false, false, false};
        boolean simulationSuccess = true;
        this.interactiveSession = false;
        switch (this.simulationTypeComboBox.getSelectedIndex()) {
            case 1: {
                sendPackets[3] = true;
                sendPackets[2] = true;
                sendPackets[1] = true;
                break;
            }
            case 2: {
                sendPackets[3] = true;
                sendPackets[1] = true;
                break;
            }
            case 3: {
                sendPackets[1] = true;
                this.interactiveSession = true;
            }
        }
        Attr_AcctSessionId generatedAcctSessionId = null;
        if (this.generateAcctSessionIdCheckBox.isSelected()) {
            generatedAcctSessionId = new Attr_AcctSessionId("JRadius-" + RadiusRandom.getRandomString(16));
        }
        try {
            AttributeList[] authAttributes = new AttributeList[]{new AttributeList(), new AttributeList()};
            AttributeList[] acctAttributes = new AttributeList[]{new AttributeList(), new AttributeList(), new AttributeList()};
            Object[] entries = this.attributesTableModel.getEntries().toArray();
            for (int i = 0; i < entries.length; ++i) {
                AttributesTableEntry entry = (AttributesTableEntry)entries[i];
                RadiusAttribute attribute = AttributeFactory.newAttribute(entry.getAttributeName(), entry.getAttributeValue(), "=");
                Boolean bool = entry.getAccessRequest();
                if (bool != null && bool.booleanValue()) {
                    authAttributes[0].add(attribute);
                }
                if ((bool = entry.getTunnelRequest()) != null && bool.booleanValue()) {
                    authAttributes[1].add(attribute);
                }
                if ((bool = entry.getAccountingStart()) != null && bool.booleanValue()) {
                    acctAttributes[0].add(attribute);
                }
                if ((bool = entry.getAccountingUpdate()) != null && bool.booleanValue()) {
                    acctAttributes[1].add(attribute);
                }
                if ((bool = entry.getAccountingStop()) == null || !bool.booleanValue()) continue;
                acctAttributes[2].add(attribute);
            }
            RadiusClient radiusClient = new RadiusClient(InetAddress.getByName(radiusServer), sharedSecret, authPort, acctPort, timeout){

                protected RadiusResponse receive() throws IOException, RadiusException {
                    JRadiusSimulator.this.statusLabel.setText("Waiting for response...");
                    RadiusResponse res = super.receive();
                    JRadiusSimulator.this.statusLabel.setText("Received RADIUS Packet " + res.getClass().getName());
                    JRadiusSimulator.this.logRecv.println("Received RADIUS Packet:");
                    JRadiusSimulator.this.logRecv.println(JRadiusSimulator.logSepLine);
                    JRadiusSimulator.this.logRecv.println(res.toString());
                    JRadiusSimulator.this.logRecv.flush();
                    JRadiusSimulator.this.checkStandard(JRadiusSimulator.this.getRadiusStandard(), res);
                    return res;
                }

                protected void send(RadiusPacket p, InetAddress a, int port, int attempt) throws IOException {
                    JRadiusSimulator.this.logSent.println("Sending RADIUS Packet:");
                    JRadiusSimulator.this.logSent.println(JRadiusSimulator.logSepLine);
                    JRadiusSimulator.this.logSent.println(p.toString());
                    JRadiusSimulator.this.logSent.flush();
                    JRadiusSimulator.this.checkStandard(JRadiusSimulator.this.getRadiusStandard(), p);
                    JRadiusSimulator.this.statusLabel.setText("Sending RADIUS Packet " + p.getClass().getName());
                    super.send(p, a, port, attempt);
                }
            };
            for (int i = 0; i < sendPackets.length; ++i) {
                RadiusResponse reply;
                RadiusRequest request;
                if (!sendPackets[i]) continue;
                if (i == 0) {
                    request = new AccessRequest(radiusClient, authAttributes[0]);
                } else {
                    request = new AccountingRequest(radiusClient, acctAttributes[i - 1]);
                    if (request.findAttribute(40) == null) {
                        switch (i) {
                            case 1: {
                                request.addAttribute((RadiusAttribute)new Attr_AcctStatusType("Start"));
                                break;
                            }
                            case 2: {
                                request.addAttribute((RadiusAttribute)new Attr_AcctStatusType("Interim-Update"));
                                break;
                            }
                            case 3: {
                                request.addAttribute((RadiusAttribute)new Attr_AcctStatusType("Stop"));
                            }
                        }
                    }
                }
                if (bClass != null) {
                    request.addAttribute((RadiusAttribute)new Attr_Class(bClass));
                }
                if (generatedAcctSessionId != null && request.findAttribute(44) != null) {
                    request.overwriteAttribute((RadiusAttribute)generatedAcctSessionId);
                }
                if (i == 0) {
                    RadiusAuthenticator auth = this.getAuthenticator();
                    if (auth instanceof TunnelAuthenticator) {
                        ((TunnelAuthenticator)((Object)auth)).setTunneledAttributes(authAttributes[1]);
                    }
                    reply = radiusClient.authenticate((AccessRequest)request, auth, retries);
                    if (!this.notStopOnRejectCheckBox.isSelected() && reply instanceof AccessReject) {
                        String replyMessage = (String)reply.getAttributeValue(18);
                        if (replyMessage == null) {
                            replyMessage = "reason unknown";
                        }
                        this.statusLabel.setText("Access Rejected: " + replyMessage);
                        simulationSuccess = false;
                        break;
                    }
                    if (this.notSendClassAttribute.isSelected()) continue;
                    bClass = (byte[])reply.getAttributeValue(25);
                    continue;
                }
                reply = radiusClient.accounting((AccountingRequest)request, retries);
            }
            if (simulationSuccess) {
                this.statusLabel.setText("Simulation complete");
            }
        }
        catch (Exception e) {
            this.statusLabel.setText("Problem: " + e.getMessage());
            e.printStackTrace();
        }
        this.runButton.setSelected(false);
        this.runButton.setText("Start");
    }

    private JDialog getOpenUrlDialog() {
        if (this.openUrlDialog == null) {
            this.openUrlDialog = new JDialog();
            this.openUrlDialog.setContentPane(this.getOpenUrlContentPane());
            this.openUrlDialog.setSize(425, 125);
        }
        this.openUrlStatusLabel.setText("Enter the URL of the configuration file:");
        this.openUrlTextField.setText("http://");
        return this.openUrlDialog;
    }

    private JPanel getOpenUrlContentPane() {
        if (this.openUrlContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(25, 25, 10, 25);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 25, 0, 5);
            gridBagConstraints1.anchor = 13;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 25);
            gridBagConstraints2.weightx = 1.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.insets = new Insets(0, 25, 25, 25);
            this.openUrlLabel = new JLabel();
            this.openUrlLabel.setText("URL:");
            this.openUrlStatusLabel = new JLabel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.openUrlContentPane = new JPanel();
            this.openUrlContentPane.setLayout(gridBagLayout);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add((Component)this.getOpenUrlButton(), null);
            buttonPanel.add((Component)this.getCancelUrlButton(), null);
            this.openUrlContentPane.add((Component)this.openUrlStatusLabel, gridBagConstraints);
            this.openUrlContentPane.add((Component)this.openUrlLabel, gridBagConstraints1);
            this.openUrlContentPane.add((Component)this.getOpenUrlTextField(), gridBagConstraints2);
            this.openUrlContentPane.add((Component)buttonPanel, gridBagConstraints3);
        }
        return this.openUrlContentPane;
    }

    private JTextField getOpenUrlTextField() {
        if (this.openUrlTextField == null) {
            this.openUrlTextField = new JTextField();
        }
        return this.openUrlTextField;
    }

    private JButton getOpenUrlButton() {
        if (this.openUrlButton == null) {
            this.openUrlButton = new JButton();
            this.openUrlButton.setText("Open");
            this.openUrlButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JRadiusSimulator.this.loadConfigFile(JRadiusSimulator.this.openUrlTextField.getText());
                    }
                    catch (FileNotFoundException ex) {
                        JRadiusSimulator.this.openUrlStatusLabel.setText("Not found: " + ex.getMessage());
                        return;
                    }
                    catch (ConnectException ex) {
                        JRadiusSimulator.this.openUrlStatusLabel.setText("Open Failed: " + ex.getMessage());
                        return;
                    }
                    catch (Exception ex) {
                        JRadiusSimulator.this.openUrlStatusLabel.setText(ex.getMessage());
                        ex.printStackTrace();
                        return;
                    }
                    JRadiusSimulator.this.openUrlDialog.dispose();
                }
            });
        }
        return this.openUrlButton;
    }

    private JButton getCancelUrlButton() {
        if (this.cancelUrlButton == null) {
            this.cancelUrlButton = new JButton();
            this.cancelUrlButton.setText("Cancel");
            this.cancelUrlButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JRadiusSimulator.this.openUrlDialog.dispose();
                }
            });
        }
        return this.cancelUrlButton;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String url = args[0];
            File file = new File(url);
            if (file.exists()) {
                url = "file://" + file.getAbsolutePath();
            }
            JRadiusSimulator.setConfigFileUrl(url);
        }
        JRadiusSimulator application = new JRadiusSimulator();
        application.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ValueTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 0L;
        private JComponent component;

        private ValueTableCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
            AttributesTableEntry entry;
            if (isSelected) {
                // empty if block
            }
            if ((entry = (AttributesTableEntry)JRadiusSimulator.this.attributesTableModel.getEntries().get(rowIndex)).getValueClass().equals(class$net$sf$jradius$packet$attribute$value$NamedValue == null ? (class$net$sf$jradius$packet$attribute$value$NamedValue = JRadiusSimulator.class$("net.sf.jradius.packet.attribute.value.NamedValue")) : class$net$sf$jradius$packet$attribute$value$NamedValue)) {
                this.component = JRadiusSimulator.this.createNamedValueCellEditor(entry.getAttributeName());
                ((JComboBox)this.component).setSelectedItem(value);
            } else if (entry.getValueClass().equals(class$net$sf$jradius$packet$attribute$value$IntegerValue == null ? (class$net$sf$jradius$packet$attribute$value$IntegerValue = JRadiusSimulator.class$("net.sf.jradius.packet.attribute.value.IntegerValue")) : class$net$sf$jradius$packet$attribute$value$IntegerValue)) {
                JFormattedTextField ftf = new JFormattedTextField(JRadiusSimulator.this.getNumberFormatter());
                Integer iValue = null;
                try {
                    iValue = new Integer((String)value);
                }
                catch (Exception e) {
                    iValue = new Integer(0);
                }
                ftf.setValue(iValue);
                this.component = ftf;
            } else {
                this.component = new JTextField();
                ((JTextField)this.component).setText((String)value);
            }
            this.component.setBorder(null);
            return this.component;
        }

        public Object getCellEditorValue() {
            if (this.component instanceof JComboBox) {
                return ((JComboBox)this.component).getSelectedItem();
            }
            if (this.component instanceof JFormattedTextField) {
                return ((Integer)((JFormattedTextField)this.component).getValue()).toString();
            }
            return ((JTextField)this.component).getText();
        }

        public boolean stopCellEditing() {
            if (this.component instanceof JFormattedTextField) {
                JFormattedTextField ftf = (JFormattedTextField)this.component;
                if (ftf.isEditValid()) {
                    try {
                        ftf.commitEdit();
                    }
                    catch (ParseException parseException) {}
                } else {
                    return false;
                }
            }
            return super.stopCellEditing();
        }
    }
}

