/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client.auth;

import net.sf.jradius.client.RadiusClient;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.RadiusAttribute;

public abstract class RadiusAuthenticator {
    protected RadiusClient client;
    protected RadiusAttribute username;
    protected RadiusAttribute password;

    public abstract String getAuthName();

    public void setupRequest(RadiusClient c, RadiusPacket p) throws RadiusException {
        this.client = c;
        this.username = p.findAttribute(1);
        if (this.username == null) {
            throw new RadiusException("You must at least have a User-Name attribute in a Access-Request");
        }
        this.password = p.findAttribute(2);
    }

    public abstract void processRequest(RadiusPacket var1) throws RadiusException;

    public void processChallenge(RadiusPacket request, RadiusPacket challenge) throws RadiusException {
        throw new RadiusException("A RequestChallenge was returned for a " + this.getAuthName() + " authentication!\n" + request.toString() + "\n" + challenge.toString());
    }

    public RadiusClient getClient() {
        return this.client;
    }

    public void setClient(RadiusClient client) {
        this.client = client;
    }

    protected byte[] getUsername() {
        return this.username.getValue().getBytes();
    }

    protected byte[] getPassword() {
        if (this.password != null) {
            return this.password.getValue().getBytes();
        }
        return null;
    }
}

