/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client.auth;

import net.sf.jradius.client.auth.RadiusAuthenticator;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.util.MSCHAP;
import net.sf.jradius.util.RadiusRandom;

public class MSCHAPv2Authenticator
extends RadiusAuthenticator {
    public static final String NAME = "mschapv2";

    public String getAuthName() {
        return NAME;
    }

    public void processRequest(RadiusPacket p) throws RadiusException {
        p.removeAttribute(this.password);
        byte[] authChallenge = RadiusRandom.getBytes(16);
        byte[] chapResponse = MSCHAP.doMSCHAPv2(this.username.getValue().getBytes(), this.password.getValue().getBytes(), authChallenge);
        RadiusAttribute attr = AttributeFactory.newAttribute("MS-CHAP-Challenge");
        p.addAttribute(attr);
        attr.setValue(authChallenge);
        attr = AttributeFactory.newAttribute("MS-CHAP2-Response");
        p.addAttribute(attr);
        attr.setValue(chapResponse);
    }
}

