/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client.auth;

import net.sf.jradius.client.auth.RadiusAuthenticator;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.util.CHAP;
import net.sf.jradius.util.RadiusRandom;

public class CHAPAuthenticator
extends RadiusAuthenticator {
    public static final String NAME = "chap";

    public String getAuthName() {
        return NAME;
    }

    public void processRequest(RadiusPacket p) throws RadiusException {
        p.removeAttribute(this.password);
        byte[] authChallenge = RadiusRandom.getBytes(16);
        byte[] chapResponse = CHAP.chapResponse(p.getIdentifier(), this.password.getValue().getBytes(), authChallenge);
        RadiusAttribute attr = AttributeFactory.newAttribute("CHAP-Challenge");
        p.addAttribute(attr);
        attr.setValue(authChallenge);
        attr = AttributeFactory.newAttribute("CHAP-Password");
        p.addAttribute(attr);
        attr.setValue(chapResponse);
    }
}

