/*
 * Decompiled with CFR 0.152.
 */
package org.dotuseful.ui.tree;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.MutableTreeNode;
import org.dotuseful.ui.tree.AutomatedTreeNode;

public class SortedTreeNode
extends AutomatedTreeNode {
    protected Comparator comparator;

    public SortedTreeNode() {
        this(null);
    }

    public SortedTreeNode(Object object) {
        this(object, null);
    }

    public SortedTreeNode(Object object, boolean bl) {
        this(object, bl, null);
    }

    public SortedTreeNode(Object object, Comparator comparator) {
        this(object, true, comparator);
    }

    public SortedTreeNode(Object object, boolean bl, Comparator comparator) {
        super(object, bl);
        this.comparator = comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.sortChildren(this.children.toArray());
    }

    public void add(MutableTreeNode mutableTreeNode) {
        int n;
        if (mutableTreeNode != null && mutableTreeNode.getParent() == this) {
            this.remove(mutableTreeNode);
        }
        if ((n = this.children == null ? 0 : Collections.binarySearch(this.children, mutableTreeNode, this.comparator)) < 0) {
            n = -n - 1;
        }
        this.insert(mutableTreeNode, n);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        super.treeNodesChanged(treeModelEvent);
        if (treeModelEvent.getTreePath().getLastPathComponent() == this) {
            this.sortChildren(treeModelEvent.getChildren());
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        super.treeStructureChanged(treeModelEvent);
        if (treeModelEvent.getTreePath().getLastPathComponent() == this) {
            this.sortChildren(this.children.toArray());
        }
    }

    protected void sortChildren(Object[] objectArray) {
        int n = objectArray.length;
        if (n > 0) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.remove((MutableTreeNode)objectArray[n2]);
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.add((MutableTreeNode)objectArray[n2]);
            }
        }
    }
}

