/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.RolloverButtonListener;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;
import org.pushingpixels.trident.api.swing.SwingRepaintCallback;

public class ButtonVisualStateTracker {
    private RolloverButtonListener substanceButtonListener;
    private PropertyChangeListener substancePropertyListener;
    private StateTransitionTracker stateTransitionTracker;

    public void installListeners(AbstractButton b, boolean toInstallRolloverListener) {
        this.stateTransitionTracker = new StateTransitionTracker(b, b.getModel());
        if (b instanceof SubstanceScrollButton) {
            this.stateTransitionTracker.setRepaintCallback(() -> {
                JScrollBar scrollBar = (JScrollBar)SwingUtilities.getAncestorOfClass(JScrollBar.class, b);
                return new SwingRepaintCallback((Component)Objects.requireNonNullElse(scrollBar, b));
            });
        }
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        if (toInstallRolloverListener) {
            this.substanceButtonListener = new RolloverButtonListener(b, this.stateTransitionTracker);
            b.addMouseListener(this.substanceButtonListener);
            b.addMouseMotionListener(this.substanceButtonListener);
            b.addFocusListener(this.substanceButtonListener);
            b.addPropertyChangeListener(this.substanceButtonListener);
            b.addChangeListener(this.substanceButtonListener);
        }
        this.substancePropertyListener = evt -> {
            if ("model".equals(evt.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)evt.getNewValue());
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    public void uninstallListeners(AbstractButton b) {
        if (this.substanceButtonListener != null) {
            b.removeMouseListener(this.substanceButtonListener);
            b.removeMouseMotionListener(this.substanceButtonListener);
            b.removeFocusListener(this.substanceButtonListener);
            b.removePropertyChangeListener(this.substanceButtonListener);
            b.removeChangeListener(this.substanceButtonListener);
            this.substanceButtonListener = null;
        }
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    public StateTransitionTracker getStateTransitionTracker() {
        return this.stateTransitionTracker;
    }
}

