/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.shaper.StandardButtonShaper;

public class MistSilverSkin
extends SubstanceSkin {
    public static final String NAME = "Mist Silver";

    public MistSilverSkin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/substance/api/skin/mist.colorschemes"));
        SubstanceColorScheme activeScheme = colorSchemes.get("Mist Silver Active");
        SubstanceColorScheme enabledScheme = colorSchemes.get("Mist Enabled");
        SubstanceColorScheme disabledScheme = colorSchemes.get("Mist Disabled");
        SubstanceColorScheme lightBlueScheme = colorSchemes.get("Mist Silver Light Blue");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        defaultSchemeBundle.registerColorScheme(enabledScheme.tone(0.4), SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerColorScheme(lightBlueScheme, ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(enabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(enabledScheme.shade(0.1), SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, SubstanceSlices.DecorationAreaType.NONE);
        this.registerDecorationAreaSchemeBundle(new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme), lightBlueScheme, SubstanceSlices.DecorationAreaType.GENERAL);
        this.registerAsDecorationArea(enabledScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER, SubstanceSlices.DecorationAreaType.FOOTER, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.buttonShaper = new StandardButtonShaper();
        this.fillPainter = new MatteFillPainter();
        this.borderPainter = new ClassicBorderPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

