/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.skin.DustSkin;

public class DustCoffeeSkin
extends DustSkin {
    public static final String NAME = "Dust Coffee";

    public DustCoffeeSkin() {
        SubstanceSkin.ColorSchemes kitchenSinkSchemes = SubstanceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/substance/api/skin/kitchen-sink.colorschemes"));
        SubstanceColorScheme activeScheme = kitchenSinkSchemes.get("Coffee Active");
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/substance/api/skin/dust.colorschemes"));
        SubstanceColorScheme enabledScheme = schemes.get("Dust Coffee Enabled");
        SubstanceColorScheme backgroundScheme = schemes.get("Dust Coffee Background");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, enabledScheme);
        defaultSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(enabledScheme, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme borderEnabledScheme = schemes.get("Dust Border Enabled");
        defaultSchemeBundle.registerColorScheme(borderEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(borderEnabledScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        SubstanceColorScheme textHighlightScheme = schemes.get("Dust Coffee Text Highlight");
        defaultSchemeBundle.registerColorScheme(textHighlightScheme, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerHighlightAlpha(0.6f, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED);
        defaultSchemeBundle.registerHighlightAlpha(0.8f, ComponentState.SELECTED);
        defaultSchemeBundle.registerHighlightAlpha(1.0f, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_ARMED);
        defaultSchemeBundle.registerHighlightColorScheme(activeScheme, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_ARMED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, backgroundScheme, SubstanceSlices.DecorationAreaType.NONE);
        this.fillPainter = new MatteFillPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

