/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class FdfReader
extends PdfReader {
    HashMap fields;
    String fileSpec;

    public FdfReader(String string) throws IOException {
        super(string);
    }

    public FdfReader(byte[] byArray) throws IOException {
        super(byArray);
    }

    public FdfReader(URL uRL) throws IOException {
        super(uRL);
    }

    protected void readPdf() throws IOException {
        this.fields = new HashMap();
        try {
            this.tokens.checkFdfHeader();
            this.rebuildXref();
            this.readDocObj();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.tokens.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception exception) {}
        this.readFields();
    }

    protected void kidNode(PdfDictionary pdfDictionary, String string) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null || pdfArray.getArrayList().size() == 0) {
            if (string.length() > 0) {
                string = string.substring(1);
            }
            this.fields.put(string, pdfDictionary);
        } else {
            pdfDictionary.remove(PdfName.KIDS);
            ArrayList arrayList = pdfArray.getArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                PdfDictionary pdfDictionary2 = new PdfDictionary();
                pdfDictionary2.merge(pdfDictionary);
                PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.T));
                String string2 = string;
                if (pdfString != null) {
                    string2 = string2 + "." + pdfString.toUnicodeString();
                }
                pdfDictionary2.merge(pdfDictionary3);
                pdfDictionary2.remove(PdfName.T);
                this.kidNode(pdfDictionary2, string2);
                ++n;
            }
        }
    }

    protected void readFields() throws IOException {
        PdfArray pdfArray;
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.FDF));
        PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
        if (pdfString != null) {
            this.fileSpec = pdfString.toUnicodeString();
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIELDS))) == null) {
            return;
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.KIDS, pdfArray);
        this.kidNode(pdfDictionary2, "");
    }

    public HashMap getFields() {
        return this.fields;
    }

    public PdfDictionary getField(String string) {
        return (PdfDictionary)this.fields.get(string);
    }

    public String getFieldValue(String string) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.fields.get(string);
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject.type() == 4) {
            return PdfName.decodeName(((PdfName)pdfObject).toString());
        }
        if (pdfObject.type() == 3) {
            return ((PdfString)pdfObject).toUnicodeString();
        }
        return null;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }
}

