/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.web;

import com.sysuptime.common.discovery.InsertDeviceOption;
import com.sysuptime.common.discovery.InsertOption;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.graph.CustomerGraphModel;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.LineLayoutAlgorithm;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.SubnetGraphModel;
import com.sysuptime.common.graph.TopologyGraphModel;
import com.sysuptime.common.graph.ViewGraphModel;
import com.sysuptime.common.model.ClassMap;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.IconFactory;
import com.sysuptime.common.model.Layer2Connection;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.callback.CallbackServer;
import com.sysuptime.common.util.net.NetworkUtils;
import com.sysuptime.server.discovery.DiscoveryUtil;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.discovery.InsertNodeResult;
import com.sysuptime.server.discovery.ViewXMLCreator;
import com.sysuptime.server.msp.Command;
import com.sysuptime.server.util.MBeanManager;
import com.sysuptime.server.util.MBeanUtil;
import com.sysuptime.server.web.InsertLinkOption;
import com.sysuptime.server.web.SaveViewOption;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.GraphConstants;

public class WebImpl
implements Serializable {
    private static final Logger _logger = Logger.getLogger((String)WebImpl.class.getName());
    public static final WebImpl INSTANCE = new WebImpl();
    private static String[] a;

    private WebImpl() {
    }

    public InsertNodeResult insertNode(String string, InsertOption insertOption) {
        InsertNodeResult insertNodeResult = null;
        TopologyData topologyData = GraphDao.createData();
        String[] stringArray = WebImpl.b();
        if ("insertDevice".equals(string)) {
            insertNodeResult = this.b(topologyData, (InsertDeviceOption)insertOption);
        } else if ("insertExist".equals(string)) {
            insertNodeResult = this.a(topologyData, (InsertDeviceOption)insertOption);
        } else if ("insertUnreachableDevice".equals(string)) {
            insertNodeResult = this.c(topologyData, (InsertDeviceOption)insertOption);
        } else if ("insertSubnet".equals(string)) {
            insertNodeResult = this.a(topologyData, insertOption);
        }
        if (insertNodeResult != null && insertNodeResult.isOk()) {
            CallbackServer.getInstance().notifyAllClients(null, "GraphLoaderProxy", "updateGraphs", null, null);
        }
        if (Command.b() != null) {
            WebImpl.b(new String[4]);
        }
        return insertNodeResult;
    }

    private InsertNodeResult a(TopologyData topologyData, InsertDeviceOption insertDeviceOption) {
        InsertNodeResult insertNodeResult = new InsertNodeResult();
        NetworkGraphModel networkGraphModel = this.a(topologyData, insertDeviceOption.getGraphID());
        String string = insertDeviceOption.getNodeID();
        NetworkNodeBean networkNodeBean = topologyData.getBean(string);
        if (networkNodeBean != null) {
            if (networkGraphModel instanceof SubnetGraphModel && networkNodeBean.getIPInSubnet(networkGraphModel.getID().getGraphName()) == null) {
                insertNodeResult.setResult("<msg status=\"not in this subnet\"/>");
                return insertNodeResult;
            }
            NetworkNode networkNode = new NetworkNode(networkNodeBean);
            AttributeMap attributeMap = networkNode.getAttributes();
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
            rectangle2D = attributeMap.createRect(insertDeviceOption.getX(), insertDeviceOption.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
            networkNode.setAttributes(attributeMap);
            networkNodeBean.addTopoGraph(networkGraphModel.getID());
            if (networkGraphModel instanceof SubnetGraphModel) {
                Path path = ((SubnetGraphModel)networkGraphModel).getPath();
                NetworkNodeBean networkNodeBean2 = topologyData.getBean(path);
                ((Subnet)networkNodeBean2).addSubId(string);
            }
            networkGraphModel.insert(new Object[]{networkNode}, null, null, null, null);
            LineLayoutAlgorithm.lineLayout(networkGraphModel);
            this.a(topologyData, networkGraphModel, insertDeviceOption.getGraphID().getCustomerID());
            insertNodeResult.setOk(true);
            return insertNodeResult;
        }
        insertNodeResult.setResult("failed");
        return insertNodeResult;
    }

    private InsertNodeResult b(TopologyData topologyData, InsertDeviceOption insertDeviceOption) {
        ReadCommunity readCommunity;
        String string;
        NetworkGraphModel networkGraphModel;
        InsertNodeResult insertNodeResult;
        block12: {
            insertNodeResult = new InsertNodeResult();
            networkGraphModel = this.a(topologyData, insertDeviceOption.getGraphID());
            string = insertDeviceOption.getName();
            readCommunity = insertDeviceOption.getReadCommunity();
            readCommunity = ReadCommunity.fromView(readCommunity);
            try {
                if (string.length() != 0 || StringUtil.isIp(readCommunity.getIpAddress())) break block12;
            }
            catch (Exception exception) {
                throw WebImpl.a(exception);
            }
            string = readCommunity.getIpAddress();
        }
        String string2 = insertDeviceOption.getDeviceType();
        String string3 = insertDeviceOption.getIcon();
        if (NetworkUtils.isActiveIp(readCommunity.getIpAddress())) {
            ObjectName objectName = MBeanUtil.create("nMaster:service=Graph2Db");
            String[] stringArray = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), ReadCommunity.class.getName(), Boolean.TYPE.getName()};
            Object[] objectArray = new Object[]{readCommunity.getIpAddress(), string, string2, readCommunity, insertDeviceOption.isDetectOtherInterfaces()};
            try {
                NetworkNodeBean networkNodeBean;
                block15: {
                    block13: {
                        block14: {
                            networkNodeBean = (NetworkNodeBean)MBeanManager.getInstance().invoke(objectName, "createNodeInfoByIp", objectArray, stringArray);
                            networkNodeBean.setCustomerID(networkGraphModel.getID().getCustomerID());
                            NetworkNodeBean networkNodeBean2 = topologyData.getBean(networkNodeBean.getID());
                            try {
                                if (networkNodeBean2 == null) break block13;
                                if (networkGraphModel.getNodeByBean(networkNodeBean2) == null) break block14;
                            }
                            catch (Exception exception) {
                                throw WebImpl.a(exception);
                            }
                            insertNodeResult.setResult("<msg status=\"exist this\" id=\"" + networkNodeBean.getID() + "\"/>");
                            return insertNodeResult;
                        }
                        insertNodeResult.setResult("<msg status=\"exist other\" id=\"" + networkNodeBean.getID() + "\"/>");
                        return insertNodeResult;
                    }
                    try {
                        if (!(networkGraphModel instanceof SubnetGraphModel) || networkNodeBean.getIPInSubnet(networkGraphModel.getID().getGraphName()) != null) break block15;
                    }
                    catch (Exception exception) {
                        throw WebImpl.a(exception);
                    }
                    insertNodeResult.setResult("<msg status=\"not in this subnet\"/>");
                    return insertNodeResult;
                }
                networkNodeBean.setManuallyAdded(true);
                Path path = ((TopologyGraphModel)networkGraphModel).getPath();
                path.setLeafID(networkNodeBean.getPrivateID());
                topologyData.addNode(new DeviceNode((DeviceBean)networkNodeBean), path);
                NetworkNode networkNode = new NetworkNode(networkNodeBean);
                AttributeMap attributeMap = networkNode.getAttributes();
                Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
                rectangle2D = attributeMap.createRect(insertDeviceOption.getX(), insertDeviceOption.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
                ImageIcon imageIcon = IconFactory.getIcon(string2, this.a(string3));
                GraphConstants.setIcon((Map)attributeMap, (Icon)imageIcon);
                networkNode.setCurrentDefaultIcon(imageIcon);
                networkNode.setAttributes(attributeMap);
                networkNodeBean.addTopoGraph(networkGraphModel.getID());
                networkGraphModel.insert(new Object[]{networkNode}, null, null, null, null);
                LineLayoutAlgorithm.lineLayout(networkGraphModel);
                this.a(topologyData, networkGraphModel, insertDeviceOption.getGraphID().getCustomerID());
                insertNodeResult.setOk(true);
                return insertNodeResult;
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
                insertNodeResult.setResult("failed");
                return insertNodeResult;
            }
        }
        try {
            if (StringUtil.isIp(readCommunity.getIpAddress())) {
                insertNodeResult.setResult("unreachable");
                return insertNodeResult;
            }
        }
        catch (Exception exception) {
            throw WebImpl.a(exception);
        }
        insertNodeResult.setResult("unreachable with no ip");
        return insertNodeResult;
    }

    /*
     * Loose catch block
     */
    private InsertNodeResult c(TopologyData topologyData, InsertDeviceOption insertDeviceOption) {
        ReadCommunity readCommunity;
        String string;
        NetworkGraphModel networkGraphModel;
        InsertNodeResult insertNodeResult;
        block11: {
            block10: {
                insertNodeResult = new InsertNodeResult();
                networkGraphModel = this.a(topologyData, insertDeviceOption.getGraphID());
                string = insertDeviceOption.getName();
                readCommunity = insertDeviceOption.getReadCommunity();
                if (!(networkGraphModel instanceof SubnetGraphModel)) break block10;
                try {
                    block12: {
                        if (StringUtil.inSameSubnet(networkGraphModel.getID().getGraphName(), readCommunity.getIpAddress())) break block10;
                        break block12;
                        catch (IllegalAccessException illegalAccessException) {
                            throw WebImpl.a(illegalAccessException);
                        }
                    }
                    insertNodeResult.setResult("<msg status=\"not in this subnet\"/>");
                    return insertNodeResult;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw WebImpl.a(illegalAccessException);
                }
            }
            try {
                if (string.length() != 0 || StringUtil.isIp(readCommunity.getIpAddress())) break block11;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WebImpl.a(illegalAccessException);
            }
            string = readCommunity.getIpAddress();
        }
        String string2 = insertDeviceOption.getDeviceType();
        String string3 = insertDeviceOption.getIcon();
        try {
            Class clazz = ClassMap.getClass(string2);
            NetworkNodeBean networkNodeBean = (NetworkNodeBean)clazz.newInstance();
            networkNodeBean.setCustomerID(networkGraphModel.getID().getCustomerID());
            networkNodeBean.setManuallyAdded(true);
            networkNodeBean.setDisplayName(string);
            EthernetInterface ethernetInterface = new EthernetInterface(networkNodeBean, readCommunity.getIpAddress());
            networkNodeBean.setInterfaces(new NetworkInterface[]{ethernetInterface});
            Path path = ((TopologyGraphModel)networkGraphModel).getPath();
            Path path2 = new Path(path);
            path2.setLeafID(networkNodeBean.getPrivateID());
            topologyData.addNode(new DeviceNode((DeviceBean)networkNodeBean), path2);
            NetworkNode networkNode = new NetworkNode(networkNodeBean);
            AttributeMap attributeMap = networkNode.getAttributes();
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
            rectangle2D = attributeMap.createRect(insertDeviceOption.getX(), insertDeviceOption.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
            ImageIcon imageIcon = IconFactory.getIcon(string2, this.a(string3));
            GraphConstants.setIcon((Map)attributeMap, (Icon)imageIcon);
            networkNode.setCurrentDefaultIcon(imageIcon);
            networkNode.setAttributes(attributeMap);
            networkNodeBean.addTopoGraph(networkGraphModel.getID());
            if (networkGraphModel instanceof SubnetGraphModel) {
                NetworkNodeBean networkNodeBean2 = topologyData.getBean(path);
                ((Subnet)networkNodeBean2).addSubId(networkNodeBean.getID());
            }
            networkGraphModel.insert(new Object[]{networkNode}, null, null, null, null);
            LineLayoutAlgorithm.lineLayout(networkGraphModel);
            this.a(topologyData, networkGraphModel, insertDeviceOption.getGraphID().getCustomerID());
            insertNodeResult.setOk(true);
            return insertNodeResult;
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.error((Object)"", (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            _logger.error((Object)"", (Throwable)instantiationException);
        }
        insertNodeResult.setResult("failed");
        return insertNodeResult;
    }

    private InsertNodeResult a(TopologyData topologyData, InsertOption insertOption) {
        InsertNodeResult insertNodeResult = new InsertNodeResult();
        NetworkGraphModel networkGraphModel = this.a(topologyData, insertOption.getGraphID());
        if (!StringUtil.isIp(insertOption.getIp()) || !insertOption.getIp().endsWith(".0")) {
            insertNodeResult.setResult("invalid subnet ip");
            return insertNodeResult;
        }
        String string = insertOption.getName();
        String string2 = insertOption.getIcon();
        Subnet subnet = new Subnet(insertOption.getIp());
        subnet.setCustomerID(networkGraphModel.getID().getCustomerID());
        subnet.setDisplayName(string);
        NetworkNodeBean networkNodeBean = networkGraphModel.getBean(subnet.getID());
        if (networkNodeBean != null) {
            insertNodeResult.setResult("<msg status=\"exist this\" id=\"" + subnet.getID() + "\"/>");
            return insertNodeResult;
        }
        subnet.setManuallyAdded(true);
        Path path = ((TopologyGraphModel)networkGraphModel).getPath();
        path.setLeafID(subnet.getPrivateID());
        topologyData.addNode(new SubnetNode(subnet), path);
        NetworkNode networkNode = new NetworkNode(subnet);
        AttributeMap attributeMap = networkNode.getAttributes();
        Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
        rectangle2D = attributeMap.createRect(insertOption.getX(), insertOption.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
        ImageIcon imageIcon = IconFactory.getIcon("subnet", this.a(string2));
        GraphConstants.setIcon((Map)attributeMap, (Icon)imageIcon);
        networkNode.setCurrentDefaultIcon(imageIcon);
        networkNode.setAttributes(attributeMap);
        subnet.addTopoGraph(networkGraphModel.getID());
        networkGraphModel.insert(new Object[]{networkNode}, null, null, null, null);
        LineLayoutAlgorithm.lineLayout(networkGraphModel);
        this.a(topologyData, networkGraphModel, insertOption.getGraphID().getCustomerID());
        insertNodeResult.setOk(true);
        return insertNodeResult;
    }

    private NetworkGraphModel a(TopologyData topologyData, GraphID graphID) {
        NetworkGraphModel networkGraphModel;
        block2: {
            block3: {
                networkGraphModel = GraphDao.getModel(graphID);
                String[] stringArray = WebImpl.b();
                if (networkGraphModel != null) break block2;
                if (!"customer".equals(graphID.getGraphName())) break block3;
                networkGraphModel = new CustomerGraphModel(topologyData, graphID, null, null);
                networkGraphModel.setParentGraph(IGraphParameters.MASTER_MASTER);
                if (stringArray == null) break block2;
            }
            networkGraphModel = new SubnetGraphModel(topologyData, graphID, null, null);
            networkGraphModel.setParentGraph(new GraphID(graphID.getCustomerID(), "customer"));
        }
        return networkGraphModel;
    }

    private void a(TopologyData topologyData, NetworkGraphModel networkGraphModel, String string) {
        GraphDao.saveBeans(topologyData.getCustomer(string));
        GraphDao.saveGraph(networkGraphModel, networkGraphModel.getGraphType());
    }

    private String a(String string) {
        int n2 = string.lastIndexOf(47);
        return string.substring(n2 + 1);
    }

    public String saveView(SaveViewOption saveViewOption) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = saveViewOption.getData();
        try {
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            NetworkGraphModel networkGraphModel = null;
            TopologyData topologyData = GraphDao.createData();
            ViewXMLCreator viewXMLCreator = new ViewXMLCreator(topologyData);
            if ("saveView".equals(saveViewOption.getAction())) {
                String string2 = element.attributeValue("customer");
                String string3 = element.attributeValue("name");
                networkGraphModel = this.b(topologyData, new GraphID(string2, string3));
                viewXMLCreator.modifyView(topologyData, networkGraphModel, element);
            } else if ("saveNode".equals(saveViewOption.getAction())) {
                networkGraphModel = this.b(topologyData, saveViewOption.getGraphID());
                viewXMLCreator.modifyProperties(topologyData, networkGraphModel, element);
            }
            try {
                GraphDao.saveData(topologyData);
                if (networkGraphModel != null) {
                    GraphDao.saveGraph(networkGraphModel, networkGraphModel.getGraphType());
                }
            }
            catch (DocumentException documentException) {
                throw WebImpl.a((Exception)((Object)documentException));
            }
            CallbackServer.getInstance().notifyAllClients(null, "GraphLoaderProxy", "updateGraphs", null, null);
            stringBuffer.append("ok");
        }
        catch (DocumentException documentException) {
            _logger.error((Object)"", (Throwable)documentException);
            stringBuffer.append("failed");
        }
        return stringBuffer.toString();
    }

    private NetworkGraphModel b(TopologyData topologyData, GraphID graphID) {
        NetworkGraphModel networkGraphModel;
        block2: {
            block4: {
                String[] stringArray;
                block3: {
                    networkGraphModel = GraphDao.getModel(graphID);
                    stringArray = WebImpl.b();
                    if (networkGraphModel != null) break block2;
                    if (!"customer".equals(graphID.getGraphName())) break block3;
                    networkGraphModel = new CustomerGraphModel(topologyData, graphID, null, null);
                    if (stringArray == null) break block2;
                }
                if (!"view".equals(graphID.getCustomerID())) break block4;
                networkGraphModel = new ViewGraphModel(topologyData, graphID, null, null);
                if (stringArray == null) break block2;
            }
            networkGraphModel = new SubnetGraphModel(topologyData, graphID, null, null);
        }
        return networkGraphModel;
    }

    public String insertLink(InsertLinkOption insertLinkOption) {
        TopologyData topologyData = GraphDao.createData();
        NetworkGraphModel networkGraphModel = GraphDao.getModel(insertLinkOption.getGraphID());
        NetworkNodeBean networkNodeBean = topologyData.getBean(insertLinkOption.getSourceID());
        String[] stringArray = WebImpl.b();
        NetworkNodeBean networkNodeBean2 = topologyData.getBean(insertLinkOption.getTargetID());
        NetworkConnection networkConnection = DiscoveryUtil.createConnection(networkNodeBean, insertLinkOption.getSourceIP(), networkNodeBean2, insertLinkOption.getTargetIP());
        networkGraphModel.insertLink(networkConnection);
        GraphDao.saveGraph(networkGraphModel, networkGraphModel.getGraphType());
        if (stringArray != null) {
            Command.b(new int[1]);
        }
        return "<response action=\"insertLink\"/>";
    }

    public String insertLayer2Links(List<InsertLinkOption> list) {
        block4: {
            String[] stringArray = WebImpl.b();
            if (list != null && list.size() > 0) {
                TopologyData topologyData = GraphDao.createData();
                NetworkGraphModel networkGraphModel = GraphDao.getModel(list.get(0).getGraphID());
                for (InsertLinkOption insertLinkOption : list) {
                    NetworkNodeBean networkNodeBean = topologyData.getBean(insertLinkOption.getSourceID());
                    NetworkNodeBean networkNodeBean2 = topologyData.getBean(insertLinkOption.getTargetID());
                    if (stringArray == null) {
                        if (networkNodeBean != networkNodeBean2) {
                            Layer2Connection layer2Connection = new Layer2Connection(networkNodeBean, networkNodeBean2);
                            networkGraphModel.insertLink(layer2Connection);
                        }
                        if (stringArray == null) continue;
                    }
                    break block4;
                }
                GraphDao.saveGraph(networkGraphModel, networkGraphModel.getGraphType());
            }
        }
        return "<response action=\"insertLink\"/>";
    }

    static {
        WebImpl.b(null);
    }

    public static void b(String[] stringArray) {
        a = stringArray;
    }

    public static String[] b() {
        return a;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

