/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.util;

import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.LockResponse;
import com.sysuptime.common.util.ProcessOutputReader;
import com.sysuptime.common.util.RemoteTarget;
import com.sysuptime.common.util.callback.ICallbackClient;
import com.sysuptime.server.discovery.ActiveDeviceChecker;
import com.sysuptime.server.discovery.Discovery;
import com.sysuptime.server.discovery.DiscoveryStatus;
import com.sysuptime.server.util.BootFinder;
import com.sysuptime.server.util.CallbackOutputHandler;
import com.sysuptime.server.util.ErrorReporter;
import com.sysuptime.server.util.MBeanUtil;
import com.sysuptime.server.util.SystemStatusMBean;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class SystemStatus
implements SystemStatusMBean {
    private static final Logger _logger = Logger.getLogger((String)SystemStatus.class.getName());
    public static ICallbackClient VIRTUALCLIENT = null;
    private static ICallbackClient _currentClient;
    private static String _ipAddress;
    private static String _portNum;
    private static String _currentUserName;
    private static String _currentUserHostName;
    private static String _currentUserIP;
    private ActiveDeviceChecker _checker;

    public static boolean isDiscovering() {
        DiscoveryStatus discoveryStatus = Discovery.getInstance().getStatus();
        return discoveryStatus != null && !discoveryStatus.isEnd();
    }

    @Override
    public synchronized LockResponse lockEditMode(ICallbackClient iCallbackClient) {
        LockResponse lockResponse;
        block2: {
            block4: {
                ICallbackClient iCallbackClient2;
                block3: {
                    lockResponse = new LockResponse();
                    String string = MBeanUtil.b();
                    if (!SystemStatus.isDiscovering()) break block2;
                    iCallbackClient2 = Discovery.getInstance().getCallbackClient();
                    if (iCallbackClient2 != VIRTUALCLIENT) break block3;
                    lockResponse.setErrorCode(-3);
                    if (string != null) break block4;
                }
                lockResponse.setErrorCode(-1);
                this.a(iCallbackClient2, lockResponse);
            }
            return lockResponse;
        }
        _currentClient = iCallbackClient;
        this.a(iCallbackClient);
        lockResponse.setErrorCode(0);
        return lockResponse;
    }

    private void a(ICallbackClient iCallbackClient) {
        try {
            _currentUserName = iCallbackClient.getUserName();
            _currentUserHostName = iCallbackClient.getHostName();
            _currentUserIP = iCallbackClient.getHostIPAddress();
        }
        catch (Exception exception) {
            _logger.error((Object)"setUserInfo", (Throwable)exception);
        }
    }

    private void a(ICallbackClient iCallbackClient, LockResponse lockResponse) {
        try {
            lockResponse.setUserName(_currentUserName);
            lockResponse.setHostName(_currentUserHostName);
            lockResponse.setIpAddress(_currentUserIP);
        }
        catch (Exception exception) {
            _logger.error((Object)"getUserInfo", (Throwable)exception);
        }
    }

    @Override
    public String getIpAddress() {
        return _ipAddress;
    }

    @Override
    public String getPortNum() {
        return _portNum;
    }

    @Override
    public void setIpAddress(String string) {
        _ipAddress = string;
    }

    @Override
    public void setPortNum(String string) {
        _portNum = string;
    }

    @Override
    public String[] getServerIpAddresses() {
        String string = MBeanUtil.b();
        if (BootFinder.isSingleServer()) {
            return new String[]{BootFinder.getLocalBindAddress()};
        }
        List list = BootFinder.getCurrentNodes();
        int n2 = list.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = list.get(i2).toString();
            int n3 = string2.indexOf(58);
            if (n3 > 0) {
                string2 = string2.substring(0, n3);
            }
            stringArray[i2] = string2;
            if (string != null) continue;
        }
        return stringArray;
    }

    @Override
    public boolean isReachable(String string) {
        if (this._checker == null) {
            this._checker = new ActiveDeviceChecker();
        }
        this._checker.resetArpCache();
        return this._checker.isActive(string, 5000);
    }

    public static ICallbackClient getCurrentClient() {
        return _currentClient;
    }

    public boolean isWindows() {
        return AppUtil.isWindows();
    }

    public boolean isLinux() {
        return AppUtil.isLinux();
    }

    @Override
    public void ping(RemoteTarget remoteTarget) throws Exception {
        Process process = Runtime.getRuntime().exec(this.a(remoteTarget.getHost()));
        ProcessOutputReader processOutputReader = new ProcessOutputReader(process, new CallbackOutputHandler(remoteTarget.getClient()));
        processOutputReader.start();
    }

    @Override
    public void traceRoute(RemoteTarget remoteTarget) throws Exception {
        Process process = Runtime.getRuntime().exec(this.b(remoteTarget.getHost()));
        ProcessOutputReader processOutputReader = new ProcessOutputReader(process, new CallbackOutputHandler(remoteTarget.getClient()));
        processOutputReader.start();
    }

    private String a(String string) {
        if (AppUtil.isWindows()) {
            return "ping " + string;
        }
        return "ping -c 3 " + string;
    }

    private String b(String string) {
        if (AppUtil.isWindows()) {
            return "tracert  " + string;
        }
        return "traceroute " + string;
    }

    public static void setDiscoveryClientInfo(String string, String string2, String string3) {
        _currentUserName = string;
        _currentUserIP = string2;
        _currentUserHostName = string3;
    }

    public static String getDiscoveryUserName() {
        return _currentUserName;
    }

    public static String getDiscoveryUserIP() {
        return _currentUserIP;
    }

    public static String getDiscoveryHostName() {
        return _currentUserHostName;
    }

    @Override
    public void echo() {
    }

    @Override
    public boolean reportError(String string) {
        boolean bl2 = true;
        try {
            ErrorReporter.INSTANCE.reportError(string);
        }
        catch (IOException iOException) {
            _logger.error((Object)"", (Throwable)iOException);
            bl2 = false;
        }
        return bl2;
    }
}

