/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.util;

import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.License;
import com.sysuptime.common.util.LicenseUtil;
import com.sysuptime.common.util.StreamUtils;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.net.NetworkUtils;
import com.sysuptime.server.graphtodb.Graph2Db;
import com.sysuptime.server.msp.CmdStartOrStopTrapReceiver;
import com.sysuptime.server.performance.MonitorProcessor;
import com.sysuptime.server.util.JNbtstat;
import com.sysuptime.server.util.MBeanUtil;
import com.sysuptime.server.util.ServerConfig;
import com.sysuptime.server.util.ServerPropertiesFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.log4j.Logger;

public class LicenseServerProxy {
    private static final Logger _logger = Logger.getLogger((String)LicenseServerProxy.class.getName());
    private static String SEPARATOR = ",";
    public static final float VERSION = 7.0f;
    public static final int FREE_EDITION_NODES = 10;
    public static final int FREE_EDITION_MONITORS = 20;
    public static final int DEFAULT_PROBE_COUNT = 1;

    /*
     * Unable to fully structure code
     */
    public static synchronized boolean isValid(String var0, int var1_1) {
        var2_2 = MBeanUtil.b();
        try {
            block21: {
                block19: {
                    block20: {
                        try {
                            if (!LicenseServerProxy.isEval()) break block19;
                            if (!LicenseServerProxy.isExpired()) break block20;
                        }
                        catch (Exception v0) {
                            throw LicenseServerProxy.a(v0);
                        }
                        return false;
                    }
                    return true;
                }
                var3_3 = 0;
                if ("probeCount".equals(var0)) {
                    var3_3 = 1;
                }
                if (var0.equals("nodes")) {
                    return true;
                }
                var4_5 = ServerConfig.getLicenseProperty(var0);
                if (var4_5 != null) {
                    var3_3 = Integer.parseInt(var4_5);
                }
                try {
                    if (!LicenseServerProxy.isFreeEdition()) ** GOTO lbl38
                    if (var0.equals("monitors")) {
                    }
                    ** GOTO lbl31
                }
                catch (Exception v1) {
                    throw LicenseServerProxy.a(v1);
                }
                var3_3 = 20;
                try {
                    if (var2_2 != null) break block21;
lbl31:
                    // 2 sources

                    if (!var0.equals("users")) break block21;
                }
                catch (Exception v2) {
                    throw LicenseServerProxy.a(v2);
                }
                var3_3 = 1;
                try {
                    if (var2_2 != null) break block21;
lbl38:
                    // 2 sources

                    if (!var0.equals("users")) break block21;
                }
                catch (Exception v3) {
                    throw LicenseServerProxy.a(v3);
                }
                return true;
            }
            try {
                if (var1_1 > var3_3) {
                    LicenseServerProxy._logger.warn((Object)("License exceeded. item name:" + var0 + ". Current number:" + var1_1 + ", licensed number:" + var3_3));
                }
            }
            catch (Exception v4) {
                throw LicenseServerProxy.a(v4);
            }
            try {
                v5 = var1_1 <= var3_3;
            }
            catch (Exception v6) {
                throw LicenseServerProxy.a(v6);
            }
            return v5;
        }
        catch (Exception var3_4) {
            LicenseServerProxy._logger.error((Object)"isValid", (Throwable)var3_4);
            return false;
        }
    }

    public static boolean hasLicense() {
        return ServerConfig.getLicenseProperty("version") != null;
    }

    public static int hasValidLicense() {
        try {
            String string;
            block11: {
                block9: {
                    block10: {
                        string = ServerConfig.getLicenseProperty("version");
                        if (string == null) {
                            _logger.warn((Object)"Version info is missing.");
                            return -3;
                        }
                        try {
                            if (!LicenseServerProxy.isEval()) break block9;
                            if (!LicenseServerProxy.isExpired()) break block10;
                        }
                        catch (Exception exception) {
                            throw LicenseServerProxy.a(exception);
                        }
                        _logger.warn((Object)"License expired");
                        return -2;
                    }
                    return 0;
                }
                try {
                    if (!LicenseServerProxy.isEval() && !LicenseServerProxy.isFreeEdition()) break block11;
                }
                catch (Exception exception) {
                    throw LicenseServerProxy.a(exception);
                }
                return 0;
            }
            int n2 = (int)Float.parseFloat(string);
            if (n2 < 7) {
                _logger.warn((Object)"License version is too old");
                return -1;
            }
            if (LicenseServerProxy.matchServerName(NetworkUtils.getLocalHostName())) {
                return 0;
            }
            _logger.warn((Object)"Server name mismatched.");
            return -4;
        }
        catch (Exception exception) {
            _logger.error((Object)"hasValid", (Throwable)exception);
            return -1;
        }
    }

    public static synchronized boolean isEval() {
        String string = ServerConfig.getLicenseProperty("isEval");
        return StringUtil.getBool(string);
    }

    public static boolean isExpired() {
        if (!LicenseServerProxy.isEval() || LicenseServerProxy.isFreeEdition()) {
            return false;
        }
        String string = ServerConfig.getLicenseProperty("expire");
        if (string == null) {
            return true;
        }
        long l2 = Long.parseLong(string);
        if (l2 < 0L) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        return l3 > l2;
    }

    public static boolean isFreeEdition() {
        String string = ServerConfig.getLicenseProperty("isFree");
        return string != null && StringUtil.getBool(string);
    }

    public static float getVersion() {
        return 7.0f;
    }

    public static void main(String[] stringArray) {
        if (0 == LicenseServerProxy.applyLicense(License.FREE_LICENSE)) {
            // empty if block
        }
    }

    /*
     * Loose catch block
     */
    public static boolean matchServerName(String string) {
        boolean bl2;
        block36: {
            int n2;
            int n3;
            int n4;
            String[] stringArray;
            String string2;
            block35: {
                block33: {
                    String string3;
                    String string4;
                    block34: {
                        block32: {
                            String string5 = ServerConfig.getLicenseProperty("checkServerName");
                            string2 = MBeanUtil.b();
                            if (string5 == null) break block32;
                            try {
                                block37: {
                                    if (StringUtil.getBool(string5)) break block32;
                                    break block37;
                                    catch (UnknownHostException unknownHostException) {
                                        throw LicenseServerProxy.a(unknownHostException);
                                    }
                                }
                                return true;
                            }
                            catch (UnknownHostException unknownHostException) {
                                throw LicenseServerProxy.a(unknownHostException);
                            }
                        }
                        String string6 = ServerConfig.getLicenseProperty("serverNames");
                        try {
                            if (string6 == null) {
                                return false;
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw LicenseServerProxy.a(unknownHostException);
                        }
                        stringArray = StringUtil.split(string6, SEPARATOR);
                        if (stringArray.length != 1) break block33;
                        string4 = stringArray[0];
                        if (string4.trim().length() != 17) break block33;
                        try {
                            block38: {
                                if (string4.charAt(2) != '-') break block33;
                                break block38;
                                catch (UnknownHostException unknownHostException) {
                                    throw LicenseServerProxy.a(unknownHostException);
                                }
                            }
                            if (string4.charAt(5) != '-') break block33;
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw LicenseServerProxy.a(unknownHostException);
                        }
                        string3 = null;
                        if (AppUtil.isWindows()) {
                            InetAddress inetAddress = null;
                            try {
                                inetAddress = InetAddress.getLocalHost();
                                _logger.info((Object)("local IP address:" + inetAddress.getHostAddress()));
                                JNbtstat jNbtstat = new JNbtstat(inetAddress.getHostAddress());
                                string3 = jNbtstat.getMacAddress();
                                _logger.info((Object)("local MAC address:" + string3));
                            }
                            catch (UnknownHostException unknownHostException) {
                                _logger.error((Object)"Can't get local host info");
                                return false;
                            }
                        }
                        try {
                            Process process = Runtime.getRuntime().exec("/sbin/ifconfig");
                            String string7 = StreamUtils.getInput(process.getInputStream());
                            int n5 = process.waitFor();
                            if (n5 == 0) {
                                String string8;
                                int n6;
                                int n7 = string7.indexOf("eth0");
                                if (n7 >= 0 && (n6 = string7.indexOf(string8 = "HWaddr", n7)) > 0) {
                                    string3 = string7.substring(n6 += string8.length(), n6 + 18).trim();
                                    string3 = string3.replace(':', '-');
                                }
                                break block34;
                            }
                            _logger.error((Object)"Can't MAC data on linux");
                            return false;
                        }
                        catch (Exception exception) {
                            _logger.error((Object)"Cant get local host info (linux)");
                            return false;
                        }
                    }
                    try {
                        if (string4.equalsIgnoreCase(string3)) {
                            return true;
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw LicenseServerProxy.a(unknownHostException);
                    }
                    _logger.error((Object)("License invalid: MAC addresses don't match. Local MAC:" + string3 + ", license MAC:" + string4));
                    return false;
                }
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    n3 = stringArray[n4].indexOf(".");
                    try {
                        try {
                            n2 = n3;
                            if (string2 == null) break block35;
                            if (n2 <= 0) continue;
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw LicenseServerProxy.a(unknownHostException);
                        }
                        stringArray[n4] = stringArray[n4].substring(0, n3);
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw LicenseServerProxy.a(unknownHostException);
                    }
                }
                n2 = n4 = string.indexOf(".");
            }
            if (n2 > 0) {
                string = string.substring(0, n4);
            }
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                String string9 = stringArray[n3].toUpperCase();
                try {
                    try {
                        bl2 = string9.equalsIgnoreCase(string);
                        if (string2 == null) break block36;
                        if (!bl2) continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw LicenseServerProxy.a(unknownHostException);
                    }
                    return true;
                }
                catch (UnknownHostException unknownHostException) {
                    throw LicenseServerProxy.a(unknownHostException);
                }
            }
            _logger.warn((Object)"Server names don't match");
            bl2 = false;
        }
        return bl2;
    }

    public static Map getLicense(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = ServerConfig.getProperty("license.applyTime");
        if (string2.equals(string)) {
            hashMap.put("license.applyTime", "0");
            hashMap.put("license", "0");
            return hashMap;
        }
        String string3 = ServerConfig.getProperty("license");
        hashMap.put("license.applyTime", string2);
        hashMap.put("license", string3);
        return hashMap;
    }

    public static int applyLicense(String string) {
        String string2;
        int n2;
        int n3;
        _logger.info((Object)("Local host name:[[[" + NetworkUtils.getLocalHostName() + "]]]"));
        Properties properties = LicenseUtil.processLicense(string);
        if (properties == null) {
            _logger.warn((Object)"License file is corrupt.");
            return -1;
        }
        String string3 = properties.getProperty("version");
        boolean bl2 = StringUtil.getBool(properties.getProperty("isFree"));
        if (string3 == null) {
            _logger.warn((Object)"Version info is missing.");
            return -3;
        }
        if (!StringUtil.getBool(properties.getProperty("isEval")) && !bl2 && (n3 = (int)Float.parseFloat(string3)) < (n2 = 7)) {
            _logger.warn((Object)("The version number of the license file is too old:" + n2));
            return -1;
        }
        if (ServerPropertiesFile.isMspEdition() && !StringUtil.getBool(properties.getProperty("isEval")) && !StringUtil.getBool(properties.getProperty("isMsp"))) {
            _logger.info((Object)"Not a valid MSP license.");
            return -1;
        }
        if (LicenseServerProxy.isEval() && (string2 = ServerConfig.getProperty("database.initialized")) != null) {
            if (properties == null) {
                return -1;
            }
            String string4 = properties.getProperty("isEval");
            if (StringUtil.getBool(string4)) {
                string4 = properties.getProperty("extension");
                if (string4 == null) {
                    _logger.warn((Object)"Cant extend trial license");
                    return -4;
                }
            } else {
                string4 = properties.getProperty("isFree");
                if (StringUtil.getBool(string4)) {
                    LicenseServerProxy.c();
                }
            }
        }
        if (ServerConfig.updateProperty("license", string)) {
            LicenseServerProxy.b();
            if (LicenseServerProxy.isEval() || LicenseServerProxy.isFreeEdition()) {
                LicenseServerProxy.a();
                return 0;
            }
            if (!LicenseServerProxy.matchServerName(NetworkUtils.getLocalHostName())) {
                _logger.warn((Object)("Server name mismatched. Local host name:[[[" + NetworkUtils.getLocalHostName() + "]]]"));
                return -1;
            }
            LicenseServerProxy.a();
            return 0;
        }
        _logger.warn((Object)"ServerConfig.updateProperty failed.");
        return -2;
    }

    private static void a() {
        String string = String.valueOf(System.currentTimeMillis());
        ServerConfig.updateProperty("license.applyTime", string);
    }

    private static void b() {
        try {
            CmdStartOrStopTrapReceiver.startOrStopTrapReceiver(Boolean.FALSE);
            CmdStartOrStopTrapReceiver.startOrStopTrapReceiver(Boolean.TRUE);
        }
        catch (Exception exception) {
            _logger.error((Object)"restartTrapReceiverIfNeed", (Throwable)exception);
        }
    }

    private static void c() {
        Graph2Db.clearAllGraph();
        boolean bl2 = MonitorProcessor.removeAllSchedules();
        if (!bl2) {
            _logger.error((Object)"monitors were not cleaned up.");
        }
    }

    /*
     * Loose catch block
     */
    public static String getTrialLicense() {
        String string;
        String string2 = "";
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet("http://www.ireasoning.com/downloadtxt.php?f=0&version=7.0.7045");
        CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((ClassicHttpRequest)httpGet);
        HttpEntity httpEntity = closeableHttpResponse.getEntity();
        try {
            string = httpEntity != null ? EntityUtils.toString((HttpEntity)httpEntity) : "";
        }
        catch (Throwable throwable) {
            throw LicenseServerProxy.a(throwable);
        }
        String string3 = string2 = string;
        try {
            if (closeableHttpResponse != null) {
                closeableHttpResponse.close();
            }
        }
        catch (Throwable throwable) {
            throw LicenseServerProxy.a(throwable);
        }
        try {
            if (closeableHttpClient != null) {
                closeableHttpClient.close();
            }
        }
        catch (Throwable throwable) {
            throw LicenseServerProxy.a(throwable);
        }
        return string3;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (closeableHttpResponse != null) {
                            try {
                                closeableHttpResponse.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (closeableHttpClient != null) {
                            try {
                                closeableHttpClient.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    _logger.error((Object)"", (Throwable)exception);
                    return "";
                }
            }
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

