/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.trapreceiver;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.ireasoning.protocol.e;
import com.ireasoning.protocol.h;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.a0;
import com.ireasoning.protocol.snmp.aX;
import com.ireasoning.protocol.snmp.j;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.trapreceiver.AlarmActions;
import com.sysuptime.common.trapreceiver.ClearTrapObject;
import com.sysuptime.common.trapreceiver.DedupEventObject;
import com.sysuptime.common.trapreceiver.MessageHelper;
import com.sysuptime.common.trapreceiver.ToBeClearedTrapObject;
import com.sysuptime.common.trapreceiver.TrapEventObject;
import com.sysuptime.common.trapreceiver.TrapObject;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.TimebasedCache;
import com.sysuptime.common.util.TrapProperties;
import com.sysuptime.common.util.trap.AesCipher;
import com.sysuptime.server.msp.ActionProxy;
import com.sysuptime.server.performance.NoUseStateTimebucketCache;
import com.sysuptime.server.trapreceiver.ClearCondition;
import com.sysuptime.server.trapreceiver.ClearSql;
import com.sysuptime.server.trapreceiver.DupSql;
import com.sysuptime.server.trapreceiver.DuplicationCacheObject;
import com.sysuptime.server.trapreceiver.DuplicationCondition;
import com.sysuptime.server.trapreceiver.EventActionsPerformer;
import com.sysuptime.server.trapreceiver.EventConfigSql;
import com.sysuptime.server.trapreceiver.MonitorActionsPerformer;
import com.sysuptime.server.trapreceiver.PooledPerformer;
import com.sysuptime.server.trapreceiver.ToBeClearedTrapCache;
import com.sysuptime.server.trapreceiver.ToBeClearedTrapKey;
import com.sysuptime.server.trapreceiver.ToBeClearedTrapValue;
import com.sysuptime.server.trapreceiver.TrapCallbackServer;
import com.sysuptime.server.trapreceiver.TrapForwarder;
import com.sysuptime.server.trapreceiver.TrapMailSender;
import com.sysuptime.server.trapreceiver.TrapReceiver$1;
import com.sysuptime.server.trapreceiver.TrapReceiverSql;
import com.sysuptime.server.trapreceiver.TrapReceiverUtil;
import com.sysuptime.server.util.ClusterContentUpdater;
import com.sysuptime.server.util.ServerConfig;
import com.sysuptime.server.util.SimpleIDGenerator;
import com.sysuptime.server.util.ThreadPool;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class TrapReceiver
extends Thread
implements e {
    private static final Object[] AUTH_ALGORITHM = new Object[]{"HMAC-MD5", "HMAC-SHA-1"};
    private static final Logger _logger = Logger.getLogger((String)TrapReceiver.class.getName());
    private static j _session;
    private static HashMap _events;
    private static HashMap _defaultRules;
    private static Hashtable _dupHashtable;
    private static Hashtable _toBeClearedTraps;
    private static Hashtable _clearTraps;
    private static TimebasedCache _dupLinkedHashMap;
    private static ToBeClearedTrapCache _toBeClearedTrapCache;
    private static AesCipher _cipher;
    private static String _ipAddress;
    private static long _startupTime;
    private static TrapReceiver _trapReceiver;
    protected static SimpleIDGenerator _idProvider;
    private static final Class[] RESET_EVENTS_CLASS_TYPES;
    private static final Object[] FALSE;

    public TrapReceiver() {
        this.a();
        _trapReceiver = this;
    }

    private void a() {
        block2: {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = PooledPerformer.b();
            for (int i2 = 0; i2 < 48; ++i2) {
                stringBuffer.append((1231121818197L + (long)(i2 * i2)) % 197L % 2L);
                if (stringArray != null) {
                    if (stringArray != null) continue;
                }
                break block2;
            }
            _cipher = new AesCipher(stringBuffer.toString());
        }
    }

    @Override
    public void run() {
        _startupTime = System.currentTimeMillis();
        TrapReceiver.resetDataStructures();
        this.b();
    }

    public static void resetEvents() {
        TrapReceiver.resetEvents(true);
    }

    public static void resetEvents(boolean bl2) {
        block3: {
            block2: {
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                String[] stringArray = PooledPerformer.b();
                if (!EventConfigSql.getEvents(hashMap, hashMap2)) break block2;
                _events = hashMap;
                _defaultRules = hashMap2;
                if (!bl2) break block3;
                TrapReceiver.b("resetEvents");
                if (stringArray != null) break block3;
            }
            _logger.error((Object)"Current Rules Can't Be insteaded  Because Getting Rules Happened Error .");
        }
    }

    public static void resetDataStructures() {
        _events.clear();
        _defaultRules.clear();
        _dupHashtable.clear();
        _toBeClearedTraps.clear();
        _clearTraps.clear();
        boolean bl2 = EventConfigSql.getEvents(_events, _defaultRules);
        bl2 &= DupSql.getDuptable(_dupHashtable);
        bl2 &= ClearSql.getBeCleartable(_toBeClearedTraps);
        if (!(bl2 &= ClearSql.getCleartable(_clearTraps))) {
            _logger.error((Object)"Config rule engine failed ...");
            return;
        }
    }

    private void b() {
        block12: {
            String[] stringArray = PooledPerformer.b();
            try {
                String string = ServerConfig.getProperty("trapReceiver.port", "162");
                if (!StringUtil.isNumeric(string)) {
                    TrapCallbackServer.getInstance().trapReceiverStatus(false, _ipAddress);
                    _logger.error((Object)"Trap receiver port isn't numeric");
                    return;
                }
                RmiResponse rmiResponse = new TrapReceiverSql().getProperties(this);
                if (rmiResponse.getValue().equals(Boolean.FALSE)) {
                    TrapCallbackServer.getInstance().trapReceiverStatus(false, _ipAddress);
                    _logger.error((Object)("Failed to retrieve trap receiver properties" + rmiResponse.getErrorMessage()));
                    return;
                }
                ArrayList arrayList = (ArrayList)rmiResponse.getValue();
                PooledExecutor pooledExecutor = new PooledExecutor(40);
                InetAddress inetAddress = null;
                if (_ipAddress != null) {
                    inetAddress = InetAddress.getByName(_ipAddress);
                }
                _logger.info((Object)("Trap receiver configured at " + inetAddress + ":" + string));
                _session = new j(Integer.parseInt(string), inetAddress, pooledExecutor);
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    TrapProperties trapProperties = (TrapProperties)arrayList.get(i2);
                    try {
                        _session.addV3Params(trapProperties.getUsername(), (String)AUTH_ALGORITHM[trapProperties.getAuth()], trapProperties.getAuthPasswd(), trapProperties.getPriv(), trapProperties.getPrivPasswd(), AesCipher.getHexString(trapProperties.getEngineID()));
                        if (stringArray != null) {
                            if (stringArray != null) continue;
                            break;
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        throw TrapReceiver.a(exception);
                    }
                }
                _session.setEngineID("fjaskf1231jfjasl".getBytes());
                _session.addListener(this);
                _logger.info((Object)("Trap receiver started at " + inetAddress + ":" + string));
                TrapCallbackServer.getInstance().trapReceiverStatus(true, _ipAddress);
                _session.waitForTrap();
            }
            catch (Exception exception) {
                try {
                    if (_session != null) {
                        _session.close();
                    }
                }
                catch (Exception exception2) {
                    throw TrapReceiver.a(exception2);
                }
                _session = null;
                TrapCallbackServer.getInstance().trapReceiverStatus(false, _ipAddress);
                _logger.error((Object)"Trap receiver failed to start", (Throwable)exception);
            }
        }
    }

    public void stopService() {
        _logger.info((Object)"Trap receiver closed");
        if (_session != null) {
            _session.close();
            _session = null;
        }
    }

    public static void setIp(String string) {
        _ipAddress = string;
    }

    public static void restartTrapReceiver(boolean bl2) {
        if (_session != null) {
            _session.close();
        }
        new Timer(true).schedule((TimerTask)new TrapReceiver$1(), 2000L);
        if (bl2) {
            TrapReceiver.b("restartTrapReceiver");
        }
    }

    public static void addSnmpV3Param(TrapProperties trapProperties, boolean bl2) {
        if (_session != null) {
            _session.addV3Params(trapProperties.getUsername(), (String)AUTH_ALGORITHM[trapProperties.getAuth()], trapProperties.getAuthPasswd(), trapProperties.getPriv(), trapProperties.getPrivPasswd(), AesCipher.getHexString(trapProperties.getEngineID()));
        }
        if (bl2) {
            TrapReceiver.a("addSnmpV3Param", new Class[]{TrapProperties.class, Boolean.TYPE}, new Object[]{trapProperties, Boolean.FALSE});
        }
    }

    public static void deleteSnmpV3UsmUser(String string, byte[] byArray, boolean bl2) {
        if (_session != null) {
            _session.removeUsmUser(string, byArray);
        }
        if (bl2) {
            TrapReceiver.a("deleteSnmpV3UsmUser", new Class[]{String.class, byte[].class, Boolean.TYPE}, new Object[]{string, byArray, Boolean.FALSE});
        }
    }

    @Override
    public void handleMsg(Object object, h h2) {
        this.a(h2);
    }

    private void a(h h2) {
        block5: {
            TrapObject trapObject;
            String string;
            block6: {
                String[] stringArray = PooledPerformer.b();
                if (!(h2 instanceof SnmpDataType)) break block5;
                SnmpDataType snmpDataType = (SnmpDataType)h2;
                int n2 = snmpDataType.getType();
                string = TrapReceiverUtil.getOid(h2, n2);
                trapObject = TrapReceiverUtil.getTrap(h2, n2);
                TrapEventObject trapEventObject = TrapReceiver.a(string);
                if (trapEventObject == null) break block6;
                String string2 = TrapReceiver.a(h2, n2);
                if (!trapEventObject.isSourceQualified(string2)) {
                    trapEventObject = null;
                }
                TrapReceiver.a(h2, string, trapEventObject, trapObject, -1);
                if (stringArray != null) break block5;
            }
            if (StringUtil.getBool(ServerConfig.getProperty("trapReceiver.storeUnknownTraps", "Yes"))) {
                TrapReceiver.a(h2, string, null, trapObject, -1);
            }
        }
    }

    public static void sendTrapToClient(TrapObject trapObject) {
        ActionProxy.getInstance().sendTrapToClient(trapObject);
    }

    private static void a(h h2, String string, TrapEventObject trapEventObject, TrapObject trapObject, int n2) {
        int n3;
        block10: {
            block9: {
                n3 = 0;
                String[] stringArray = PooledPerformer.b();
                trapObject.setTrapOid(string);
                if (trapEventObject == null) break block9;
                n3 = trapEventObject.getEventModeInInt();
                if (n3 == 2) {
                    return;
                }
                trapObject.setEvent(trapEventObject);
                trapObject.setSeverity(trapEventObject.getSeverity(trapObject));
                trapObject.setMessage(trapEventObject.getMessage(trapObject));
                if (stringArray != null) break block10;
            }
            trapObject.setSeverity((short)Integer.parseInt(ServerConfig.getProperty("trapReceiver.unknownTrapsSeverity", "0")));
            String string2 = new MessageHelper(ServerConfig.getProperty("trapReceiver.unknownTrapsMessage", "$oid")).toString(trapObject);
            trapObject.setMessage(string2);
        }
        boolean bl2 = StringUtil.getBool(ServerConfig.getProperty("trapReceiver.dedupEnabled", "No"));
        boolean bl3 = true;
        if (bl2 && !(bl3 = TrapReceiver.dedupTrap(trapObject))) {
            return;
        }
        trapObject.setTrapId(_idProvider.generateDouble());
        if (!TrapReceiver.sendToDB(trapObject)) {
            _logger.error((Object)"Adding to database failed ... ");
            return;
        }
        if (n3 == 0) {
            TrapReceiver.sendTrapToClient(trapObject);
        }
        if (StringUtil.getBool(ServerConfig.getProperty("trapReceiver.clearTrapEnabled", "No"))) {
            TrapReceiver.a(trapObject, n2);
        }
        if (trapEventObject != null) {
            TrapReceiver.a(trapEventObject, trapObject);
        }
        TrapMailSender.sendTrap2GeneralMail(trapObject);
        TrapForwarder.doIt(trapObject, h2);
    }

    private static void a(TrapEventObject trapEventObject, TrapObject trapObject) {
        String string = trapEventObject.getActions();
        if (string != null) {
            try {
                AlarmActions alarmActions = AlarmActions.fromXML(string, NoUseStateTimebucketCache.getCacheMap());
                EventActionsPerformer eventActionsPerformer = new EventActionsPerformer(ThreadPool.INSTANCE, trapObject);
                eventActionsPerformer.perform(alarmActions);
            }
            catch (Exception exception) {
                _logger.error((Object)exception, (Throwable)exception);
            }
        }
    }

    private static void a(boolean bl2, TrapObject trapObject, Monitor monitor) {
        TrapReceiver.performMonitorActions(bl2, trapObject, monitor, false);
    }

    public static void performMonitorActions(boolean bl2, TrapObject trapObject, Monitor monitor, boolean bl3) {
        String string = monitor.getActions();
        if (string != null) {
            try {
                AlarmActions alarmActions = AlarmActions.fromXML(string, NoUseStateTimebucketCache.getCacheMap());
                MonitorActionsPerformer monitorActionsPerformer = new MonitorActionsPerformer(ThreadPool.INSTANCE, bl2, trapObject);
                monitorActionsPerformer.perform(alarmActions, bl3);
            }
            catch (Exception exception) {
                _logger.error((Object)exception, (Throwable)exception);
            }
        }
    }

    public static boolean sendToDB(TrapObject trapObject) {
        return ActionProxy.getInstance().storeTrap(trapObject);
    }

    public static boolean processInternalTrap(h h2, int n2, Monitor monitor) {
        TrapObject trapObject;
        block7: {
            TrapEventObject trapEventObject;
            String string;
            block6: {
                String[] stringArray = PooledPerformer.b();
                string = TrapReceiverUtil.getOid(h2, -92);
                trapObject = TrapReceiverUtil.getTrap(h2, -92);
                trapObject.setTimestamp((System.currentTimeMillis() - _startupTime) / 10L);
                String[] stringArray2 = stringArray;
                trapEventObject = TrapReceiver.a(string);
                if (trapEventObject == null) break block6;
                String string2 = TrapReceiver.a(h2, -92);
                if (!trapEventObject.isSourceQualified(string2)) {
                    trapEventObject = null;
                    if (!StringUtil.getBool(ServerConfig.getProperty("trapReceiver.storeUnknownTraps", "No"))) {
                        return false;
                    }
                }
                TrapReceiver.a(h2, string, trapEventObject, trapObject, n2);
                if (stringArray2 != null) break block7;
            }
            if (StringUtil.getBool(ServerConfig.getProperty("trapReceiver.storeUnknownTraps", "No"))) {
                TrapReceiver.a(h2, string, trapEventObject, trapObject, -1);
            }
        }
        boolean bl2 = n2 == 0;
        TrapReceiver.a(bl2, trapObject, monitor);
        return true;
    }

    public static boolean dedupTrap(TrapObject trapObject) {
        DuplicationCondition duplicationCondition = (DuplicationCondition)_dupHashtable.get(trapObject.getTrapOid());
        if (duplicationCondition == null) {
            return true;
        }
        DuplicationCacheObject duplicationCacheObject = new DuplicationCacheObject(trapObject, duplicationCondition);
        if (!duplicationCacheObject.isValid()) {
            return true;
        }
        String string = ServerConfig.getProperty("trapReceiver.dedupTime");
        long l2 = Long.parseLong(string) * 1000L;
        boolean bl2 = _dupLinkedHashMap.add(duplicationCacheObject, l2, false);
        if (!bl2) {
            _logger.debug((Object)("Ignore duplicate trap:" + trapObject.getTrapOid()));
        }
        return bl2;
    }

    private static void a(TrapObject trapObject, int n2) {
        block13: {
            Object object;
            ToBeClearedTrapKey toBeClearedTrapKey;
            ClearCondition clearCondition;
            ArrayList arrayList;
            long l2;
            String[] stringArray;
            block12: {
                String string = ServerConfig.getProperty("trapReceiver.clearTrapTime", "60");
                stringArray = PooledPerformer.b();
                l2 = Long.parseLong(string) * 1000L * 60L;
                String string2 = trapObject.getTrapOid();
                arrayList = null;
                if (n2 != 0 && (arrayList = (ArrayList)_toBeClearedTraps.get(string2)) != null) {
                    Iterator iterator = arrayList.iterator();
                    ToBeClearedTrapValue toBeClearedTrapValue = new ToBeClearedTrapValue();
                    toBeClearedTrapValue.setProbeID(trapObject.getProbeID());
                    toBeClearedTrapValue.setTrapID(trapObject.getTrapId());
                    while (iterator.hasNext()) {
                        clearCondition = (ClearCondition)iterator.next();
                        toBeClearedTrapKey = new ToBeClearedTrapKey(clearCondition, trapObject);
                        object = toBeClearedTrapKey.getCondition();
                        if (stringArray != null) {
                            if (object != null) {
                                _toBeClearedTrapCache.addToBeClearedTrap(toBeClearedTrapKey, toBeClearedTrapValue, l2);
                            }
                            if (stringArray != null) continue;
                        }
                        break block12;
                    }
                }
                if (n2 == 1 || n2 == 2) break block13;
                object = _clearTraps.get(trapObject.getTrapOid());
            }
            if ((arrayList = (ArrayList)object) != null) {
                for (ToBeClearedTrapValue toBeClearedTrapValue : arrayList) {
                    clearCondition = (ClearCondition)((Object)toBeClearedTrapValue);
                    toBeClearedTrapKey = new ToBeClearedTrapKey(clearCondition, trapObject);
                    if (toBeClearedTrapKey.getCondition() != null) {
                        _toBeClearedTrapCache.clearTrap(toBeClearedTrapKey, l2);
                    }
                    if (stringArray != null) continue;
                }
            }
        }
    }

    private static TrapEventObject a(String object) {
        if (_events.containsKey(object)) {
            TrapEventObject trapEventObject = (TrapEventObject)_events.get(object);
            return trapEventObject;
        }
        int n2 = ((String)object).lastIndexOf(".");
        object = ((String)object).substring(0, n2);
        if (_defaultRules.containsKey(object = (String)object + ".*")) {
            return (TrapEventObject)_defaultRules.get(object);
        }
        return null;
    }

    private static String a(h h2, int n2) {
        if (n2 == -92) {
            return ((a0)h2).getIpAddress().toString();
        }
        return ((aX)h2).getIpAddress();
    }

    public static void addClear(ClearTrapObject clearTrapObject) {
        TrapReceiver.addClear(clearTrapObject, true);
    }

    public static void addClear(ClearTrapObject clearTrapObject, boolean bl2) {
        block4: {
            ArrayList arrayList;
            Object[] objectArray = clearTrapObject.getBeClears();
            String[] stringArray = PooledPerformer.b();
            ArrayList<ClearCondition> arrayList2 = new ArrayList<ClearCondition>();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ArrayList arrayList3;
                ToBeClearedTrapObject toBeClearedTrapObject = (ToBeClearedTrapObject)objectArray[i2];
                ClearCondition clearCondition = new ClearCondition();
                clearCondition.setOid(toBeClearedTrapObject.getOid());
                clearCondition.setCondition(toBeClearedTrapObject.getCondition());
                arrayList2.add(clearCondition);
                arrayList = arrayList3 = (ArrayList)_toBeClearedTraps.get(toBeClearedTrapObject.getOid());
                if (stringArray != null) {
                    if (arrayList != null) {
                        ClearCondition clearCondition2 = new ClearCondition();
                        clearCondition2.setCondition(toBeClearedTrapObject.getBeCondition());
                        clearCondition2.setOid(toBeClearedTrapObject.getOid());
                        clearCondition2.setClearOid(clearTrapObject.getOid());
                        clearCondition2.setIps(toBeClearedTrapObject.getIps());
                        arrayList3.add(clearCondition2);
                        if (stringArray != null) continue;
                    }
                    _toBeClearedTraps.put(toBeClearedTrapObject.getOid(), new ArrayList());
                    if (stringArray != null) continue;
                }
                break block4;
            }
            arrayList = _clearTraps.put(clearTrapObject.getOid(), arrayList2);
        }
        if (bl2) {
            TrapReceiver.a("addClear", new Class[]{ClearTrapObject.class, Boolean.TYPE}, new Object[]{clearTrapObject, Boolean.FALSE});
        }
    }

    public static void deleteClear(String string) {
        TrapReceiver.deleteClear(string, true);
    }

    public static void deleteClear(String string, boolean n2) {
        int n3;
        block5: {
            ArrayList arrayList = (ArrayList)_clearTraps.get(string);
            Iterator iterator = arrayList.iterator();
            String[] stringArray = PooledPerformer.b();
            while (iterator.hasNext()) {
                boolean bl2;
                String string2;
                block6: {
                    Object e10 = iterator.next();
                    ClearCondition clearCondition = (ClearCondition)e10;
                    string2 = clearCondition.getOid();
                    ArrayList arrayList2 = (ArrayList)_toBeClearedTraps.get(string2);
                    int n4 = arrayList2.size();
                    n3 = 0;
                    if (stringArray == null) break block5;
                    for (int i2 = v1281593; i2 < arrayList2.size(); ++i2) {
                        ClearCondition clearCondition2 = (ClearCondition)arrayList2.get(i2);
                        bl2 = clearCondition2.getClearOid().equals(string);
                        if (stringArray != null) {
                            if (!bl2) continue;
                            arrayList2.remove(i2 - (n4 - arrayList2.size()));
                            if (stringArray != null) continue;
                        }
                        break block6;
                    }
                    bl2 = arrayList2.isEmpty();
                }
                if (bl2) {
                    _toBeClearedTraps.remove(string2);
                }
                if (stringArray != null) continue;
            }
            _clearTraps.remove(string);
            n3 = n2;
        }
        if (n3 != 0) {
            TrapReceiver.a("deleteClear", new Class[]{String.class, Boolean.TYPE}, new Object[]{string, Boolean.FALSE});
        }
    }

    public static void modifyClear(ClearTrapObject clearTrapObject) {
        TrapReceiver.modifyClear(clearTrapObject, true);
    }

    public static void modifyClear(ClearTrapObject clearTrapObject, boolean bl2) {
        String string = clearTrapObject.getOid();
        TrapReceiver.deleteClear(string);
        TrapReceiver.addClear(clearTrapObject);
        if (bl2) {
            TrapReceiver.a("modifyClear", new Class[]{ClearTrapObject.class, Boolean.TYPE}, new Object[]{clearTrapObject, Boolean.FALSE});
        }
    }

    public static void modifyBeClear(String string, ToBeClearedTrapObject toBeClearedTrapObject) {
        TrapReceiver.modifyBeClear(string, toBeClearedTrapObject, true);
    }

    /*
     * Loose catch block
     */
    public static void modifyBeClear(String string, ToBeClearedTrapObject toBeClearedTrapObject, boolean bl2) {
        String[] stringArray = PooledPerformer.b();
        try {
            boolean bl3;
            block16: {
                Object object;
                block15: {
                    _toBeClearedTrapCache.clearContent();
                    ArrayList arrayList = (ArrayList)_clearTraps.get(string);
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        ClearCondition clearCondition = (ClearCondition)arrayList.get(i2);
                        object = clearCondition.getOid();
                        if (stringArray == null) break block15;
                        try {
                            block18: {
                                if (!((String)object).equals(toBeClearedTrapObject.getOid())) continue;
                                break block18;
                                catch (Exception exception) {
                                    throw TrapReceiver.a(exception);
                                }
                            }
                            clearCondition.setCondition(toBeClearedTrapObject.getCondition());
                            continue;
                        }
                        catch (Exception exception) {
                            throw TrapReceiver.a(exception);
                        }
                    }
                    object = _toBeClearedTraps.get(toBeClearedTrapObject.getOid());
                }
                ArrayList arrayList = (ArrayList)object;
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    ClearCondition clearCondition = (ClearCondition)arrayList.get(i3);
                    bl3 = clearCondition.getClearOid().equals(string);
                    if (stringArray == null) break block16;
                    try {
                        block19: {
                            if (!bl3) continue;
                            break block19;
                            catch (Exception exception) {
                                throw TrapReceiver.a(exception);
                            }
                        }
                        clearCondition.setCondition(toBeClearedTrapObject.getCondition());
                        clearCondition.setCondition(toBeClearedTrapObject.getBeCondition());
                        clearCondition.setIps(toBeClearedTrapObject.getIps());
                        continue;
                    }
                    catch (Exception exception) {
                        throw TrapReceiver.a(exception);
                    }
                }
                bl3 = bl2;
            }
            try {
                if (bl3) {
                    TrapReceiver.a("modifyBeClear", new Class[]{String.class, ToBeClearedTrapObject.class, Boolean.TYPE}, new Object[]{string, toBeClearedTrapObject, Boolean.FALSE});
                }
            }
            catch (Exception exception) {
                throw TrapReceiver.a(exception);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
    }

    public static Hashtable getDedupEvent() {
        return _dupHashtable;
    }

    public static void addDedup(DedupEventObject dedupEventObject) {
        TrapReceiver.addDedup(dedupEventObject, true);
    }

    public static void addDedup(DedupEventObject dedupEventObject, boolean bl2) {
        DuplicationCondition duplicationCondition = new DuplicationCondition();
        duplicationCondition.setCondition(dedupEventObject.getConditions());
        _dupHashtable.put(dedupEventObject.getOid(), duplicationCondition);
        if (bl2) {
            TrapReceiver.a("addDedup", new Class[]{DedupEventObject.class, Boolean.TYPE}, new Object[]{dedupEventObject, Boolean.FALSE});
        }
    }

    public static void modifyDedup(DedupEventObject dedupEventObject) {
        TrapReceiver.modifyDedup(dedupEventObject, true);
    }

    public static void modifyDedup(DedupEventObject dedupEventObject, boolean bl2) {
        DuplicationCondition duplicationCondition = (DuplicationCondition)_dupHashtable.get(dedupEventObject.getOid());
        duplicationCondition.setCondition(dedupEventObject.getConditions());
        if (bl2) {
            TrapReceiver.a("modifyDedup", new Class[]{DedupEventObject.class, Boolean.TYPE}, new Object[]{dedupEventObject, Boolean.FALSE});
        }
    }

    public static void deleteDedup(String string) {
        TrapReceiver.deleteDedup(string, true);
    }

    public static void deleteDedup(String string, boolean bl2) {
        _dupHashtable.remove(string);
        if (bl2) {
            TrapReceiver.a("deleteDedup", new Class[]{String.class, Boolean.TYPE}, new Object[]{string, Boolean.FALSE});
        }
    }

    public String encrypt(String string) {
        return _cipher.encrypt(string);
    }

    public String decrypt(String string) {
        return _cipher.decrypt(string);
    }

    public static HashMap getEvents() {
        return _events;
    }

    public HashMap getDefaultRules() {
        return _defaultRules;
    }

    public j getSession() {
        return _session;
    }

    public void removeListener() {
        if (_session != null) {
            _session.removeListener(this);
        }
    }

    public static Object configSmtpServer(String string, String string2, String string3, String string4, boolean bl2) {
        Object object = TrapReceiverUtil.configSmtpServer(string, string2, string3, string4);
        if (bl2) {
            TrapReceiver.a("smtpServerConfig", new Class[]{String.class, String.class, String.class, String.class, Boolean.TYPE}, new Object[]{string, string2, string3, string4, Boolean.FALSE});
        }
        return object;
    }

    private static void b(String string) {
        ClusterContentUpdater clusterContentUpdater = new ClusterContentUpdater(TrapReceiver.class.getName(), string, RESET_EVENTS_CLASS_TYPES, FALSE);
        clusterContentUpdater.broadcastChanges();
    }

    private static void a(String string, Class[] classArray, Object[] objectArray) {
        ClusterContentUpdater clusterContentUpdater = new ClusterContentUpdater(TrapReceiver.class.getName(), string, classArray, objectArray);
        clusterContentUpdater.broadcastChanges();
    }

    static {
        _events = new HashMap();
        _defaultRules = new HashMap();
        _dupHashtable = new Hashtable();
        _toBeClearedTraps = new Hashtable();
        _clearTraps = new Hashtable();
        _dupLinkedHashMap = new TimebasedCache();
        _toBeClearedTrapCache = new ToBeClearedTrapCache();
        _idProvider = new SimpleIDGenerator();
        RESET_EVENTS_CLASS_TYPES = new Class[]{Boolean.TYPE};
        FALSE = new Object[]{Boolean.FALSE};
        String string = AppUtil.getAppHomeDirectory() + "/data/monitor/";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

