/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.server.performance.SharedReader;
import com.sysuptime.server.util.DefaultConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class TimebucketWriter {
    private static long _pk = -1L;
    private static Logger _logger = Logger.getLogger((String)TimebucketWriter.class.getName());

    private TimebucketWriter() {
    }

    private static void a() {
        if (++_pk >= Long.MAX_VALUE) {
            _pk = 0L;
        }
    }

    private static long b() {
        return _pk;
    }

    public static void storeProvidedIdTimebucketData(Connection connection, Timebucket timebucket) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "INSERT INTO PM_TIMEBUCKET (TIMEBUCKET_ID_C, TIMEBUCKET_NAME_C) VALUES(?,?)";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, timebucket.getTimebucketId());
            preparedStatement.setString(2, timebucket.getTimebucketName());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Store pm_timebucket id and name " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static long storeTimebucketData(Connection connection, Timebucket timebucket) throws SQLException {
        long l2 = timebucket.getTimebucketId();
        if (timebucket.getTimebucketId() == -1L) {
            TimebucketWriter.a();
            timebucket.setTimebucketId(TimebucketWriter.b());
            l2 = TimebucketWriter.b();
        }
        TimebucketWriter.storeProvidedIdTimebucketData(connection, timebucket);
        return l2;
    }

    public static void removeTimebucket(Connection connection, long l2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "DELETE FROM PM_TIMEBUCKET WHERE TIMEBUCKET_ID_C =?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Delete pm_timebucket one record " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void updateTimebucketName(Connection connection, Timebucket timebucket) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "UPDATE PM_TIMEBUCKET SET TIMEBUCKET_NAME_C=? WHERE TIMEBUCKET_ID_C =?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, timebucket.getTimebucketName());
            preparedStatement.setLong(2, timebucket.getTimebucketId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("update pm_timebucket name" + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    static {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            String string = "SELECT MAX(TIMEBUCKET_ID_C) FROM PM_TIMEBUCKET";
            _pk = SharedReader.getId(connection, string);
        }
        catch (Exception exception) {
            _logger.error((Object)"Init tiembucket to get primary key. ", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }
}

