/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.openapi.performance.IExecutorParameter;
import com.openapi.performance.IQueryExecutor;
import com.openapi.performance.ResultTypeValue;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.server.performance.AbstractExecutor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.LogFileExecutor;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.performance.RemoteHostProcessor;
import com.sysuptime.server.util.ServerBundle;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import net.sf.jradius.client.RadiusClient;
import net.sf.jradius.client.auth.PAPAuthenticator;
import net.sf.jradius.client.auth.RadiusAuthenticator;
import net.sf.jradius.dictionary.Attr_UserName;
import net.sf.jradius.dictionary.Attr_UserPassword;
import net.sf.jradius.packet.AccessAccept;
import net.sf.jradius.packet.AccessRequest;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import org.apache.log4j.Logger;

public class RadiusExecutor
extends AbstractExecutor
implements IQueryExecutor {
    protected static Logger _logger = Logger.getLogger((String)LogFileExecutor.class.getName());
    private static final long RADIUS_UNKNOWN_HOST = ServerBundle.getParsedMessage("RADIUS_UNKNOWN_HOST");
    private static final long RADIUS_AUTHENTICATOR_ERROR = ServerBundle.getParsedMessage("RADIUS_AUTHENTICATOR_ERROR");
    private static final long RADIUS_EXCEPTION = ServerBundle.getParsedMessage("RADIUS_EXCEPTION");
    private static int RADIUS_RTT;
    private static int RADIUS_CONTENT_MATCH;

    @Override
    public ResultValue[] startExecuting(IExecutorParameter iExecutorParameter) {
        QueryParameter queryParameter = iExecutorParameter.getQueryParameter();
        List<ResultTypeValue> list = iExecutorParameter.getResultTypeValues();
        int n2 = iExecutorParameter.getMonitorId();
        int[] nArray = PerformanceServerUtil.getResultTypes(list);
        try {
            if (PerformanceServerUtil.isOurCategory(nArray, new int[]{RADIUS_RTT, RADIUS_CONTENT_MATCH})) {
                return this.a(queryParameter, list, nArray, n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw RadiusExecutor.a(illegalArgumentException);
        }
        throw new IllegalArgumentException("No such result types " + nArray);
    }

    /*
     * Unable to fully structure code
     */
    protected ResultValue[] a(QueryParameter var1_1, List var2_2, int[] var3_3, int var4_4) {
        block13: {
            var6_5 = null;
            var5_6 = ExecutorHelper.c();
            try {
                var7_7 = Long.parseLong(var1_1.get(0).toString());
                var6_5 = RemoteHostProcessor.getRemoteHostByHostId(var7_7);
            }
            catch (Exception var7_8) {
                RadiusExecutor._logger.error((Object)var7_8);
            }
            try {
                if (var6_5 == null) {
                    throw new IllegalArgumentException("Radius remote host is not found.");
                }
            }
            catch (Exception v0) {
                throw RadiusExecutor.a(v0);
            }
            var7_9 = new HashMap<Integer, ResultValue>();
            try {
                var8_10 = System.currentTimeMillis();
                AttributeFactory.loadAttributeDictionary((String)"net.sf.jradius.dictionary.AttributeDictionaryImpl");
                var10_13 = new RadiusClient(InetAddress.getByName(var6_5.getHostName()), var1_1.get(1).toString(), Integer.parseInt(var6_5.getValue("auth_port").toString()), Integer.parseInt(var6_5.getValue("acct_port").toString()), Integer.parseInt(var1_1.get(3).toString()));
                var11_14 = new AttributeList();
                var11_14.add((RadiusAttribute)new Attr_UserName(var6_5.getUser()));
                var12_15 = new AccessRequest(var10_13, var11_14);
                var12_15.addAttribute((RadiusAttribute)new Attr_UserPassword(var6_5.getValue("password").toString()));
                var13_16 = var10_13.authenticate(var12_15, (RadiusAuthenticator)new PAPAuthenticator(), Integer.parseInt(var1_1.get(2).toString()));
                var14_17 = (String)var13_16.getAttributeValue(18);
                if (var14_17 == null) {
                    var14_17 = "";
                }
                if (!(var13_16 instanceof AccessAccept)) ** GOTO lbl40
                try {
                    block14: {
                        var7_9.put(RadiusExecutor.RADIUS_RTT, QueryFactory.createResultValueObject(RadiusExecutor.RADIUS_RTT, "N", System.currentTimeMillis() - var8_10));
                        var7_9.put(RadiusExecutor.RADIUS_CONTENT_MATCH, QueryFactory.createResultValueObject(RadiusExecutor.RADIUS_CONTENT_MATCH, "N", var14_17));
                        if (var5_6 == 0) break block13;
                        break block14;
                        catch (Exception v1) {
                            throw RadiusExecutor.a(v1);
                        }
                    }
                    PerformanceServerUtil.putErrors(var7_9, var3_3, RadiusExecutor.RADIUS_AUTHENTICATOR_ERROR);
                }
                catch (Exception v2) {
                    throw RadiusExecutor.a(v2);
                }
            }
            catch (UnknownHostException var8_11) {
                RadiusExecutor._logger.info((Object)"Radius", (Throwable)var8_11);
                this._errorbuf.append(var8_11);
                PerformanceServerUtil.putErrors(var7_9, var3_3, RadiusExecutor.RADIUS_UNKNOWN_HOST);
            }
            catch (Exception var8_12) {
                RadiusExecutor._logger.info((Object)"Radius", (Throwable)var8_12);
                this._errorbuf.append(var8_12);
                PerformanceServerUtil.putErrors(var7_9, var3_3, RadiusExecutor.RADIUS_EXCEPTION);
            }
        }
        return PerformanceServerUtil.getResultValues(var3_3, var7_9);
    }

    static {
        try {
            RADIUS_RTT = ExecutorHelper.getId("RADIUS_RTT");
            RADIUS_CONTENT_MATCH = ExecutorHelper.getId("RADIUS_CONTENT_MATCH");
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

