/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.openapi.performance.IExecutorParameter;
import com.openapi.performance.IQueryExecutor;
import com.openapi.performance.ResultTypeValue;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.performance.AbstractExecutor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.util.ServerBundle;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class PortExecutor
extends AbstractExecutor
implements IQueryExecutor {
    protected static Logger _logger = Logger.getLogger((String)PortExecutor.class.getName());
    public static final long PORT_UNKNOWN_HOST = ServerBundle.getParsedMessage("PORT_UNKNOWN_HOST");
    public static final long PROTOCOL_ERROR = ServerBundle.getParsedMessage("PROTOCOL_ERROR");
    public static final long PORT_TIMEOUT = ServerBundle.getParsedMessage("PORT_TIMEOUT");
    public static final long PORT_IO_ERROR = ServerBundle.getParsedMessage("PORT_IO_ERROR");
    public static final long PORT_UNKNOWN_ERROR = ServerBundle.getParsedMessage("PORT_UNKNOWN_ERROR");
    public static int PORT_RESPONSE_TIME;
    public static int PORT_CONTENT_MATCH;
    protected static int[] RESULT_TYPES_1;

    @Override
    public ResultValue[] startExecuting(IExecutorParameter iExecutorParameter) {
        String string = iExecutorParameter.getHostName();
        QueryParameter queryParameter = iExecutorParameter.getQueryParameter();
        int n2 = ExecutorHelper.c();
        List<ResultTypeValue> list = iExecutorParameter.getResultTypeValues();
        int[] nArray = PerformanceServerUtil.getResultTypes(list);
        if (PerformanceServerUtil.isOurCategory(nArray, RESULT_TYPES_1)) {
            byte[] byArray;
            int n3;
            int n4;
            int n5;
            block9: {
                n5 = Integer.parseInt(queryParameter.get(0).toString());
                n4 = 0;
                if (n5 == -1) {
                    n5 = Integer.parseInt(queryParameter.get(3).toString());
                    n4 = Integer.parseInt(queryParameter.get(4).toString());
                }
                n3 = Integer.parseInt(queryParameter.get(1).toString());
                String string2 = queryParameter.get(2).toString();
                byArray = null;
                String string3 = string2.toLowerCase();
                if (string3.startsWith("0x")) {
                    String[] stringArray = StringUtil.split2(string3, " ");
                    int n6 = stringArray.length;
                    byArray = new byte[n6];
                    for (int i2 = 0; i2 < n6; ++i2) {
                        String string4;
                        block11: {
                            block10: {
                                try {
                                    try {
                                        if (n2 != 0) break block9;
                                        if (!stringArray[i2].startsWith("0x")) break block10;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw PortExecutor.a(illegalArgumentException);
                                    }
                                    string4 = stringArray[i2].substring(2);
                                    break block11;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw PortExecutor.a(illegalArgumentException);
                                }
                            }
                            string4 = stringArray[i2];
                        }
                        String string5 = string4;
                        byArray[i2] = (byte)Integer.parseInt(string5, 16);
                        if (n2 == 0) continue;
                        break;
                    }
                } else {
                    byArray = StringUtil.toBytes(string2);
                }
            }
            return this.a(string, n5, n3, byArray, n4, nArray);
        }
        throw new IllegalArgumentException("No such result types " + Arrays.toString(nArray));
    }

    private ResultValue[] a(String string, int n2, int n3, byte[] byArray, int n4, int[] nArray) {
        ResultValue resultValue;
        HashMap<Integer, ResultValue> hashMap;
        block5: {
            hashMap = new HashMap<Integer, ResultValue>();
            int n5 = ExecutorHelper.b();
            long l2 = System.currentTimeMillis();
            ResultValue resultValue2 = null;
            resultValue2 = n4 == 0 ? this.a(string, n2, n3, byArray) : this.b(string, n2, n3, byArray);
            resultValue2.setResultType(PORT_CONTENT_MATCH);
            hashMap.put(PORT_CONTENT_MATCH, resultValue2);
            resultValue = QueryFactory.createResultValueObject();
            try {
                block4: {
                    try {
                        resultValue.setResultType(PORT_RESPONSE_TIME);
                        if (!resultValue2.isNormal()) break block4;
                        resultValue.setResultState("N");
                        resultValue.setValue(System.currentTimeMillis() - l2);
                        if (n5 != 0) break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw PortExecutor.a(illegalArgumentException);
                    }
                }
                resultValue.setResultState("E");
                resultValue.setValue(resultValue2.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw PortExecutor.a(illegalArgumentException);
            }
        }
        hashMap.put(PORT_RESPONSE_TIME, resultValue);
        return PerformanceServerUtil.getResultValues(nArray, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ResultValue a(String var1_1, int var2_2, int var3_3, byte[] var4_4) {
        block54: {
            var6_5 = null;
            var7_6 = null;
            var5_7 = ExecutorHelper.c();
            var8_8 = QueryFactory.createResultValueObject();
            var8_8.setResultState("E");
            try {
                block55: {
                    var6_5 = new Socket(var1_1, var2_2);
                    var6_5.setSoTimeout(var3_3);
                    var7_6 = new DataOutputStream(var6_5.getOutputStream());
                    var9_9 = var6_5.getInputStream();
                    var10_30 = 0;
                    var11_31 = null;
                    if (var4_4.length > 0) {
                        var7_6.write(var4_4);
                        var11_31 = new byte[2048];
                        var10_30 = var9_9.read(var11_31);
                    }
                    if (var10_30 >= 0) ** GOTO lbl25
                    try {
                        block56: {
                            var8_8.setValue(PortExecutor.PORT_IO_ERROR);
                            if (var5_7 == 0) break block54;
                            break block56;
                            catch (Exception v0) {
                                throw PortExecutor.a(v0);
                            }
                        }
                        if (var11_31 != null) break block55;
                    }
                    catch (Exception v1) {
                        throw PortExecutor.a(v1);
                    }
                    var11_31 = StringUtil.EMPTY_BYTES;
                }
                this.a(var8_8, var11_31, var10_30);
            }
            catch (SocketTimeoutException var9_12) {
                PortExecutor._logger.warn((Object)var9_12);
                this._errorbuf.append(var9_12);
                var8_8.setValue(PortExecutor.PORT_TIMEOUT);
            }
            catch (UnknownHostException var9_15) {
                PortExecutor._logger.warn((Object)var9_15);
                this._errorbuf.append(var9_15);
                var8_8.setValue(PortExecutor.PORT_UNKNOWN_HOST);
            }
            catch (ConnectException var9_18) {
                this._errorbuf.append(var9_18);
                var8_8.setValue(PortExecutor.PORT_IO_ERROR);
            }
            catch (SocketException var9_21) {
                PortExecutor._logger.warn((Object)var9_21);
                this._errorbuf.append(var9_21);
                var8_8.setValue(PortExecutor.PROTOCOL_ERROR);
            }
            catch (IOException var9_24) {
                PortExecutor._logger.warn((Object)var9_24);
                this._errorbuf.append(var9_24);
                var8_8.setValue(PortExecutor.PORT_IO_ERROR);
            }
            catch (Exception var9_27) {
                PortExecutor._logger.warn((Object)var9_27);
                this._errorbuf.append(var9_27);
                var8_8.setValue(PortExecutor.PORT_UNKNOWN_ERROR);
            }
            finally {
                if (var7_6 != null) {
                    try {
                        var7_6.close();
                    }
                    catch (Exception var9_13) {}
                }
                if (var6_5 != null) {
                    try {
                        var6_5.close();
                    }
                    catch (Exception var9_14) {}
                }
            }
        }
        return var8_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultValue b(String string, int n2, int n3, byte[] byArray) {
        DatagramSocket datagramSocket = null;
        ResultValue resultValue = QueryFactory.createResultValueObject();
        resultValue.setResultState("E");
        try {
            datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(n3);
            InetAddress inetAddress = InetAddress.getByName(string);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n2);
            datagramSocket.send(datagramPacket);
            byte[] byArray2 = new byte[2048];
            DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length);
            datagramSocket.receive(datagramPacket2);
            int n4 = datagramPacket2.getLength();
            this.a(resultValue, datagramPacket2.getData(), n4);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            _logger.warn((Object)socketTimeoutException);
            this._errorbuf.append(socketTimeoutException);
            resultValue.setValue(PORT_TIMEOUT);
        }
        catch (SocketException socketException) {
            _logger.warn((Object)socketException);
            this._errorbuf.append(socketException);
            resultValue.setValue(PROTOCOL_ERROR);
        }
        catch (UnknownHostException unknownHostException) {
            _logger.warn((Object)unknownHostException);
            this._errorbuf.append(unknownHostException);
            resultValue.setValue(PORT_UNKNOWN_HOST);
        }
        catch (IOException iOException) {
            _logger.warn((Object)iOException);
            this._errorbuf.append(iOException);
            resultValue.setValue(PORT_IO_ERROR);
        }
        catch (Exception exception) {
            _logger.warn((Object)exception);
            this._errorbuf.append(exception);
            resultValue.setValue(PORT_UNKNOWN_ERROR);
        }
        finally {
            if (datagramSocket != null) {
                try {
                    datagramSocket.close();
                }
                catch (Exception exception) {}
            }
        }
        return resultValue;
    }

    private void a(ResultValue resultValue, byte[] byArray, int n2) throws Exception {
        String string = new String(byArray, 0, n2, "ISO-8859-1");
        resultValue.setValue(string);
        resultValue.setResultState("N");
    }

    static {
        try {
            PORT_RESPONSE_TIME = ExecutorHelper.getId("PORT_RESPONSE_TIME");
            PORT_CONTENT_MATCH = ExecutorHelper.getId("PORT_CONTENT_MATCH");
            RESULT_TYPES_1 = new int[]{PORT_RESPONSE_TIME, PORT_CONTENT_MATCH};
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

