/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MonitorReader {
    private static Logger _logger = Logger.getLogger((String)MonitorReader.class.getName());
    public static final int RESERVED_ID_COUNT = 10;

    private MonitorReader() {
    }

    public static List getScheduleList(Connection connection, long l2) throws SQLException {
        ArrayList<Monitor> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            arrayList = new ArrayList<Monitor>();
            int n2 = ExecutorHelper.c();
            try {
                String string = "SELECT schedule_id_c, schedule_name_c, start_date_time_c, end_date_time_c, period_c, repetitions_c, is_suspended_c, period_unit_c, multiple_c, resume_time_c, group_id_c, is_expired_c, type_c FROM PM_SCHEDULE WHERE group_id_c =?";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Monitor monitor = TargetFactory.getSchedule();
                    try {
                        MonitorReader.a(monitor, resultSet);
                        arrayList.add(monitor);
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw MonitorReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_schedule to set schedule data " + sQLException.toString());
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    public static int getScheduleCount(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n2 = -1;
        try {
            String string = "SELECT COUNT(*) FROM PM_SCHEDULE";
            preparedStatement = connection.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_schedule to get count " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return n2;
    }

    public static void setSchedule(Connection connection, Monitor monitor, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "SELECT schedule_id_c, schedule_name_c, start_date_time_c, end_date_time_c, period_c, repetitions_c, is_suspended_c, period_unit_c, multiple_c, resume_time_c, group_id_c, is_expired_c, type_c FROM PM_SCHEDULE WHERE SCHEDULE_ID_C =?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                if (resultSet.next()) {
                    MonitorReader.a(monitor, resultSet);
                }
            }
            catch (SQLException sQLException) {
                throw MonitorReader.a(sQLException);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_schedule to set schedule data " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    private static void a(Monitor monitor, ResultSet resultSet) throws SQLException {
        monitor.setScheduleId(resultSet.getInt(1));
        String string = resultSet.getString(2);
        monitor.setScheduleName(string);
        long l2 = resultSet.getLong(3);
        monitor.setStartDateTime(l2);
        long l3 = resultSet.getLong(4);
        monitor.setEndDateTime(l3);
        long l4 = resultSet.getLong(5);
        Logger.getLogger(MonitorReader.class).debug((Object)("Monitor reader.setScheduleObject, period is " + l4));
        monitor.setPeriod(l4);
        int n2 = resultSet.getInt(6);
        monitor.setRepetitions(n2);
        boolean bl2 = SqlUtil.getBoolean(resultSet, 7);
        monitor.setSuspended(bl2);
        short s2 = resultSet.getShort(8);
        monitor.setUnit(s2);
        short s3 = resultSet.getShort(9);
        monitor.setMultiple(s3);
        long l5 = resultSet.getLong(10);
        monitor.setResumeTime(l5);
        long l6 = resultSet.getLong(11);
        monitor.setGroupId(l6);
        boolean bl3 = SqlUtil.getBoolean(resultSet, 12);
        monitor.setExpired(bl3);
        int n3 = resultSet.getInt(13);
        monitor.setMonitorType(n3);
    }

    public static List getScheduleNameList(Connection connection) throws SQLException {
        ArrayList<String> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            arrayList = new ArrayList<String>();
            int n2 = ExecutorHelper.c();
            try {
                String string = "SELECT SCHEDULE_NAME_C FROM PM_SCHEDULE";
                preparedStatement = connection.prepareStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        arrayList.add(resultSet.getString(1));
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw MonitorReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_schedule to get schedule name " + sQLException);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    public static List getScheduleNameList(Connection connection, long l2) throws SQLException {
        ArrayList<String> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            arrayList = new ArrayList<String>();
            int n2 = ExecutorHelper.c();
            try {
                String string = "SELECT SCHEDULE_NAME_C FROM PM_SCHEDULE WHERE SCHEDULE_ID_C BETWEEN ? AND ?";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l2 + 100000L);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        arrayList.add(resultSet.getString(1));
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw MonitorReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_schedule to get schedule name " + sQLException);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    public static List getScheduleIdList(Connection connection) throws SQLException {
        ArrayList<Integer> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            int n2 = ExecutorHelper.c();
            arrayList = new ArrayList<Integer>();
            try {
                String string = "SELECT SCHEDULE_ID_C FROM PM_SCHEDULE";
                preparedStatement = connection.prepareStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        arrayList.add(resultSet.getInt(1));
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw MonitorReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_schedule to get schedule id " + sQLException);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    public static List<Monitor> getScheduleDataList(Connection connection) throws SQLException {
        return MonitorReader.getScheduleDataList(connection, -1L, -1);
    }

    /*
     * Unable to fully structure code
     */
    public static List<Monitor> getScheduleDataList(Connection var0, long var1_1, int var3_2) throws SQLException {
        block20: {
            var5_3 = null;
            var6_4 = new ArrayList<Monitor>();
            var4_5 = ExecutorHelper.c();
            try {
                block19: {
                    var7_6 = "SELECT schedule_id_c, schedule_name_c, start_date_time_c, end_date_time_c, period_c, repetitions_c, is_suspended_c, period_unit_c, multiple_c, resume_time_c, group_id_c, is_expired_c, type_c FROM PM_SCHEDULE ";
                    try {
                        if (var1_1 != -1L && var3_2 != -1) {
                        }
                        ** GOTO lbl15
                    }
                    catch (SQLException v0) {
                        throw MonitorReader.a(v0);
                    }
                    var7_6 = (String)var7_6 + "WHERE schedule_id_c BETWEEN " + var1_1 + "AND " + (var1_1 + 100000L) + " AND type_c=" + var3_2;
                    try {
                        if (var4_5 == 0) break block19;
lbl15:
                        // 2 sources

                        if (var1_1 != -1L) {
                        }
                        ** GOTO lbl23
                    }
                    catch (SQLException v1) {
                        throw MonitorReader.a(v1);
                    }
                    var7_6 = (String)var7_6 + "WHERE schedule_id_c BETWEEN " + var1_1 + "AND " + (var1_1 + 100000L);
                    try {
                        if (var4_5 == 0) break block19;
lbl23:
                        // 2 sources

                        if (var3_2 != -1) {
                        }
                        ** GOTO lbl31
                    }
                    catch (SQLException v2) {
                        throw MonitorReader.a(v2);
                    }
                    var7_6 = (String)var7_6 + "WHERE type_c=" + var3_2;
                    try {
                        if (var4_5 == 0) break block19;
lbl31:
                        // 2 sources

                        if (var1_1 != -1L) break block19;
                    }
                    catch (SQLException v3) {
                        throw MonitorReader.a(v3);
                    }
                    var7_6 = (String)var7_6 + "WHERE schedule_id_c > 10";
                }
                var5_3 = var0.prepareStatement((String)var7_6);
                var8_8 = var5_3.executeQuery();
                while (var8_8.next()) {
                    var9_9 = TargetFactory.getSchedule();
                    try {
                        MonitorReader.a(var9_9, var8_8);
                        var6_4.add(var9_9);
                        if (var4_5 == 0) {
                            if (var4_5 == 0) continue;
                            break;
                        }
                        break block20;
                    }
                    catch (SQLException v4) {
                        throw MonitorReader.a(v4);
                    }
                }
            }
            catch (SQLException var7_7) {
                try {
                    throw new SQLException("Read pm_schedule to get schedule data list " + var7_7);
                }
                catch (Throwable var10_10) {
                    DefaultConnection.closeStatement(var5_3);
                    throw var10_10;
                }
            }
            DefaultConnection.closeStatement(var5_3);
        }
        return var6_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxScheduleID() {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String string = "select max(schedule_id_c) from pm_schedule;";
            preparedStatement = connection.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                return n2;
            }
            int n3 = 0;
            return n3;
        }
        catch (Exception exception) {
            _logger.error((Object)"insert", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, null, "in update method");
        }
        return -1;
    }

    public static int getScheduleId(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n2 = -1;
        try {
            String string2 = "SELECT SCHEDULE_ID_C FROM PM_SCHEDULE WHERE SCHEDULE_NAME_C =?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_schedule to get schedule_id " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return n2;
    }

    public static String getScheduleName(Connection connection, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string = null;
        try {
            String string2 = "SELECT SCHEDULE_NAME_C FROM PM_SCHEDULE WHERE SCHEDULE_ID_C =?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setInt(1, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_schedule to get schedule_name " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return string;
    }

    public static Map getScheduleNameToId(Connection connection) throws SQLException {
        HashMap<String, Object> hashMap;
        block8: {
            PreparedStatement preparedStatement = null;
            int n2 = ExecutorHelper.c();
            hashMap = new HashMap<String, Object>();
            try {
                String string = "SELECT SCHEDULE_NAME_C, SCHEDULE_ID_C FROM PM_SCHEDULE ";
                preparedStatement = connection.prepareStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        hashMap.put(resultSet.getString(1), resultSet.getObject(2));
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw MonitorReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_schedule " + sQLException.toString());
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return hashMap;
    }

    public static Map getScheduleNameToIdFromProbe(Connection connection, int n2) throws SQLException {
        Hashtable<String, Object> hashtable;
        block8: {
            PreparedStatement preparedStatement = null;
            hashtable = new Hashtable<String, Object>();
            int n3 = ExecutorHelper.c();
            try {
                String string = "SELECT SCHEDULE_NAME_C, SCHEDULE_ID_C FROM PM_SCHEDULE WHERE SCHEDULE_ID_C BETWEEN ? AND ? ";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, (int)((long)n2 + 100000L));
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        hashtable.put(resultSet.getString(1), resultSet.getObject(2));
                        if (n3 == 0) {
                            if (n3 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw MonitorReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("read pm_schedule " + sQLException.toString());
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return hashtable;
    }

    public static List getMonitorIds(Connection connection, long l2) throws SQLException {
        ArrayList<Integer> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            arrayList = new ArrayList<Integer>();
            int n2 = ExecutorHelper.b();
            try {
                String string = "SELECT SCHEDULE_ID_C FROM PM_SCHEDULE WHERE GROUP_ID_C=?";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        arrayList.add(resultSet.getInt(1));
                        if (n2 != 0) {
                            if (n2 != 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw MonitorReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_schedule to get schedule ids " + sQLException);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List<Long> getMonitorIDsByProbe(Connection var0, long var1_1) throws SQLException {
        block6: {
            var4_2 = new ArrayList<Long>();
            var3_3 = ExecutorHelper.c();
            var5_4 = null;
            try {
                var6_5 = "SELECT schedule_id_c FROM PM_SCHEDULE WHERE SCHEDULE_ID_C BETWEEN ? AND ?";
                var5_4 = var0.prepareStatement(var6_5);
                var5_4.setLong(1, var1_1);
                var5_4.setLong(2, var1_1 + 100000L);
                var7_6 = var5_4.executeQuery();
                while (var7_6.next()) {
                    var8_7 = var7_6.getLong(1);
                    try {
                        var4_2.add(var8_7);
                        if (var3_3 == 0) {
                            if (var3_3 == 0) continue;
                            ** break;
                        }
                        break block6;
                    }
                    catch (SQLException v0) {
                        throw MonitorReader.a(v0);
                    }
                }
            }
            catch (Throwable var10_8) {
                DefaultConnection.closeStatement(var5_4);
                throw var10_8;
            }
lbl24:
            // 2 sources

            DefaultConnection.closeStatement(var5_4);
        }
        return var4_2;
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

