/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHost;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.SharedReader;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.ServerConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class MonitorHostWriter {
    private static long _pk = -1L;
    private static Logger _logger = Logger.getLogger((String)MonitorHostWriter.class.getName());

    public static synchronized void setupScheduleHostID() {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            MonitorHostWriter.setupScheduleHostID(connection);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to setup Schedule host id:", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static synchronized void setupScheduleHostID(Connection connection) {
        try {
            if (_pk != -1L) {
                return;
            }
        }
        catch (Exception exception) {
            throw MonitorHostWriter.a(exception);
        }
        try {
            long l2 = ServerConfig.getProbeID() + 100000L;
            String string = "SELECT MAX(SCHEDULE_HOST_ID_C) FROM PM_SCHEDULE_HOST WHERE SCHEDULE_HOST_ID_C < " + l2;
            try {
                _pk = SharedReader.getId(connection, string);
                if (_pk == 0L) {
                    _pk = ServerConfig.getProbeID();
                }
            }
            catch (Exception exception) {
                throw MonitorHostWriter.a(exception);
            }
            _logger.info((Object)("Monitor host id value: " + _pk));
        }
        catch (Exception exception) {
            _logger.error((Object)("Init metrics to get primary key. " + exception));
        }
    }

    private MonitorHostWriter() {
    }

    private static synchronized long a() {
        if (++_pk >= ServerConfig.getProbeID() + 100000L) {
            _pk = ServerConfig.getProbeID();
        }
        return _pk;
    }

    public static void storeScheduleHostDataList(Connection connection, Monitor monitor) throws SQLException {
        block7: {
            PreparedStatement preparedStatement = null;
            int n2 = monitor.getScheduleId();
            int n3 = ExecutorHelper.c();
            try {
                String string = "INSERT INTO PM_SCHEDULE_HOST (SCHEDULE_HOST_ID_C, SCHEDULE_ID_C, IP_ADDRESS_C) VALUES(?,?,?)";
                preparedStatement = connection.prepareStatement(string);
                int n4 = monitor.getScheduleHostListSize();
                for (int i2 = 0; i2 < n4; ++i2) {
                    long l2;
                    MonitorHost monitorHost;
                    block8: {
                        monitorHost = monitor.getScheduleHost(i2);
                        l2 = monitorHost.getScheduleHostId();
                        try {
                            if (n3 != 0) break block7;
                            if (l2 != -1L) break block8;
                        }
                        catch (SQLException sQLException) {
                            throw MonitorHostWriter.a(sQLException);
                        }
                        l2 = MonitorHostWriter.a();
                        monitorHost.setScheduleHostId(l2);
                    }
                    preparedStatement.setLong(1, l2);
                    preparedStatement.setInt(2, n2);
                    String string2 = monitorHost.getIpAddress().trim().toLowerCase();
                    _logger.info((Object)("To insert into pm_schedule_host, hostID:" + l2 + "; monitor ID:" + n2 + "; IP:" + string2));
                    preparedStatement.setString(3, string2);
                    preparedStatement.addBatch();
                    if (n3 == 0) continue;
                }
                preparedStatement.executeBatch();
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Store pm_schedule_host data list. Monitor:" + monitor);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

