/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Baseline;
import com.sysuptime.server.util.DefaultConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BaselineWriter {
    private BaselineWriter() {
    }

    public static void storeBaselineData(Connection connection, Baseline baseline) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "INSERT INTO PM_BASELINE(METRICS_ID_C, ROLLING_PERIOD_C, BASELINE_CONDITION_ID_C, BASELINE_THRESHOLD_C, PERIOD_UNIT_C) VALUES(?,?,?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            BaselineWriter.a(preparedStatement, baseline);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Store pm_baseline data " + sQLException);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    private static void a(PreparedStatement preparedStatement, Baseline baseline) throws SQLException {
        long l2 = baseline.getMetricsId();
        preparedStatement.setLong(1, l2);
        long l3 = baseline.getPeriod();
        preparedStatement.setLong(2, l3);
        short s2 = baseline.getBaselineConditionId();
        preparedStatement.setShort(3, s2);
        double d10 = baseline.getBaselineThreshold();
        preparedStatement.setDouble(4, d10);
        short s3 = baseline.getUnit();
        preparedStatement.setShort(5, s3);
    }
}

