/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.msp.master;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.sysuptime.common.msp.Probe;
import com.sysuptime.common.util.callback.CallbackServer;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.msp.Command;
import com.sysuptime.server.msp.ProbeDao;
import com.sysuptime.server.msp.master.ProbeManager$1;
import com.sysuptime.server.msp.master.ProbeSpace;
import com.sysuptime.server.util.LicenseServerProxy;
import com.sysuptime.server.util.ServerPropertiesFile;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProbeManager {
    public static final long TIMEOUT = 300000L;
    private static final Logger _logger = Logger.getLogger((String)ProbeManager.class.getName());
    public static final ProbeManager INSTANCE;
    private Map<Long, ProbeSpace> _probes = new Hashtable<Long, ProbeSpace>();
    private PooledExecutor _pool = new PooledExecutor();
    private static String a;

    private ProbeManager() {
    }

    private void a(ProbeSpace probeSpace) {
        Probe probe = probeSpace.getProbe();
        this._probes.put(probe.getId(), probeSpace);
        ProbeDao.getInstance().store(probe);
        CallbackServer.getInstance().notifyAllClients(null, "ProbeStatus");
    }

    public synchronized void removeProbe(Probe probe) {
        long l2 = probe.getLastSnapshot();
        ProbeSpace probeSpace = this._probes.get(probe.getId());
        if (probeSpace != null && probeSpace.getProbe().getLastSnapshot() == l2) {
            this._probes.remove(probe.getId());
            CallbackServer.getInstance().notifyAllClients(null, "ProbeStatus");
        }
    }

    public synchronized void removeFromLogoutCall(Probe probe) {
        ProbeSpace probeSpace = this._probes.get(probe.getId());
        if (probeSpace != null) {
            this._probes.remove(probe.getId());
            CallbackServer.getInstance().notifyAllClients(null, "ProbeStatus");
        }
    }

    public boolean registered(Probe probe) {
        try {
            if (probe.getId() == -1L) {
                return false;
            }
        }
        catch (SQLException sQLException) {
            throw ProbeManager.a(sQLException);
        }
        try {
            return ProbeDao.getInstance().exist(probe);
        }
        catch (SQLException sQLException) {
            _logger.error((Object)"", (Throwable)sQLException);
            return false;
        }
    }

    public boolean checkProbesCount() {
        return LicenseServerProxy.isValid("probeCount", ProbeDao.getInstance().getProbesCount() + 1);
    }

    public synchronized Probe login(ProbeSpace probeSpace) {
        Probe probe = probeSpace.getProbe();
        if (probe.getId() == -1L) {
            long l2 = ProbeDao.getInstance().generateID();
            probe.setId(l2);
            probe.setTime(System.currentTimeMillis());
        }
        this.a(probeSpace);
        GraphDao.addCustomer(probe);
        return probe;
    }

    public List<Probe> getActiveProbes() {
        ArrayList<Probe> arrayList;
        block2: {
            ArrayList<Probe> arrayList2 = new ArrayList<Probe>();
            String string = ProbeManager.b();
            for (ProbeSpace probeSpace : this._probes.values()) {
                Probe probe = probeSpace.getProbe();
                arrayList = arrayList2;
                if (string == null) {
                    arrayList.add(probe);
                    if (string == null) continue;
                }
                break block2;
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public List<Probe> getAllProbes() {
        List list;
        block2: {
            List list2 = ProbeDao.getInstance().getAllProbes();
            int n2 = list2.size();
            String string = ProbeManager.b();
            for (int i2 = 0; i2 < n2; ++i2) {
                list = list2;
                if (string == null) {
                    Probe probe = (Probe)list.get(i2);
                    probe.setActive(this.isActive(probe.getId()));
                    if (string == null) continue;
                }
                break block2;
            }
            list = list2;
        }
        return list;
    }

    public boolean isActive(long l2) {
        return !ServerPropertiesFile.isMaster() || l2 == 0L || this.a(l2);
    }

    private boolean a(long l2) {
        ProbeSpace probeSpace = this._probes.get(l2);
        return probeSpace != null;
    }

    public synchronized boolean containsSession(String string) {
        boolean bl2;
        block3: {
            Iterator<Map.Entry<Long, ProbeSpace>> iterator = this._probes.entrySet().iterator();
            String string2 = ProbeManager.b();
            while (iterator.hasNext()) {
                Map.Entry<Long, ProbeSpace> entry = iterator.next();
                ProbeSpace probeSpace = entry.getValue();
                bl2 = probeSpace.getSessionID().equals(string);
                if (string2 == null) {
                    if (bl2) {
                        return true;
                    }
                    if (string2 == null) continue;
                }
                break block3;
            }
            bl2 = false;
        }
        return bl2;
    }

    public synchronized Probe getProbeBySession(String string) {
        Iterator<Map.Entry<Long, ProbeSpace>> iterator = this._probes.entrySet().iterator();
        String string2 = ProbeManager.b();
        while (iterator.hasNext()) {
            Map.Entry<Long, ProbeSpace> entry = iterator.next();
            ProbeSpace probeSpace = entry.getValue();
            if (probeSpace.getSessionID().equals(string)) {
                return probeSpace.getProbe();
            }
            if (string2 == null) continue;
        }
        return null;
    }

    public ProbeSpace getProbeSpace(long l2) {
        return this._probes.get(l2);
    }

    public void sendCommand(Command command) throws IOException {
        ProbeSpace probeSpace = this.getProbeSpace(command.getProbeID());
        try {
            if (probeSpace != null) {
                probeSpace.sendCommand(command);
            }
        }
        catch (IOException iOException) {
            throw ProbeManager.a(iOException);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public synchronized void checkProbes() {
        boolean bl2;
        Object object;
        ArrayList<Probe> arrayList = new ArrayList<Probe>();
        Iterator<Map.Entry<Long, ProbeSpace>> iterator = this._probes.entrySet().iterator();
        String string = ProbeManager.b();
        while (iterator.hasNext()) {
            object = iterator.next();
            ProbeSpace probeSpace = object.getValue();
            probeSpace.decreaseLife();
            bl2 = probeSpace.isDead();
            if (string != null) return;
            if (bl2) {
                _logger.info((Object)("Dead Probe: " + probeSpace.getProbe().getId()));
                Probe probe = probeSpace.getProbe();
                arrayList.add(probe);
            }
            if (string == null) continue;
        }
        iterator = arrayList.iterator();
        do {
            bl2 = iterator.hasNext();
            if (!bl2) return;
            object = (Probe)((Object)iterator.next());
            this.removeProbe((Probe)object);
        } while (string == null);
    }

    public synchronized boolean echo(String string) {
        boolean bl2;
        block5: {
            Iterator<Map.Entry<Long, ProbeSpace>> iterator = this._probes.entrySet().iterator();
            String string2 = ProbeManager.b();
            while (iterator.hasNext()) {
                block6: {
                    Map.Entry<Long, ProbeSpace> entry = iterator.next();
                    ProbeSpace probeSpace = entry.getValue();
                    try {
                        bl2 = string.equals(probeSpace.getSessionID());
                        if (string2 != null) break block5;
                        if (!bl2) break block6;
                    }
                    catch (IOException iOException) {
                        throw ProbeManager.a(iOException);
                    }
                    try {
                        probeSpace.resetLife();
                        probeSpace.echo();
                    }
                    catch (IOException iOException) {
                        _logger.error((Object)"", (Throwable)iOException);
                    }
                }
                if (string2 == null) continue;
            }
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send2All(Command command) {
        Map<Long, ProbeSpace> map = this._probes;
        synchronized (map) {
            String string = ProbeManager.b();
            for (Map.Entry<Long, ProbeSpace> entry : this._probes.entrySet()) {
                ProbeSpace probeSpace = entry.getValue();
                try {
                    this._pool.execute((Runnable)new ProbeManager$1(this, probeSpace, command));
                    if (string != null) break;
                }
                catch (InterruptedException interruptedException) {
                    _logger.error((Object)"", (Throwable)interruptedException);
                }
                if (string == null) continue;
            }
            return;
        }
    }

    public void clear() {
        this._probes.clear();
    }

    static {
        ProbeManager.b(null);
        INSTANCE = new ProbeManager();
    }

    public static void b(String string) {
        a = string;
    }

    public static String b() {
        return a;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

