/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.login;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.login.Organization;
import com.sysuptime.common.login.ResponseUserManage;
import com.sysuptime.common.login.User;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.login.LoginMBean;
import com.sysuptime.server.login.OrgViewRelationDao;
import com.sysuptime.server.login.OrganizationDao;
import com.sysuptime.server.login.UserDBProcessor;
import com.sysuptime.server.login.UserOrgRelationDao;
import com.sysuptime.server.msp.Command;
import com.sysuptime.server.util.LicenseServerProxy;
import com.sysuptime.server.util.ServerConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Login
implements LoginMBean {
    private static final Logger _logger = Logger.getLogger((String)Login.class.getName());
    private static final Object[] CHANGE_PASSWORD = new Object[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
    private static final Object[] APPLICATIONS = new Object[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE};

    @Override
    public RmiResponse login(String string, String string2) {
        return this.login(string, string2, false);
    }

    @Override
    public RmiResponse login(String string, String string2, boolean bl2) {
        User user = UserDBProcessor.login(string, string2, bl2);
        return new RmiResponse(user);
    }

    @Override
    public boolean insertOrgViewRelation(List list, String string) {
        return OrgViewRelationDao.insert(list, string);
    }

    @Override
    public List getAllUsers() {
        return UserDBProcessor.getAllUsers();
    }

    @Override
    public ResponseUserManage addUser(User user) {
        return UserDBProcessor.addUser(user);
    }

    @Override
    public ResponseUserManage deleteUser(String string) {
        return UserDBProcessor.deleteDBdata(string);
    }

    @Override
    public ResponseUserManage modifyUserInfo(User user) {
        try {
            return UserDBProcessor.modifyUserInfo(user);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean changePassword(String string, String string2) {
        return UserDBProcessor.changePassword(string, string2);
    }

    @Override
    public String getImplementationVersion() {
        Package package_ = Package.getPackage("com.sysuptime.server.login");
        String string = package_.getImplementationVersion();
        if (string == null) {
            string = "1.0.0";
        }
        return string;
    }

    @Override
    public byte[] getJarFile(String object) {
        String string = AppUtil.getAppServerHomeDirectory();
        object = string + (String)object;
        try {
            File file = new File((String)object);
            byte[] byArray = new byte[(int)file.length()];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream((String)object));
            bufferedInputStream.read(byArray, 0, byArray.length);
            bufferedInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            _logger.error((Object)((String)object + " not found."), (Throwable)exception);
            return null;
        }
    }

    @Override
    public Object[][] getPermissions(boolean bl2) {
        Object[][] objectArray;
        block12: {
            Object[][] objectArray2 = null;
            int[] nArray = OrgViewRelationDao.b();
            Object[] objectArray3 = this.getAdministratorPermissions();
            if (objectArray3 != null) {
                int n2;
                Object[] objectArray4;
                block11: {
                    Object[] objectArray5;
                    block10: {
                        objectArray5 = this.getOperatorPermissions();
                        objectArray4 = this.getObserverPermissions();
                        if (!bl2) {
                            objectArray2 = new Object[7][3];
                            n2 = objectArray3.length;
                            if (n2 > 8) {
                                Login.CHANGE_PASSWORD[0] = objectArray3[7];
                                Login.CHANGE_PASSWORD[1] = objectArray5[7];
                                Login.CHANGE_PASSWORD[2] = objectArray4[7];
                                Login.APPLICATIONS[0] = objectArray3[8];
                                Login.APPLICATIONS[1] = objectArray5[8];
                                Login.APPLICATIONS[2] = objectArray4[8];
                            }
                        } else {
                            objectArray2 = new Object[9][3];
                        }
                        for (n2 = 0; n2 < objectArray2.length; ++n2) {
                            objectArray2[n2][0] = objectArray3[n2];
                            if (nArray != null) {
                                if (nArray != null) continue;
                            }
                            break block10;
                        }
                        n2 = 0;
                    }
                    while (n2 < objectArray2.length) {
                        objectArray2[n2][1] = objectArray5[n2];
                        ++n2;
                        if (nArray != null) {
                            if (nArray != null) continue;
                        }
                        break block11;
                    }
                    n2 = 0;
                }
                while (n2 < objectArray2.length) {
                    objectArray = objectArray2;
                    if (nArray != null) {
                        objectArray[n2][2] = objectArray4[n2];
                        ++n2;
                        if (nArray != null) continue;
                    }
                    break block12;
                }
            }
            objectArray = objectArray2;
        }
        return objectArray;
    }

    @Override
    public Object[][] getPermissions() {
        return this.getPermissions(false);
    }

    @Override
    public boolean savePermissions(Object[][] objectArray, boolean bl2) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3;
        boolean bl3;
        block9: {
            StringBuffer stringBuffer4;
            int[] nArray;
            block8: {
                StringBuffer stringBuffer5;
                block7: {
                    bl3 = true;
                    stringBuffer3 = new StringBuffer();
                    nArray = OrgViewRelationDao.b();
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        stringBuffer3.append(this.a(objectArray[i2][0]));
                        stringBuffer5 = stringBuffer3.append(",");
                        if (nArray != null) {
                            if (nArray != null) continue;
                            Command.b(new int[3]);
                            break;
                        }
                        break block7;
                    }
                    stringBuffer5 = new StringBuffer();
                }
                stringBuffer2 = stringBuffer5;
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    stringBuffer2.append(this.a(objectArray[i3][1]));
                    stringBuffer4 = stringBuffer2.append(",");
                    if (nArray != null) {
                        if (nArray != null) continue;
                    }
                    break block8;
                }
                stringBuffer4 = new StringBuffer();
            }
            stringBuffer = stringBuffer4;
            for (int i4 = 0; i4 < objectArray.length; ++i4) {
                stringBuffer.append(this.a(objectArray[i4][2]));
                stringBuffer.append(",");
                if (nArray != null) {
                    if (nArray != null) continue;
                }
                break block9;
            }
            if (!bl2) {
                stringBuffer3.append(this.a(CHANGE_PASSWORD[0]));
                stringBuffer3.append(",");
                stringBuffer2.append(this.a(CHANGE_PASSWORD[1]));
                stringBuffer2.append(",");
                stringBuffer.append(this.a(CHANGE_PASSWORD[2]));
                stringBuffer.append(",");
                stringBuffer3.append(this.a(APPLICATIONS[0]));
                stringBuffer3.append(",");
                stringBuffer2.append(this.a(APPLICATIONS[1]));
                stringBuffer2.append(",");
                stringBuffer.append(this.a(APPLICATIONS[2]));
                stringBuffer.append(",");
            }
        }
        bl3 = bl3 && ServerConfig.updateProperty("permissions.administrator", stringBuffer3.toString());
        bl3 = bl3 && ServerConfig.updateProperty("permissions.operator", stringBuffer2.toString());
        bl3 = bl3 && ServerConfig.updateProperty("permissions.observer", stringBuffer.toString());
        return bl3;
    }

    @Override
    public boolean savePermissions(Object[][] objectArray) {
        return this.savePermissions(objectArray, false);
    }

    private String a(Object object) {
        if (object.equals(Boolean.TRUE)) {
            return "1";
        }
        return "0";
    }

    private Object a(String string) {
        if (string.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object[] getAdministratorPermissions() {
        Object[] objectArray;
        Object[] objectArray2 = null;
        String string = ServerConfig.getProperty("permissions.administrator");
        int[] nArray = OrgViewRelationDao.b();
        if (string != null) {
            String[] stringArray = StringUtil.split(string, ",");
            objectArray2 = new Object[stringArray.length];
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                objectArray = objectArray2;
                if (nArray != null) {
                    objectArray[i2] = this.a(stringArray[i2]);
                    if (nArray != null) continue;
                }
                break;
            }
        } else {
            objectArray = objectArray2;
        }
        return objectArray;
    }

    @Override
    public Object[] getOperatorPermissions() {
        Object[] objectArray;
        Object[] objectArray2 = null;
        String string = ServerConfig.getProperty("permissions.operator");
        int[] nArray = OrgViewRelationDao.b();
        if (string != null) {
            String[] stringArray = StringUtil.split(string, ",");
            objectArray2 = new Object[stringArray.length];
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                objectArray = objectArray2;
                if (nArray != null) {
                    objectArray[i2] = this.a(stringArray[i2]);
                    if (nArray != null) continue;
                }
                break;
            }
        } else {
            objectArray = objectArray2;
        }
        return objectArray;
    }

    @Override
    public Object[] getObserverPermissions() {
        Object[] objectArray;
        Object[] objectArray2 = null;
        int[] nArray = OrgViewRelationDao.b();
        String string = ServerConfig.getProperty("permissions.observer");
        if (string != null) {
            String[] stringArray = StringUtil.split(string, ",");
            objectArray2 = new Object[stringArray.length];
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                objectArray = objectArray2;
                if (nArray != null) {
                    objectArray[i2] = this.a(stringArray[i2]);
                    if (nArray != null) continue;
                }
                break;
            }
        } else {
            objectArray = objectArray2;
        }
        return objectArray;
    }

    @Override
    public int hasValidLicense() {
        return LicenseServerProxy.hasValidLicense();
    }

    @Override
    public int applyLicense(String string) {
        return LicenseServerProxy.applyLicense(string);
    }

    @Override
    public String getLicense(String string) {
        return ServerConfig.getLicenseProperty(string);
    }

    @Override
    public Properties getLicenseInfo() {
        return ServerConfig.getLicenseProperties();
    }

    @Override
    public String getDatabaseInitializedValue() {
        return ServerConfig.getProperty("database.initialized");
    }

    @Override
    public RmiResponse getOrganizations() {
        try {
            return OrganizationDao.getOrganizations();
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public boolean addOrganization(Organization organization) {
        try {
            return OrganizationDao.addOrganization(organization);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean removeOrganization(Organization organization) {
        try {
            return OrganizationDao.removeOrganization(organization);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean modifyOrganization(Organization organization) {
        try {
            return OrganizationDao.modifyOrganization(organization);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    @Override
    public List getOrgNamesByUsername(String string) {
        return UserOrgRelationDao.getOrgNamesByUsername(string);
    }

    @Override
    public List getViewNamesByOrgName(String string) {
        return OrgViewRelationDao.getViewIDsByOrg(string);
    }

    @Override
    public List getViewsByUser(String string, boolean bl2) {
        if (bl2) {
            return GraphDao.getAllGraphDatas();
        }
        return GraphDao.getViewsByUser(string);
    }

    @Override
    public Boolean hasGraphView(GraphID graphID) {
        return GraphDao.hasGraphView(graphID);
    }

    @Override
    public String getCustomerName() {
        return ServerConfig.getProperty("msp.customerName");
    }

    @Override
    public void setCustomerName(String string) {
        ServerConfig.updateProperty("msp.customerName", string);
    }

    @Override
    public String getCustomerID() {
        return ServerConfig.getCustomerID();
    }

    @Override
    public long getProbeID() {
        return ServerConfig.getProbeID();
    }

    @Override
    public boolean isMspEdition() {
        return false;
    }

    @Override
    public boolean isMaster() {
        return true;
    }
}

